CaseData[27] = {
    "title": "Case 27 - 8 day old premature infant for laparotomy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 0.2, 
    "debriefMsg": "\nThis patient is severely dehydrated. You should administer boluses of 20 mL/kg of intravenous fluids prior to induction since hypovolemic patients can become extremely hypotensive on induction. Monitor blood glucose, potassium, calcium and pH. Titrate pancuronium, fentanyl and oxygen in air for the anesthetic.closely.\n\n", 
    "depthCarina": 13, 
    "depthCords": 8, 
    "depthTubeInitial": 10, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 8, 
    "initialSat": 90, 
    "leanBodyMass": 1.2, 
    "learningObj": "\n8 day old premature infant for laparotomy (1200 gm)\n\nThis premature infant, born at 32 weeks gestational age, requires laparotomy for necrotizing enterocolitis.\n\nLearning Objectives\n1.  Understand the pathophysiologic changes in preterm infant who is critically ill secondary to intestinal perforation and sepsis.\n2.  Understand the importance of the preoperative preparation of such a patient.\n3.  Understand the principles of anesthesia management for a critically ill preterm infant.\n\nPathophysiology\nThe exact etiology of NEC is unknown. It has been suggested that the principle factors involved are bowel ischemia which leads to intestinal mucosal injury, enteral feedings which provide substrate, and the presence of pathogens. Fluid shifts into the diseased bowel result in hypovolemia which compounds the bowel ischemia.\n\nNecrotizing enterocolitis is the most common gastrointestinal emergency of the neonatal period. It is most common in low birth weight prematures and rare in those born with conceptual age more than 35 weeks. It occurs sporadically in the NICU, but occasionally epidemics will occur. During epidemics a different population of infants may be affected (larger, more mature), the mortality rate may be lower, and infective agents (bacteria, viruses) may be implicated.\n\n1.  Several stages of the disease have been described:\nStage I. (Suspect NEC) Suggestive clinical signs and symptoms but nondiagnostic radiologic findings.\nStage II. (Definite NEC) Radiologic evidence present i.e. interstitial air on abdominal radiographs.\nStage IIA. Mildly ill\nStage IIB. Severely ill with acidosis, thrombocytopenia, or ascites  \nStage III. (Advanced NEC) Impending or actual perforation of the bowel\n2.  Necrotizing enterocolitis has a high mortality rate. It may also be followed by the serious complication of short gut syndrome.\n\nRecommended Treatment\n1.  Treatment of NEC is conservative with gastric decompression, withholding feedings, antibiotics and other measures as required. Surgery is indicated for perforation or if the presence of ischemic bowel is suspected.\n2. Successful anesthesia depends on good preoperative correction of fluid deficits, coagulopathy, and metabolc status, plus obsessive intraoperative attention to the details of neonatal care and continued volume replacement.\n\nSuggested Preoperative Anesthetic Management\n1.  Ensure adequate preoperative fluid resuscitation in a patient who is in shock, septic, and is prone to pulmonary congestion and congestive cardiac failure. Fluid volumes should be replaced to ensure a urine flow of 1-2 ml/kg/hr. \n2.  Dextrose 10% should be infused to provide 5-7 mg/kg per min of dextrose and maintain the blood glucose between 50 and 100 mg/dl. Check blood glucose frequently.\n3.  5% albumin should be administered to correct hypoproteinemia. \n4.  Erythrocyte transfusions should be given to maintain the hematocrit at 35-40%. \n5.  Continuing metabolic acidosis despite adequate arterial oxygenation suggests hypovolemia. Frequent monitoring of acid/base and blood gases is required. \n6.  Inotropes may be required with dopamine at 3-5 ug/kg/min preferred.\n7.  Correct the coagulation status preoperatively as much as possible. This will require infusions of fresh frozen plasma (10 ml/kg) and platelets (not included in the simulator). Note that the fresh frozen plasma and platelets contain citrate and may reduce ionized calcium levels.\n8.  Hypocalcemia leads to hypotension. Calcium chloride 10 mg/kg should be administered to treat hypotension which persists despite adequate fluid replacement. Calcium should be given via a central line due to the danger of tissue necrosis with extravasation from peripheral lines.\n9.  The respiratory status must be considered. Respiratory distress syndrome and its sequelae may be present.\n\nSuggested Intraoperative Anesthetic Management\n1.  Maintain body temperature:\na. Warm the room\nb. Heating blankets\nc. Overhead radiant heater\nd. Warm air blankets\ne. Heated humidified gases\nf. Thermal head covering\ng. Warmed skin prep solutions\nh. Warmed IV fluids\n2.  Provide anesthesia to a very unstable infant. Inotropes should be continued or added as necessary. Volatile agents will be tolerated poorly. Pancuronium, fentanyl and oxygen in air is preferred. Nitrous oxide is contraindicated due to air in the bowel.\n3.  These infants are at high risk for development of retinopathy of prematurity. Unnecessary oxygen administration should be avoided. Oxygen should be added and mixed with air in concentrations to ensure arterial saturation of 90-95%. Sometimes if the pulse oximeter becomes unreliable it is wise to increase the oxygen concentration until the patient's status becomes more stable. \n4.  Severe fluid shifts may occur intraoperatively, especially as the abdomen is opened. Hypotension secondary to these shifts may require large volumes of blood, plasma, and crystalloid transfusion intraoperatively. Volume replacement must be titrated against the hemodynamic parameters and urine output.\n\nSuggested Postoperative Anesthetic Management\n1.  Continued cardiorespiratory support will be required.\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: March 27, 2013\n\n", 
    "possiblePoints": 1000, 
    "preopMsg": "\n8 day old premature infant for laparotomy\n\nHistory of Present Illness\nThis child was born at 32 weeks gestational age. There is a history of birth asphyxia and of respiratory distress which required 2 days of C.P.A.P. Several episodes of apnea occurred which responded to stimulation. Abdominal distension was first noted 3 days ago and treated with gastric decompression, fluid therapy, and antibiotics. Condition has worsened in last 24 hours.\n\nPast Medical History\nMeds: none\nAllergies: none\n\n\nFamily History\nNo family history of anesthetic problems.\n\nPhysical Exam\nWt: 1200 gm   HR: 138    BP: 58/30    RR: 36\nAirway: normal\nLungs: clear\nHeart: no murmurs\nDistended abdomen\n\nLabs\nHct: 36    \nPlatelets: 57,000 (down from 200,000 3 days ago)\nAbdominal X-ray: pneumoperitoneum, dilated loops of bowel, gas in portal system\n\nNPO Status\nThe patient has been NPO for days.\n\nPatient and Surgeon Requests\nImmediate surgery is planned.\n\n", 
    "volAnDsp": 2, 
    "states": [
        {
            "name": "VERYDRY", 
            "whatNextMsg": "Rehydrate with at least 24 mL (20 mL/kg) of normal saline, then reassess.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 34, 
            "baseAbpS": 52, 
            "baseBicarb": 18.8, 
            "baseHr": 180, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The patient is breathing rapidly.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 68, 
            "hct": 32, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is restless.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is weak and rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Severely hypovolemic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool and has slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 180, 
            "spSignal": 1, 
            "spontRr": 36, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUIDS1", 
                    "comment": "You partially rehydrated the patient appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 19
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 29
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUIDS1", 
                    "comment": "You administered a bolus of fluid greater than 20 mL/kg. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 28
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATEVERYDRY", 
                    "comment": "You administered a sedative agent. (+50 of 100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "FLUIDS1", 
                    "comment": "You waited too long to administer intravenous fluids. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 600
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "FLUIDS1", 
            "whatNextMsg": "Continue to administer fluids until vital signs stabilize.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 36, 
            "baseAbpS": 54, 
            "baseBicarb": 19.4, 
            "baseHr": 150, 
            "basePot": 4.4, 
            "breathSoundsMsg": "The patient is breathing rapidly.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 64, 
            "hct": 44, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is fussy.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is stronger but still fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Partially rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 150, 
            "spSignal": 2, 
            "spontRr": 30, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUIDS2", 
                    "comment": "You adequately rehydrated the patient . (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 40
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 61
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUIDS2", 
                    "comment": "You administered excessive intravenous fluid. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 60
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "FLUIDS2", 
            "whatNextMsg": "Preoxygenate, induce general anesthesia and intubate. Consider etomidate over propofol to reduce severity of hypotension.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 38, 
            "baseAbpS": 56, 
            "baseBicarb": 20.2, 
            "baseHr": 130, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 62, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is crying.", 
            "papD": 6, 
            "papM": 8, 
            "papS": 12, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 130, 
            "spSignal": 3, 
            "spontRr": 30, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEVERYDRY", 
            "whatNextMsg": "Rehydrate this patient with 20 mL/kg.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 24, 
            "baseAbpM": 32, 
            "baseAbpS": 50, 
            "baseBicarb": 15.8, 
            "baseHr": 178, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 48, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is fast but weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated but hypovolemia untreated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 178, 
            "spSignal": 1, 
            "spontRr": 20, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia before replacing intravascular volume. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You partially rehydrated the patient appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 19
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 29
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You administered a bolus of fluid greater than 20 mL/kg. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 28
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEFLUIDS1", 
            "whatNextMsg": "Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 36, 
            "baseAbpS": 52, 
            "baseBicarb": 16.2, 
            "baseHr": 148, 
            "basePot": 4.3, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 60, 
            "hct": 44, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is fast and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Partially rehydrated and sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 148, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You adequately rehydrated the patient . (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 40
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 61
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You administered excessive intravenous fluid. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 60
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPFLUIDS1", 
                    "comment": "You induced anesthesia prior to adequately replacing volume. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an under anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You administered muscle relaxant before completely inducing unconsciousness. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an under anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEFLUIDS2", 
            "whatNextMsg": "Preoxygenate, induce anesthesia and intubate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 36, 
            "baseAbpS": 54, 
            "baseBicarb": 18.2, 
            "baseHr": 128, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 58, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 6, 
            "papM": 8, 
            "papS": 12, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 128, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1", 
                    "comment": "You induced anesthesia after adequately treating hypovolemia.  (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 36, 
            "baseAbpS": 56, 
            "baseBicarb": 15.6, 
            "baseHr": 182, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 58, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is coughing and bucking.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 182, 
            "spSignal": 2, 
            "spontRr": 42, 
            "spontTv": 5, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VERYDRY", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Administer narcotic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 40, 
            "baseAbpS": 58, 
            "baseBicarb": 15.6, 
            "baseHr": 184, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 58, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is writhing in pain.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 184, 
            "spSignal": 2, 
            "spontRr": 42, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VERYDRY", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia before adequately replacing volume. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PARA5", 
            "whatNextMsg": "You are lucky this kid can't talk.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 38, 
            "baseAbpS": 56, 
            "baseBicarb": 15.6, 
            "baseHr": 182, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 68, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 3, 
            "pulseMsg": "The pulse is fast", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 182, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VERYDRY", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia without adequately replacing volume. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPVERYDRY", 
            "whatNextMsg": "Resuscitate with volume replacement (20 mL/kg) and pressors.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 22, 
            "baseAbpM": 30, 
            "baseAbpS": 48, 
            "baseBicarb": 15.6, 
            "baseHr": 176, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 58, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized without adequate resuscitation. The patient is now hypotensive.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 98, 
            "spRate": 176, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPFLUIDS1", 
                    "comment": "You partially rehydrated the patient after induction. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 19
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 29
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPFLUIDS1", 
                    "comment": "You administered a bolus of fluid greater than 20 mL/kg. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 28
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "The rhythm degenerated to ventricular fibrillation. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ASLEEPFLUIDS1", 
            "whatNextMsg": "Administer another 20 mL/kg fluids and secure the airway.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 24, 
            "baseAbpM": 32, 
            "baseAbpS": 50, 
            "baseBicarb": 22.4, 
            "baseHr": 146, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 64, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized but only partially rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 146, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You delayed securing the airway for too long. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VFIB", 
            "whatNextMsg": "Call for help and call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 15.6, 
            "baseHr": 0, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.1, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 48, 
            "hct": 46, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 4, 
            "papS": 4, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Cardiac arrest!", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0, 
            "stSegV5": 0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "The rhythm degenerated to asystole. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "GA1", 
            "whatNextMsg": "Intubate using direct laryngoscopy.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 34, 
            "baseAbpS": 52, 
            "baseBicarb": 22.4, 
            "baseHr": 122, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 64, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is slowed.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 122, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA1SECURE", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 36, 
            "baseAbpS": 54, 
            "baseBicarb": 22.4, 
            "baseHr": 124, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 64, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is slowed.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spRate": 124, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered adequate anesthetic for this patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 38, 
            "baseAbpS": 58, 
            "baseBicarb": 22.4, 
            "baseHr": 186, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 64, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 97, 
            "spRate": 186, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 6, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You deepened the anesthetic.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2", 
            "whatNextMsg": "Inform the surgeon that the patient is ready for surgery.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 24, 
            "baseAbpM": 34, 
            "baseAbpS": 52, 
            "baseBicarb": 22.4, 
            "baseHr": 122, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 64, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 97, 
            "spRate": 122, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You instructed the surgeon to make the incision appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA3", 
                    "comment": "You instructed the surgeon to operate. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA3", 
            "whatNextMsg": "Deep maintenance anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 22, 
            "baseAbpM": 32, 
            "baseAbpS": 50, 
            "baseBicarb": 22.4, 
            "baseHr": 124, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 1, 
            "glucose": 64, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 97, 
            "spRate": 124, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA4", 
                    "comment": "You administered an excessively deep anesthetic. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 3.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA4", 
            "whatNextMsg": "Excessively deep anesthesia during maintenance. Decrease anesthetic depth.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 20, 
            "baseAbpM": 30, 
            "baseAbpS": 48, 
            "baseBicarb": 22.4, 
            "baseHr": 126, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 1, 
            "glucose": 64, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Very deeply anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 97, 
            "spRate": 126, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You lightened the anesthetic depth appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.8
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 15.6, 
            "baseHr": 32, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 48, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 32, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 15.6, 
            "baseHr": 22, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 48, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 22, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 15.6, 
            "baseHr": 0, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 48, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 15.6, 
            "baseHr": 0, 
            "basePot": 3.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 48, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9
        }
    ]
}