CaseData[19] = {
    "title": "Case 19 - 48 year old female for cholecystectomy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 3, 
    "debriefMsg": "\nYou must become adept at the differential diagnosis of hypotension under anesthesia. Thromboembolism is relatively uncommon under anesthesia but should be suspected if the patient was immobile and for a prolonged period of time preoperatively without thromboembolism prophylaxis.  You should consider this diagnosis in patients with sudden, refractory hypotension with jugular venous distention. \n\nYou must treat aggressively by securing the airway and ventilating with 100% oxygen. Administer intravenous fluids but avoid overhydration in the face of right ventricular failure. Provide inotropic support as needed and consider administration of heparin. \n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 5, 
    "initialSat": 96, 
    "leanBodyMass": 90, 
    "learningObj": "\n48 year old female for cholecystectomy (106 kg)\n\nThis patient is obese and has been immobile for the past two weeks.\n\nLearning Objectives\n1.  State risk factors for pulmonary embolism\n2.  Recognize clinical presentation of pulmonary embolism\n3.  List treatment steps for pulmonary embolism\n\nAnesthetic Considerations\nObesity - increased risk of pulmonary aspiration; may be difficult to maintain airway and intubate; reduced FRC and increased V/Q mismatching\nSlightly increased risk of thrombembolism\n\nSuggested Anesthetic Plan\n1.  Routine monitoring\n2.  Rehydration\n3.  Preoxygenate\n4.  Tracheal intubation following intravenous induction\n5.  Maintain anesthesia with oxygen, isoflurane, narcotics, and relaxant.\n6.  Extubate after return of airway reflexes.\n\nClinical Manifestations of Pulmonary Embolism:\n1.  Dyspnea and tachypnea; wheezing is unusual\n2.  Hypoxemia due to V/Q mismatching\n3.  Hypocarbia is common. Large alveolar to end-tidal CO2 gradient due to large dead-space\n4.  Hypotension and tachycardia\n5.  High CVP with right ventricular failure\n\nRisk Factors for Deep Venous Thrombosis:\n1.  Venous stasis or vascular damage\n2.  Hypercoagulable state\n3.  Immobility\n4.  Age > 40\n5.  Extensive pelvic or abdominal surgery\n6.  Obesity\n7.  Congestive heart failure or acute MI\n8.  Cancer\n9.  Pregnancy or oral contraceptives\n\nHemodynamic Changes with PE:\n1.  Rise in PAP\n2.  Right ventricular failure leads to reduced cardiac output\n3.  Rise in central venous pressure\n4.  Normal PAOP and large gradient between PA diastolic and PAOP\n\nTreatment of PE:\n1.  Oxygenation and ventilation\n2.  Heparin 5000 unit load plus 1000 units/hr\n3.  Careful adminstration of fluid, but avoid right ventricular overload\n4.  Inotropic support - dopamine, dobutamine, or norepinephrine\n5.  In some cases vasodilators like hydralazine may reduce pulmonary resistance but may induce systemic hypotension\n6.  Thrombolytic therapy\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: March 26, 2013\n\n", 
    "possiblePoints": 1000, 
    "preopMsg": "\n48 year old female for cholecystectomy\n\nHistory of Present Illness\nTwo weeks following knee surgery this patient had an acute attack of cholecystitis.  Minimal ambulation since surgery. \n\nPast Medical History\nIllnesses: none\nSurgeries: Anterior cruciate ligament repair (general anesthesia with no problems)\nMeds: Tylenol with codeine\nAllergies: none\nHabits: denies cigarettes, alcohol, or other drugs.\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nObese female in moderate distress     Weight: 106 Kg \nHR: 98      BP: 124/80      RR: 22\nAirway: normal\nLungs: clear\nHeart: normal\n\nLabs\nHematocrit: 38\nElectrolytes, Glucose, Blood Urea Nitrogen, creatinine : normal\n\nNPO Status\nLast ate 8 hours ago. \n\nPatient and Surgeon Requests\nSurgery is scheduled for 90 minutes.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen by mask and a sedative agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 23.8, 
            "baseHr": 88, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spRate": 88, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 540, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You administered an intravenous sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered an inhalational anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV1", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spRate": 84, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 500, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (-50 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV2", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spRate": 84, 
            "spSignal": 3, 
            "spontRr": 4, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient recovered from the sedative. (-50 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a sedated patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a sedated patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spRate": 76, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You decreased the anesthetic depth. (-100 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You continued to administer inhalation agent.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWIV", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 95, 
            "sat100": 97, 
            "spRate": 82, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2IV", 
            "whatNextMsg": "Inform the surgeon that the patient is ready.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spRate": 80, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDINH", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spRate": 82, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 540, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (-50 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 96, 
            "sat100": 98, 
            "spRate": 86, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 500, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You decreased the anesthetic depth. (-100 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered intravenous anesthetic agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWINH", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 96, 
            "sat100": 98, 
            "spRate": 88, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 500, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2INH", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2INH", 
            "whatNextMsg": "Inform the surgeon that the patient is ready.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 97, 
            "spRate": 84, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 480, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 96, 
            "sat100": 98, 
            "spRate": 88, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 460, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PE1", 
                    "comment": "The simulation forced the patient to develop a pulmonary embolism.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPIV", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spRate": 88, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PE1", 
                    "comment": "The simulation forced the patient to develop pulmonary embolism.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE1", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 72, 
            "baseAbpS": 90, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 36, 
            "papM": 44, 
            "papS": 60, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Immediately after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is somewhat reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spRate": 118, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE2", 
                    "comment": "You waited more than one minute to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE2", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 70, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 38, 
            "papM": 46, 
            "papS": 64, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "One minute after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is somewhat reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 76, 
            "spRate": 128, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE3", 
                    "comment": "You waited more than two minutes to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE3", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 62, 
            "baseAbpS": 84, 
            "baseBicarb": 24, 
            "baseHr": 138, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 42, 
            "papM": 52, 
            "papS": 68, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Two minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 62, 
            "sat100": 64, 
            "spRate": 138, 
            "spSignal": 1, 
            "spontRr": 32, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE3", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE4", 
                    "comment": "You waited more than three minutes to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE4", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 60, 
            "baseAbpS": 78, 
            "baseBicarb": 24, 
            "baseHr": 148, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.6, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 40, 
            "papM": 48, 
            "papS": 60, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Three minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spRate": 148, 
            "spSignal": 0, 
            "spontRr": 24, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE4", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 20
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 300
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE5", 
                    "comment": "You waited more than four minutes to administer an inotrope. (-40 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -40
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE5", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Administer inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 22, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.5, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 30, 
            "papM": 38, 
            "papS": 50, 
            "papW": 0, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Four minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is markedly reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spRate": 128, 
            "spSignal": 0, 
            "spontRr": 16, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE5", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 20
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 300
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited more than five minutes to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE6", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Administer inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 40, 
            "baseAbpS": 60, 
            "baseBicarb": 20, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 0, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Five minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is markedly reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spRate": 108, 
            "spSignal": 0, 
            "spontRr": 8, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 20
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 300
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE7", 
                    "comment": "You waited more than six minutes to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE7", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Administer inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 20, 
            "baseAbpM": 30, 
            "baseAbpS": 50, 
            "baseBicarb": 20, 
            "baseHr": 90, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.3, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 10, 
            "papM": 14, 
            "papS": 20, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Six minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spRate": 90, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 501
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE7", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 500
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE8", 
                    "comment": "You waited more than seven minutes to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE8", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Administer inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 26, 
            "baseAbpS": 40, 
            "baseBicarb": 18, 
            "baseHr": 70, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 0, 
            "papM": 0, 
            "papS": 2, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Seven minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spRate": 70, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE8", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE9", 
                    "comment": "You waited more than eight minutes to administer an inotrope. (-20 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -20
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PE9", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Administer inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 14, 
            "baseAbpM": 16, 
            "baseAbpS": 22, 
            "baseBicarb": 16, 
            "baseHr": 50, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 0, 
            "papM": 0, 
            "papS": 0, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Eight minutes after pulmonary embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 50, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE9", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DEAD", 
                    "comment": "You waited too long to administer an inotrope.`(-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INO", 
            "whatNextMsg": "Now administer at least 500 mL bolus of intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 20, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.4, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 38, 
            "papM": 48, 
            "papS": 64, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Inotropic agent administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 62, 
            "sat100": 64, 
            "spRate": 128, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited too long to administer a fluid bolus. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "FLUID", 
            "whatNextMsg": "Now administer an inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 20, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 34, 
            "papM": 44, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spRate": 132, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HEPFLUID", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HEPFLUID", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HEP", 
            "whatNextMsg": "Now administer an intropic agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 20, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 32, 
            "papM": 42, 
            "papS": 60, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Heparin was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 66, 
            "sat40": 68, 
            "sat100": 70, 
            "spRate": 132, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HEP", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HEPFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INOFLUID", 
            "whatNextMsg": "Now start heparin 5000 U IV bolus.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 64, 
            "baseAbpS": 84, 
            "baseBicarb": 20, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.4, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 30, 
            "papM": 38, 
            "papS": 60, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Inotropic agent and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 74, 
            "spRate": 124, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered heparin appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4999
                        }, 
                        {
                            "drug": "Heparin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered an excessive dose of heparin. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Heparin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10001
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited too long to administer heparin. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INOHEP", 
            "whatNextMsg": "Now administer a fluid bolus of at least 500 mL.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 62, 
            "baseAbpS": 82, 
            "baseBicarb": 20, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 36, 
            "papM": 46, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "An inotropic agent and heparin were administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 72, 
            "sat40": 74, 
            "sat100": 76, 
            "spRate": 126, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited too long to administer a fluid bolus. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HEPFLUID", 
            "whatNextMsg": "Now administer an inotropic agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 74, 
            "baseBicarb": 20, 
            "baseHr": 130, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 24, 
            "papM": 34, 
            "papS": 54, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Heparin and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 74, 
			"spRate": 130, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE9", 
                    "comment": "You administered an inadequate bolus of epinephrine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PE6", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INOFLUIDHEP", 
            "whatNextMsg": "Observe and provide additional supportive measures as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 68, 
            "baseAbpS": 86, 
            "baseBicarb": 20, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 4.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 20, 
            "papM": 32, 
            "papS": 52, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "An inotropic agent, fluids and heparin were administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 76, 
            "sat40": 80, 
            "sat100": 82, 
            "spRate": 118, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You observed the patient appropriately.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "You successfully averted a catastrophic pulmonary embolism.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 66, 
            "baseAbpS": 88, 
            "baseBicarb": 20, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 4.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 16, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 28, 
            "papS": 48, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 78, 
            "sat40": 82, 
            "sat100": 84, 
            "spRate": 120, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "VTACH1", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Hear sounds are rapid.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 74, 
            "spRate": 142, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH2", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are rapid.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 74, 
            "spRate": 142, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUID", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH3", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are rapid.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 74, 
            "spRate": 142, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOHEP", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INOHEP", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH4", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are rapid.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 72, 
            "sat100": 74, 
            "spRate": 142, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INOFLUIDHEP", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 95, 
            "spRate": 100, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 540, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 120, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 540, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 110, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 100, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 540, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 120, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 540, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "whatNextMsg": "Now perform laryngoscopy and place the endotracheal intubation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Asleep and paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 66, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 106, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 106, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 32, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 22, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}