CaseData[37] = {
    "title": "Case 37 - 23 year old preeclamptic for induction of labor followed by Cesarean delivery", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1, 
    "debriefMsg": "\n Anesthetic challenges of preeclampsia include maintaining maternal hemodynamic stability (avoiding significant decreases in maternal blood pressure with regional analgesia/anesthesia and avoiding dangerous hypertension with induction of general anesthesia).  Maintaining stable maternal hemodynamics and proper maternal positioning optimizes the fetal condition.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 3, 
    "initialSat": 96, 
    "leanBodyMass": 72, 
    "learningObj": "\n23 year old preeclamptic for induction of labor followed by Cesarean delivery (78 kg)\n\nG1P0 at 30 weeks estimated gestational age. She is receiving an oxytocin infusion to induce labor because of worsening preeclampsia and concerns of fetal well being. General anestheisa is required due to low platelet count.\n\nLearning Objectives\n1.  Define preeclampsia, eclampsia and HELLP syndrome.\n2.  Describe fluid management in preeclampsia/eclampsia.\n3.  List best agents for hypertensive crisis\n\nDefinitions\n1.  Preeeclampsia is defined by new onset of hypertension and proteinuria in women after 20 weeks gestation.\n2.  Eclampsia is preeclampsia plus seizures.\n3.  HELLP is Hemolysis, Elevated Liver enzymes, and Low Platelets in women with preeeclampsia\n\nFluid Management\n1.  Tissue and pulmonary edema is common\n2.  Limit fluidreplacement to 80 mL/hr unless there are ongoing losses\n3.  Diurese with furosemide as needed\n\nTreatment of Hypertensive Emergency \n  (SBP > 155-160 for > 15 minutes)\n1.  First line meds - labetalol, hydralazine, nifedipine\n2.  Second line - nicardipine, sodium nitroprusside, esmolol\n3.  Lower blood pressure no more than 15-20% to avoid fetal compromise\n3.  Avoid nitroglycerin since it may increase postpartum hemorrhage\n4.  Avoid methylergonovine since may increase blood pressure.\n\nAnesthetic Considerations\n1.  Anesthetic challenges include maintaining maternal hemodynamic stability (avoiding significant decreases in maternal blood pressure with regional analgesia/anesthesia and avoiding dangerous hypertension with induction of general anesthesia).  Maintaining stable maternal hemodynamics and proper maternal positioning optimizes the fetal condition.\n2.  Invasive monitoring - arterial line, CVP, PA catheter and transthoracic echo in cases of persistent oliguria or pulmonary edema can be helpful since the preeclamptic hemodynamic profile can range from high cardiac output and low SVR to low cardiac output and high SVR.\n3. Regional analgesia for labor or regional anesthesia for cesarean delivery can be safely accomplished in patients without overt coagulopathy.  Important principles include:  avoid prehydration (excessive crystalloid can contribute to edema), slow induction of sympathetic block, avoiding hypotension, maintaining proper maternal positioning, and monitoring the fetus for evidence of compromise.\n4.  Securing the airway during general anesthesia can be difficult due to upper airway edema.  This may not be predicted on airway exam.  Proper pre-treatment and induction are essential to avoid excessive hypertension and acute pulmonary edema. Pre-treatment with labetalol, nitroglycerin, or nitroprusside are all acceptable to bring the blood pressure into an acceptable range (diastolic less than 100 or 25% reduction in mean blood pressure).\n5.  Rapid sequence induction with cricoid pressure using propofol is recommended.  \n6.  Blunt the hypertensive response to intubation with esmolol 1.5 mg/kg or remifentanil 1-1.5 mcg/kg\n7.  Be aware of the significant potentiation of nondepolarizing muscle relaxants by intravenous magnesium. Monitor neuromuscular blockade during general anesthesia and administer very small doses if necessary.\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September 2024\n\n", 
    "possiblePoints": 1200, 
    "preopMsg": "\n23 year old preeclamptic for induction of labor followed by Cesarean delivery\n\nHistory of Present Illness\nG1P0 at 30 weeks estimated gestational age. She is receiving an oxytocin infusion to induce labor because of worsening preeclampsia and concerns of fetal well being.The patient has been making poor progress and the fetus has developed a worrisome fetal heart rate pattern with poor beat-to-beat variability and repetitive late decelerations with uterine contractions.\n\nPast Medical History\nIllnesses: no other illnesses\nSurgeries: appendectomy 5 years ago without problems\nMeds: none\nAllergies: none\nHabits: smokes 1-2 packs per day\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nWeight: 78 kg   HR: 98     BP: 170/120    RR : 18\nAirway: Class III, facial edema\nLungs: crepitations at left base \nHeart: normal\nNeuro: brisk reflexes, no focal neurologic signs\n\nLabs\nHematocrit: 39      Creatinine: 0.8      SGOT: 20\nFibrinogen: 518    PT: 11.1  PTT: 28    Platelets: 98,000\nUrine protein 4+\n\nNPO Status\nLast ate 8 hours ago. \n\nPatient and Surgeon Requests\nThe obstetrician requests immediate cesarean delivery.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer a sedative agent. Titrate additional alpha-blocker such as phentolamine and replace fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 106, 
            "baseAbpM": 122, 
            "baseAbpS": 168, 
            "baseBicarb": 23.8, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 28, 
            "papM": 40, 
            "papS": 68, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered esmolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated esmolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated metoprolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated propranolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATED", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "Better to alpha-block before administering fluids. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered hydralazine as a vasodilator. (+50 points of 200 possible points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points of 200 possible points)",  
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered nitroglycerin as a vasodilator. (+50 points of 200 possible points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATED", 
            "whatNextMsg": "Add additional alpha-blocker - Phentolamine 2-5 mg doses.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 114, 
            "baseAbpS": 156, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 24, 
            "papM": 36, 
            "papS": 56, 
            "papW": 3, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 99
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered esmolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated esmolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered metoprolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered propranolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEP5", 
                    "comment": "You induced anesthesia before administering alpha blockers, fluids and beta blockers. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "Better to alpha-block before administering fluids. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered hydralazine as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered nitroglycerin as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 112, 
            "baseAbpM": 138, 
            "baseAbpS": 196, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 97, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "HURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 132, 
            "baseAbpS": 226, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 28, 
            "papM": 46, 
            "papS": 74, 
            "papW": 4, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 124, 
            "baseAbpM": 154, 
            "baseAbpS": 214, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 24, 
            "papM": 42, 
            "papS": 70, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ALPHA", 
            "whatNextMsg": "Now administer at least 1000 mL bolus of intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 92, 
            "baseAbpS": 114, 
            "baseBicarb": 20, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 3.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are flat.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 22, 
            "papM": 30, 
            "papS": 46, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid. Jugular veins are flat.", 
            "pupilsMsg": "The pupils are equal, round and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha blocker or vasodilator administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are flat.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered esmolol. Better to replace fluids before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated esmolol. Better to replace fluids before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered metoprolol. Better to replace fluids before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered propranolol. Better to replace fluids before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You induced anesthesia before before replacing fluids adequately. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "BETA", 
            "whatNextMsg": "Now administer an alpha-blocking agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 76, 
            "baseAbpS": 94, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Beta-blocker was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before administering alpha blockers and fluids. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered labetalol after another beta-blocker. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated labetalol after another beta-blocker. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "FLUID", 
            "whatNextMsg": "Now administer an alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 94, 
            "baseAbpM": 112, 
            "baseAbpS": 148, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 34, 
            "papM": 44, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid bolus administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before administering alpha blockers and beta blockers. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered esmolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You titrated esmolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered metoprolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered propranolol. Better to alpha-block before beta-blocking. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ALPHABETA", 
            "whatNextMsg": "Now administer a fluid bolus of at least 1000 mL.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 84, 
            "baseAbpS": 108, 
            "baseBicarb": 20, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 36, 
            "papM": 46, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha and beta blocking agents administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia before replacing fluids. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ALPHAFLUID", 
            "whatNextMsg": "Now administer a beta-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 76, 
            "baseAbpM": 94, 
            "baseAbpS": 116, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 4.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 24, 
            "papM": 38, 
            "papS": 52, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha-blocker and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia before administering beta blockers. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered labetalol after another alpha-blocker. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated labetalol after another alpha-blocker. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered esmolol appropriately.  (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated esmolol appropriately.  (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered metoprolol appropriately.  (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered propranolol. Better to metoprolol or esmolol. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "BETAFLUID", 
            "whatNextMsg": "Now administer an alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 88, 
            "baseAbpS": 106, 
            "baseBicarb": 20, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 44, 
            "papS": 72, 
            "papW": 18, 
            "pulseMsg": "The pulse is rapid. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Beta-blocker and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia before administering alpha blockers, fluids and beta blockers. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered labetalol after another beta-blocker. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated labetalol after another beta-blocker. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ALPHAFLUIDBETA", 
            "whatNextMsg": "Now induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 88, 
            "baseAbpS": 114, 
            "baseBicarb": 20, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha blocker, fluids, and beta-blocker administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia after administering alpha blockers, fluids and beta blockers. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 70, 
            "baseAbpM": 82, 
            "baseAbpS": 104, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 86, 
            "baseAbpS": 106, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 78, 
            "baseAbpS": 96, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 88, 
            "baseAbpS": 112, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 122, 
            "baseAbpS": 174, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 128, 
            "baseAbpS": 192, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "You successfully avoided malignant hypertension.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 86, 
            "baseAbpM": 98, 
            "baseAbpS": 128, 
            "baseBicarb": 20, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "ASLEEP5", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 46, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 28, 
            "papS": 46, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized before alpha and beta blockade and fluid replacement.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE5", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE5", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE5", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE5", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 116, 
            "baseAbpS": 166, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 56, 
            "papW": 3, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA5", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA5", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 90, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 26, 
            "papS": 38, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP5", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP5", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP5", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 112, 
            "baseAbpM": 144, 
            "baseAbpS": 196, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN5", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 122, 
            "baseAbpM": 146, 
            "baseAbpS": 196, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP5", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN5", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 138, 
            "baseAbpS": 212, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                 {
                    "nextState": "STABLE", 
                    "comment": "You administered hydralazine as a vasodilator. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroglycerin as a vasodilator. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
               {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP4", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 116, 
            "baseAbpS": 166, 
            "baseBicarb": 24, 
            "baseHr": 112, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 28, 
            "papS": 46, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after beta-blockers and fluids, but no alpha-blockade.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE4", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE4", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE4", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE4", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 106, 
            "baseAbpS": 156, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 56, 
            "papW": 3, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA4", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA4", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 52, 
            "baseAbpS": 86, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 26, 
            "papS": 38, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP4", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP4", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP4", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 112, 
            "baseAbpM": 134, 
            "baseAbpS": 196, 
            "baseBicarb": 24, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN4", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 132, 
            "baseAbpM": 152, 
            "baseAbpS": 226, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP4", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN4", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 138, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 62, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP3", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 102, 
            "baseAbpS": 124, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after alpha-blockade, but not beta-blockade.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE3", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE3", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE3", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE3", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 82, 
            "baseAbpM": 98, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA3", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 90, 
            "baseAbpS": 116, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP3", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP3", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP3", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 92, 
            "baseAbpM": 106, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN3", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 108, 
            "baseAbpM": 132, 
            "baseAbpS": 194, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP3", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN3", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 148, 
            "baseAbpS": 202, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (-100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ST3", 
            "whatNextMsg": "Try esmolol to slow the heart rate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 120, 
            "baseAbpS": 144, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient appears to be in distress.", 
            "papD": 26, 
            "papM": 34, 
            "papS": 66, 
            "papW": 14, 
            "pulseMsg": "The pulse is weak but present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Deep ST depression.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3.2, 
            "stSegV5": -2.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "Review the learning objectives and try the case again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}