CaseData[48] = {
    "title": "Case 107 - 20 year old male for decompressive craniotomy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "hyperkalemia from case 10", 
    "depthCarina": 24, 
    "depthCords": 17, 
    "depthTubeInitial": 21, 
    "durationPrep": 60, 
    "durationSurgery": 2400, 
    "helpFlag": true, 
    "imageSet": 2, 
    "initialSat": 96, 
    "leanBodyMass": 56, 
    "learningObj": "", 
    "possiblePoints": 1500, 
    "preopMsg": "\n20 year-old for urgent decompressive craniotomy.\n\n\nThe patient was found down by a roommate after an unknown period of time, and brought in by medics to the ER.\n\nThis patient has long-standing type 1 diabetes mellitus.  His roommate found his on the floor next to a coffee-table with obvious head trauma.  His diabetes has been poorly controlled due to poor compliance and what seems to be borderline personality disorder.  He is well known to the hospital, with frequent admissions for ketoacidotic crises.\n\nIn the Emergency Department, he is obtunded - responding only with withdrawal to painful stimulus.\nAirway: airway reflexes are markedly depressed.\nBreathing:  Cheyne-Stokes respiration .\nCirculation:  A radial pulse is present.\nA single peripheral IV was placed by medics enroute to the hospital.\n\nWeight: 68 kg\nVitals:  BP 89/56  HR 89  RR 20  SaO2 90% on 2L by nasal cannulae.\n\nLabs: hemolyzed - redrawn and now pending.\nImaging: noncontrast head CT shows acute R frontal subdural hematoma.  There is considerable midline shift and the radiologist calls to alert you that early uncal hernation is present.\n\n\nPast Medical History:\nType 1 diabetes - onset at age 11, insulin dependent since that time.\nHe has known retinopathy and neuropathy.\nThe patient has a history of frequent hospitalizations for DKA, some requiring intubation for airway control.\nHe is prescribed basal and prandial insulin therapy, but only takes these part of the time.\nHe has undergone an uneventful general anesthesia for ORIF of an left distal radius fracture 2 years ago.\n\nFamily History\nNo known anesthetic problems\n\nSurgeon is strenuously requesting expedited general anesthesia for a 'crash craniotomy'.\n\n", 
    "volAnDsp": 56, 
    "states": [
        {
            "name": "OBTUNDED", 
            "whatNextMsg": "Once an expedited preop evaluation is complete and appropriate monitors applied, induce anesthesia with a modified rapid-sequence induction with cricoid pressure.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 128, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 773, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is obtunded and does not respond to voice commands. He withdraws to painful stimulus.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 8, 
            "recordMsg": "Patient is not responsive to verbal stimulus", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 84, 
            "sat40": 88, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 230, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "Consider not using etomidate (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9.9
                        }, 
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 18.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "Thiopental was probably not the best choice for this patient in extremis. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Thiopental", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 30
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "Propofol was probably not the best choice for this patient in extremis. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 55
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessive dose of etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia. (+50 of 100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "OBTUNDEDSEDATED", 
                    "comment": "The patient has become hypercarbic, and has progressed their uncal herniation. Acidosis is worsening the hyperkalemia (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Midazolam", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.5
                        }, 
                        {
                            "op": "GT", 
                            "type": "pCO2", 
                            "value": 50
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "OBTUNDED1", 
                    "comment": "You waited too long to induce anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "OBTUNDED1", 
            "whatNextMsg": "Once an expedited preop evaluation is complete and appropriate monitors applied, induce anesthesia with a modified rapid-sequence induction with cricoid pressure.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 128, 
            "basePot": 7.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 764, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is obtunded and does not respond to voice commands. He withdraws to painful stimulus.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 8, 
            "recordMsg": "Patient is not responsive to verbal stimulus", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 84, 
            "sat40": 88, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "Consider not using etomidate (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9.9
                        }, 
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 18.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "Thiopental was probably not the best choice for this patient in extremis. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Thiopental", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 30
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "Propofol was probably not the best choice for this patient in extremis. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 55
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excess of etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia. (+50 of 100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "OBTUNDEDSEDATED", 
                    "comment": "The patient has become hypercarbic, and has progressed their uncal herniation. Acidosis is worsening the hyperkalemia (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Midazolam", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.5
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "OBTUNDED", 
                    "comment": "You are waiting too long to induce anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "OBTUNDEDSEDATED", 
            "whatNextMsg": "Place cricoid, manually hyperventilate, induce anesthesia and intubate quickly before the patient herniates.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 49, 
            "baseAbpM": 62, 
            "baseAbpS": 87, 
            "baseBicarb": 13, 
            "baseHr": 105, 
            "basePot": 8.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 741, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is obtunded and does not respond to voice commands. He withdraws to painful stimulus.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a sluggish, dilated R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient was given sedation inappropriately", 
            "rhythm": "Sinus5", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 80, 
            "sat40": 88, 
            "sat100": 90, 
            "spSignal": 2, 
            "spontRr": 6, 
            "spontTv": 190, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "OBTUNDEDHERNIATED", 
                    "comment": "Herniation progresses.  The patient cannot be resuscitated.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 70
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Consider not using etomidate (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9.9
                        }, 
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "OBTUNDEDHERNIATED", 
            "whatNextMsg": "Contact risk-management and your malpractice attorney.  It's time to try this again.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 41, 
            "baseAbpM": 54, 
            "baseAbpS": 77, 
            "baseBicarb": 13, 
            "baseHr": 82, 
            "basePot": 9.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, though markedly hypopneic.", 
            "cardiacOutput": 1.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": -2, 
            "glucose": 773, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is obtunded and does not respond to voice commands. He withdraws to painful stimulus.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are unequal with a fixed, dilated R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient has uncal herniation", 
            "rhythm": "Sinus6", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 80, 
            "sat40": 88, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3
        }, 
        {
            "name": "ASLEEP", 
            "whatNextMsg": "Administer a paralytic agent to obtain intubating conditions rapidly.  Maintain gentle hyperventilation to prevent hypercarbia.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 680, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient is adequately anesthetized", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "LMA", 
                    "comment": "Use of supraglottic airway contraindicated in this case outside of the difficult airway algorithm (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to intubate the patient without neuromuscular blockade.  Sometimes that works, but this time it didn't.  It was unwise to try with this patient (presumed full stomach) (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried an asleep fiberoptic intubation a patient with presumed full stomach without neuromuscular blockade (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "CRICOTHY", 
                    "comment": "There is no indication for cricothyroidotomy in this patient.  The time spent on this procedure has delayed surgery and allowed progression of both herniation and hyperkalemia.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "You administered enough intravenous agent and non-depolarizing NMB. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }, 
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP1", 
                    "comment": "You are waiting too long to paralyze. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an underanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP1", 
            "whatNextMsg": "Administer a paralytic agent to obtain intubating conditions rapidly.  Maintain gentle hyperventilation to prevent hypercarbia.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 660, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient is adequately anesthetized", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine is contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "LMA", 
                    "comment": "Use of supraglottic airway contraindicated in this case outside of the difficult airway algorithm (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to intubate the patient without neuromuscular blockade.  Sometimes that works, but this time it didn't.  It was unwise to try with this patient (presumed full stomach) (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried an asleep fiberoptic intubation a patient with presumed full stomach without neuromuscular blockade (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "CRICOTHY", 
                    "comment": "There is no indication for cricothyroidotomy in this patient.  The time spent on this procedure has delayed surgery and allowed progression of both herniation and hyperkalemia.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "You administered enough intravenous agent and non-depolarizing NMB. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }, 
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You are waiting too long to paralyze. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an underanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPPARA", 
            "whatNextMsg": "Secure the airway with direct laryngoscopy and endotracheal intubation maintaining cricoid pressure.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 658, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient is asleep and an adequate dose of non-depolarizing NMB agent has been administered.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated the patient with cricoid pressure (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": true
                        }, 
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated the patient without cricoid pressure (+100 of 200 possible points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": false
                        }, 
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated the patient. (+100 of 200 possible points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEPPARA1", 
                    "comment": "You are waiting too long to Intubate. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. Pretreatment with non-depolarizer does not prevent potassium increase. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPPARA1", 
            "whatNextMsg": "Secure the airway with direct laryngoscopy and endotracheal intubation maintaining cricoid pressure.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 654, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient is asleep and an adequate dose of non-depolarizing NMB agent has been administered.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated the patient with cricoid pressure (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": true
                        }, 
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated the patient without cricoid pressure (+100 of 200 possible points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": false
                        }, 
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated the patient. (+100 of 200 possible points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "You are waiting too long to Intubate. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. Pretreatment with non-depolarizer does not prevent potassium increase. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINT", 
            "whatNextMsg": "Continue optimizing metabolic and neurosurgical parameters", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 588, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient is asleep, and airway appropriately secured", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEPINTHK1", 
                    "comment": "The simulation has forced moderate hyperkalemia", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINTHK1", 
            "whatNextMsg": "Begin aggressive treatment of hyperkalemia (discontinue exogenous potassium sources; start intravenous insulin/glucose, inhaled or intravenous beta-adrenergic agonist, intravenous bicarbonate, mild hyperventilation)", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 522, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "The simulation has forced worsening of hyperkalemia", 
            "rhythm": "Sinus5", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEPINTHK2", 
                    "comment": "The simulation has forced severe hyperkalemia.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINTHK2", 
            "whatNextMsg": "Treat with intravenous calcium (500-1000mg) quickly", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 59, 
            "baseAbpM": 69, 
            "baseAbpS": 90, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 512, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 12, 
            "rateUo": 4, 
            "recordMsg": "The simulation has forced even more worsening of hyperkalemia", 
            "rhythm": "Sinus5", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKTX", 
                    "comment": "You successfully treated the wide complex arrhythmia (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Calcium", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 499
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "ASLEEPINTHK2A", 
                    "comment": "You waited too long to start calcium.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINTHK2A", 
            "whatNextMsg": "Treat with intravenous calcium (500-1000mg) quickly", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 59, 
            "baseAbpM": 69, 
            "baseAbpS": 90, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 486, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 12, 
            "rateUo": 4, 
            "recordMsg": "The simulation has forced even more worsening of hyperkalemia", 
            "rhythm": "Sinus5", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKTX", 
                    "comment": "You successfully treated the wide complex arrhythmia (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Calcium", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 499
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "ASLEEPINTHK2A1", 
                    "comment": "You waited too long to start calcium.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINTHK2A1", 
            "whatNextMsg": "Treat with intravenous calcium (500-1000mg) quickly", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 59, 
            "baseAbpM": 69, 
            "baseAbpS": 90, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 496, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 12, 
            "rateUo": 4, 
            "recordMsg": "The simulation has forced even more worsening of hyperkalemia", 
            "rhythm": "Sinus5", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKTX", 
                    "comment": "You successfully treated the wide complex arrhythmia (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Calcium", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 499
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "ASLEEPINTHK2A", 
                    "comment": "You waited too long to start calcium.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HKTX", 
            "whatNextMsg": "Begin aggressive treatment of hyperkalemia (discontinue exogenous potassium sources; start intravenous insulin/glucose, inhaled or intravenous beta-adrenergic agonist, intravenous bicarbonate, mild hyperventilation)", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 518, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 10, 
            "rateUo": 4, 
            "recordMsg": "You have treated arrhythmia with calcium", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKTX1", 
                    "comment": "You waited too long to start treating the hyperkalemia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 100
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "HKINS", 
                    "comment": "You treated hyperkalemia with bolus insulin. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 3.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HKINS", 
                    "comment": "You treated hyperkalemia with an infusion of insulin. Bolus would be better in this acute situation. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HKTX1", 
            "whatNextMsg": "Begin aggressive treatment of hyperkalemia (discontinue exogenous potassium sources; start intravenous insulin/glucose, inhaled or intravenous beta-adrenergic agonist, intravenous bicarbonate, mild hyperventilation)", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.4, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 522, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 10, 
            "rateUo": 4, 
            "recordMsg": "You have treated arrhythmia with calcium.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKTX", 
                    "comment": "You waited too long to start treating the hyperkalemia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 100
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "HKINS", 
                    "comment": "You treated hyperkalemia with bolus insulin. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 3.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HKINS", 
                    "comment": "You treated hyperkalemia with an infusion of insulin. Bolus would be better in this acute situation. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HKINS", 
            "whatNextMsg": "Continue aggressive treatment of hyperkalemia (inhaled beta-adrenergic agonist like albuterol and intravenous bicarbonate)", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.1, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 408, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 11, 
            "rateUo": 4, 
            "recordMsg": "You have treated hyperkalemia with insulin therapy.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKINS1", 
                    "comment": "You waited too long to continue treating the hyperkalemia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 100
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "DKA", 
                    "comment": "You successfully treated hyperkalemia. (+400 points)", 
                    "conditions": [
                        {
                            "drug": "SodiumBicarb", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 40
                        }, 
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4.9
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HKINS1", 
            "whatNextMsg": "Continue aggressive treatment of hyperkalemia (inhaled beta-adrenergic agonist like albuterol and intravenous bicarbonate)", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.7, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 424, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 11, 
            "rateUo": 4, 
            "recordMsg": "You have treated hyperkalemia with insulin therapy.", 
            "rhythm": "Sinus4", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "HKINS", 
                    "comment": "You continue to wait too long to continue treating the hyperkalemia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DKA", 
                    "comment": "You successfully treated hyperkalemia. (+400 points)", 
                    "conditions": [
                        {
                            "drug": "SodiumBicarb", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 40
                        }, 
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4.9
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DKA", 
            "whatNextMsg": "Continue with frequent monitoring of serum potassium - you should also treat DKA with volume resuscitation and an insulin infusion.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 18, 
            "baseHr": 118, 
            "basePot": 6.9, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 366, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 10, 
            "rateUo": 4, 
            "recordMsg": "You have treated the acute hyperkalemia.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 131, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "SUCCESS", 
                    "comment": "You successfully treated DKA with volume resuscitation. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }, 
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SUCCESS", 
                    "comment": "You treated hyperkalemia with an infusion of insulin. Bolus would be better in this acute situation. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DKA1", 
                    "comment": "You waited too long to provide adequate volume resuscitation and/or insulin infusion (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DKA1", 
            "whatNextMsg": "Continue with frequent monitoring of serum potassium - you should also treat DKA with volume resuscitation and an insulin infusion.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 18, 
            "baseHr": 118, 
            "basePot": 6.9, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 386, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 10, 
            "rateUo": 4, 
            "recordMsg": "You have treated the acute hyperkalemia.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 131, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "SUCCESS", 
                    "comment": "You successfully treated DKA with volume resuscitation. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }, 
                        {
                            "drug": "Insulin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DKA", 
                    "comment": "You waited too long to provide adequate volume resuscitation and/or insulin infusion (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SUCCESS", 
            "whatNextMsg": "Continue close monitoring.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 96, 
            "basePot": 6.1, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 330, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 5, 
            "rateUo": 8, 
            "recordMsg": "Continue treatment of DKA.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 135, 
            "sat20": 89, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3,
            "trans": [
                {
                    "nextState": "COMPLETE", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": 0
                } 
			]
        }, 
        {
            "name": "COMPLETE", 
            "whatNextMsg": "You have completed the learning objectives for this scenario.  At completion of the surgical case, you should consider leaving the patient intubated and transferring to ICU for further management of ketoacidosis.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 96, 
            "basePot": 6.1, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 1, 
            "glucose": 330, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 5, 
            "rateUo": 8, 
            "recordMsg": "You have successfully treated hyperkalemia and initiated necessary treatement of DKA.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 135, 
            "sat20": 89, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3
        }, 
        {
            "name": "XSPROP", 
            "whatNextMsg": "Propofol administered inappropriately - hypotension generally bad in head injury. Treat hypotension with vasopressor.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 61, 
            "baseAbpS": 81, 
            "baseBicarb": 14, 
            "baseHr": 61, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 770, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Asleep, hypotensive, relatively bradycardic.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You successfully treated hypotension with phenylephrine. (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": false
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You successfully treated hypotension with ephedrine (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": false
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated and you successfully treated hypotension with phenylephrine. (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated and you successfully treated hypotension with ephedrine (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "XSPROP1", 
                    "comment": "You waited too long to treat hypotension. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSPROP1", 
            "whatNextMsg": "Propofol administered inappropriately - hypotension generally bad in head injury. Treat hypotension with vasopressor.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 61, 
            "baseAbpS": 81, 
            "baseBicarb": 14, 
            "baseHr": 61, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 770, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Asleep, hypotensive, relatively bradycardic.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You successfully treated hypotension with phenylephrine. (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": false
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You successfully treated hypotension with ephedrine (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": false
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated and you successfully treated hypotension with phenylephrine. (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "ASLEEPINT", 
                    "comment": "You intubated and you successfully treated hypotension with ephedrine (+25 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "XSPROP", 
                    "comment": "You waited too long to treat hypotension. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 14, 
            "baseHr": 139, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 680, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient does not respond to commands, but is coughing violently.", 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Patient is upset and coughing.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "OBTUNDED", 
                    "comment": "The patient has calmed down", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "You gave the patient succinylcholine (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT", 
            "whatNextMsg": "You must anesthetize the patient, and after the case, you should contact risk management.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 14, 
            "baseHr": 141, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 660, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient does not follow commands but is bucking and straining against the Mayfield tongs.", 
            "obsFlag": false, 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 10, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "You allowed the surgeon to make incision in a patient who is inadequately anesthetized.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 89, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "The patient is now anesthetized.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "SUX", 
            "whatNextMsg": "Start CPR, give bolus IV calcium.  Once the line is cleared, give IV insulin and sodium bicarbonate.  In this scenario, you will not be able to resuscitate.  Start over, and review contraindications to succinylcholine.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 11, 
            "baseHr": 21, 
            "basePot": 10.7, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 773, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is only present when chest compressions are performed.", 
            "pupilsMsg": "The pupils are initially pinpoint, becoming midposition and fixed.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Hyperkalemic arrest.", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is ashen.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 70, 
            "sat40": 77, 
            "sat100": 80, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.3,
            "trans": [
                {
                    "nextState": "SUXCOMPLETE", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                } 
			]
        }, 
        {
            "name": "SUXCOMPLETE", 
            "whatNextMsg": "Start CPR, give bolus IV calcium.  Once the line is cleared, give IV insulin and sodium bicarbonate.  In this scenario, you will not be able to resuscitate.  Start over, and review contraindications to succinylcholine.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 11, 
            "baseHr": 21, 
            "basePot": 10.7, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": -2, 
            "glucose": 773, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is only present when chest compressions are performed.", 
            "pupilsMsg": "The pupils are initially pinpoint, becoming midposition and fixed.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Hyperkalemic arrest.", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is ashen.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 70, 
            "sat40": 77, 
            "sat100": 80, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.3,
            "trans": [
                {
                    "nextState": "SUXCOMPLETE", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                } 
			]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Time to try this scenario again.  Call your lawyer.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 14, 
            "baseHr": 120, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": -1, 
            "glucose": 773, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has minimal consciousness from her ketoacidosis but is thinking about calling her lawyer.", 
            "obsFlag": false, 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Minimally aware, but paralyzed, and not liking it.", 
            "rhythm": "Sinus4", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "DESATBRADY", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 14, 
            "baseHr": 52, 
            "basePot": 8.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": -1, 
            "glucose": 754, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 10, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus6", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 50, 
            "sat40": 51, 
            "sat100": 52, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "LMA", 
            "whatNextMsg": "You must quickly remove LMA and intubate the patient.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 7.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 742, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "LMA inappropriately inserted.  Surgeon calling the Chief of Anesthesiology at home.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "The patient is now anesthetized.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "type": "airwayLma", 
                            "value": false
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SUX", 
                    "comment": "Succinylcholine contraindicated in severe hyperkalemia. (-1000 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "CRICOTHY", 
            "whatNextMsg": "The patient is now brain dead.  The surgeon has talked to the patient's family and placed the responsibility squarely on you.  Call risk management and start over.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": -2, 
            "glucose": 744, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Cricothyroidotomy inappropriately performed.  Your inexperience with the procedure means that it took longer than expected.  The resulting delay has caused hypercarbia, which has worsened herniation.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3
        }, 
        {
            "name": "FOB", 
            "whatNextMsg": "The patient is now brain dead.  The surgeon has talked to the patient's family and placed the responsibility squarely on you.  Call risk management and start over.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 14, 
            "baseHr": 118, 
            "basePot": 8.6, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": -2, 
            "glucose": 748, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 9, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Fiberoptic bronchoscopy was unnecessary, and you encountered equipment problems.  The resulting delay has caused the patient to become hypercarbic, and herniation has progressed.", 
            "rhythm": "Sinus3", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3
        }, 
        {
            "name": "XSMANNITOL", 
            "whatNextMsg": "Start over.  Next time, try not to administer more than 1g/kg of mannitol - remember that all drugs have potential risks.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 14, 
            "baseHr": 23, 
            "basePot": 8.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally, there is an abnormal respiratory pattern.", 
            "cardiacOutput": 3.5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 773, 
            "hct": 38, 
            "heartSoundsMsg": "Tachycardic, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 10, 
            "papM": 15, 
            "papS": 24, 
            "papW": 12, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are unequal with a large sluggish R pupil.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "You administered excess mannitol (more than 1 gram per kilogram) which has precipitated a hyperkalemic arrest.", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is cool and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 76, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.2, 
            "temperature": 36.3,
            "trans": [
                {
                    "nextState": "MANNITOLCOMPLETE", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                } 
			]
        }, 
        {
            "name": "MANNITOLCOMPLETE", 
            "whatNextMsg": "Start CPR, give bolus IV calcium.  Once the line is cleared, give IV insulin and sodium bicarbonate.  In this scenario, you will not be able to resuscitate.  Start over, and review contraindications to succinylcholine.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 11, 
            "baseHr": 21, 
            "basePot": 10.7, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": -2, 
            "glucose": 742, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "obsFlag": false, 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is only present when chest compressions are performed.", 
            "pupilsMsg": "The pupils are initially pinpoint, becoming midposition and fixed.", 
            "rateEbl": 0, 
            "rateUo": 4, 
            "recordMsg": "Hyperkalemic arrest.", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is ashen.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 127, 
            "sat20": 70, 
            "sat40": 77, 
            "sat100": 80, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.3
        }
    ]
}