CaseData[78] = {
    "title": "Case 137 - 32 year old G8P5 with post-partum hemorrhage", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "PPH based on case 39", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 6, 
    "durationSurgery": 1200, 
    "helpFlag": false, 
    "imageSet": 3, 
    "initialSat": 96, 
    "leanBodyMass": 80, 
    "learningObj": "Date of Last Modification: October 2024\n\n", 
    "possiblePoints": 800, 
    "preopMsg": "\n32 year old G8P5 with post-partum hemorrhage\n\nHistory of Present Illness\nThe patient is G8 P5 Ab 2. The patient experienced a very fast labor with vaginal delivery a few minutes after arrival to the hospital. She started bleeding profusely immediately after delivery. The obstetrician requests assistance resuscitating the patient.\n\nPast Medical History\nIllnesses - None\nSurgeries - previous cesarean section for fetal distress\nMedications - None\nHabits - Denies cigarettes, alcohol or other drugs.\nNo known drug allergies.\n\nFamily History\nNo family history of anesthetic problems.\n\nPhysical Exam\nWeight: 87 kg\nHR 110,  BP 105/65,  RR 20\nAirway - good neck extension, 3 fingerbreadth mouth opening, able to visualize uvula\nChest auscultation - clear\n\nLabs\nHematocrit - pending\n\nNPO Status\nLast ate 8 hours ago.\n\nPatient and Surgeon Requests\nAfter one push the obstetrician effects spontaneous vaginal delivery of a vigorous term baby. The patient is bleeding profusely. The obstetrician requests assistance with resuscitation.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "PPH1", 
            "whatNextMsg": "The patient is bleeding profusely. Establish IV access and begin fluid resuscitation. Administer oxytocin.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
			"airwayStr": "nl",
            "baseAbpD": 75, 
            "baseAbpM": 90, 
            "baseAbpS": 115, 
            "baseBicarb": 22, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 50, 
            "rateUo": 1.5, 
            "recordMsg": "Extremely anxious and bleeding profusely.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OXY1", 
                    "comment": "You administered intravenous fluids and oxytocin appropriately. (+400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1499
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.5
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "OXY1", 
                    "comment": "You administered intravenous fluids and oxytocin appropriately. (+400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1499
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "PPH2", 
                    "comment": "You should have administered intravenous fluids and oxytocin sooner. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
            ]
        }, 
        {
            "name": "PPH2", 
            "whatNextMsg": "The patient is bleeding profusely. Establish IV access and begin fluid resuscitation. Administer oxytocin.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 66, 
            "baseAbpS": 94, 
            "baseBicarb": 20, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 50, 
            "rateUo": 1.5, 
            "recordMsg": "Delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OXY2", 
                    "comment": "You administered intravenous fluids and oxytocin appropriately. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1599
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.5
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "OXY2", 
                    "comment": "You administered intravenous fluids and oxytocin appropriately. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1599
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PPH3", 
                    "comment": "You should have administered intravenous fluids and oxytocin much sooner. (-300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "PPH1", 
                    "comment": "You administered intravenous fluids appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
            ]
        }, 
        {
            "name": "PPH3", 
            "whatNextMsg": "The patient is bleeding profusely. Establish IV access and begin fluid resuscitation. Administer oxytocin.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 46, 
            "baseAbpS": 68, 
            "baseBicarb": 18, 
            "baseHr": 144, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 1, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 30, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 50, 
            "rateUo": 1.5, 
            "recordMsg": "Double-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OXY3", 
                    "comment": "You administered intravenous fluids and oxytocin appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1699
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OXY3", 
                    "comment": "You administered intravenous fluids and oxytocin appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1699
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PPH4", 
                    "comment": "You should have administered intravenous fluids and oxytocin much much sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "PPH2", 
                    "comment": "You administered intravenous fluids appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1899
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
            ]
        }, 
        {
            "name": "PPH4", 
            "whatNextMsg": "The patient is bleeding to death. Begin fluid resuscitation and administer oxytocin.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 26, 
            "baseAbpS": 38, 
            "baseBicarb": 16, 
            "baseHr": 160, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 24, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 50, 
            "rateUo": 1.5, 
            "recordMsg": "Triple-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 1, 
            "spontRr": 30, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OXY4", 
                    "comment": "You administered intravenous fluids and oxytocin after a long delay. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1799
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.5
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OXY4", 
                    "comment": "You administered intravenous fluids and oxytocin after a long delay. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1799
                        },
                        {
                            "drug": "Oxytocin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PPH3", 
                    "comment": "You administered intravenous fluids appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1799
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should have administered intravenous fluids and oxytocin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
            ]
        }, 
        {
            "name": "OXY1", 
            "whatNextMsg": "Continue fluid resuscitation and administer methylergonovine or carboprost.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 65, 
            "baseAbpM": 82, 
            "baseAbpS": 105, 
            "baseBicarb": 22, 
            "baseHr": 116, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 30, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation started and oxytocin administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND1", 
                    "comment": "You administered methylergonovine appropriately. (+400 points)", 
                    "conditions": [
                        {
                            "drug": "Methylergonovine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "SECOND1", 
                    "comment": "You administered carboprost appropriately. (+400 points)", 
                    "conditions": [
                        {
                            "drug": "Carboprost", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "OXY2", 
                    "comment": "You should have administered methylergonovine or carboprost sooner. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
            ]
        }, 
        {
            "name": "OXY2", 
            "whatNextMsg": "Continue fluid resuscitation and administer methylergonovine or carboprost.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 62, 
            "baseAbpS": 86, 
            "baseBicarb": 20, 
            "baseHr": 128, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 32, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 30, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation started and oxytocin administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 10, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
               {
                    "nextState": "SECOND2", 
                    "comment": "You administered methylergonovine appropriately. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Methylergonovine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "SECOND2", 
                    "comment": "You administered carboprost appropriately. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Carboprost", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "OXY3", 
                    "comment": "You should have administered methylergonovine or carboprost sooner. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "OXY1", 
                    "comment": "You administered intravenous fluids appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
            ]
        }, 
        {
            "name": "OXY3", 
            "whatNextMsg": "Continue fluid resuscitation and administer methylergonovine or carboprost.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 40, 
            "baseAbpS": 60, 
            "baseBicarb": 18, 
            "baseHr": 152, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 28, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 30, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation started and oxytocin administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 140, 
            "spSignal": 2, 
            "spontRr": 14, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
               {
                    "nextState": "SECOND3", 
                    "comment": "You administered methylergonovine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Methylergonovine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND3", 
                    "comment": "You administered carboprost appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Carboprost", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OXY4", 
                    "comment": "You should have administered methylergonovine or carboprost sooner. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "OXY2", 
                    "comment": "You administered intravenous fluids appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2899
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
			]
        }, 
        {
            "name": "OXY4", 
            "whatNextMsg": "Continue fluid resuscitation and administer methylergonovine or carboprost.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 16, 
            "baseAbpM": 22, 
            "baseAbpS": 36, 
            "baseBicarb": 16, 
            "baseHr": 162, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 22, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 30, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation started and oxytocin administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 1, 
            "spontRr": 16, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
               {
                    "nextState": "SECOND4", 
                    "comment": "You administered methylergonovine appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Methylergonovine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SECOND4", 
                    "comment": "You administered carboprost appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Carboprost", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should have administered methylergonovine or carboprost sooner. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "OXY3", 
                    "comment": "You administered intravenous fluids appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2799
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
			]
        }, 
        {
            "name": "SECOND1", 
            "whatNextMsg": "Bleeding controlled. Measure hematocrit. Continue resuscitation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 70, 
            "baseAbpM": 82, 
            "baseAbpS": 105, 
            "baseBicarb": 22, 
            "baseHr": 118, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 12, 
            "papM": 18, 
            "papS": 30, 
            "papW": 10, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 10, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation continuing and second line uterotonic med administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "Continue to monitor and resuscitate as needed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                },
                {
                    "nextState": "FINAL", 
                    "comment": "You administered intravenous fluids appropriately. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3999
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
			]	
        }, 
        {
            "name": "SECOND2", 
            "whatNextMsg": "Bleeding controlled. Measure hematocrit. Continue resuscitation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 68, 
            "baseAbpS": 92, 
            "baseBicarb": 20, 
            "baseHr": 122, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 32, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 28, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 10, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation continuing and second line uterotonic med administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "Continue to monitor and resuscitate as needed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                },
                {
                    "nextState": "FINAL", 
                    "comment": "You administered intravenous fluids appropriately. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3999
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
			]	
        }, 
        {
            "name": "SECOND3", 
            "whatNextMsg": "Bleeding controlled. Measure hematocrit. Continue resuscitation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 62, 
            "baseAbpS": 90, 
            "baseBicarb": 18, 
            "baseHr": 124, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 30, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 10, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation continuing and second line uterotonic med administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "Continue to monitor and resuscitate as needed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                },
                {
                    "nextState": "FINAL", 
                    "comment": "You administered intravenous fluids appropriately.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3999
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
			]	
        }, 
        {
            "name": "SECOND4", 
            "whatNextMsg": "Bleeding controlled. Measure hematocrit. Continue resuscitation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 88, 
            "baseBicarb": 16, 
            "baseHr": 126, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 28, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 10, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid resucitation continuing and second line uterotonic med administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 1, 
            "spontRr": 30, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "Continue to monitor and resuscitate as needed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                },
                {
                    "nextState": "FINAL", 
                    "comment": "You administered intravenous fluids appropriately.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3999
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have paralyzed this patient. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You should not have induced anesthesia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1000
                } 
			]
        }, 
        {
            "name": "FINAL", 
            "whatNextMsg": "Scenario completed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 75, 
            "baseAbpM": 92, 
            "baseAbpS": 115, 
            "baseBicarb": 22, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 1, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 12, 
            "papM": 18, 
            "papS": 30, 
            "papW": 10, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 1, 
            "rateUo": 1.5, 
            "recordMsg": "You successfully managed this case which did not include massive transfusion protocol and coagulaopathy.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 92, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9 
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 32, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 22, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}