CaseData[69] = {
    "title": "Case 128 - 4 year old for tonsillectomy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "peds induction based on case 29", 
    "depthCarina": 18, 
    "depthCords": 12, 
    "depthTubeInitial": 15, 
    "durationPrep": 60, 
    "durationSurgery": 2400, 
    "helpFlag": false, 
    "imageSet": 1, 
    "initialSat": 96, 
    "leanBodyMass": 18, 
    "learningObj": "", 
    "possiblePoints": 800, 
    "preopMsg": "\n4 year old for tonsillectomy\n\nThis child has had multiple bouts of tonsilitis.\n\nPast Medical History\nIllnesses: Strabismus corrected with an eye patch.\nSurgeries: none\nMeds: none\nAllergies: none\n\nFamily History\nNo known anesthetic problems\n\nPhysical Exam\nHealthy appearing child\nWeight: 18 kg    HR: 140    BP: 80/54    RR: 20\nAirway: normal\nLungs: clear\nHeart: normal\n\nLabs\nNone ordered\n\nNPO Status\nLast ate 6 hours ago.\n\nPatient and Surgeon Requests\nThe surgeon requests endotracheal intubation.\n\n", 
    "volAnDsp": 40, 
    "states": [
        {
            "name": "AWAKE", 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "whatNextMsg": "Administer oxygen by mask. In this simulated case you can perform an inhalation or intravenous induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 60, 
            "baseAbpS": 78, 
            "baseBicarb": 23.8, 
            "baseHr": 148, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 100, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You administered an intravenous sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered an inhalational anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV1", 
            "recordMsg": "Lightly sedated with intravenous agents.", 
            "whatNextMsg": "Continue induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 74, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 150, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
             "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.05
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered an inhalational anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV2", 
            "recordMsg": "Deeply sedated with intravenous agents.", 
            "whatNextMsg": "Continue induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 54, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 100, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                 {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
               {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "recordMsg": "Anesthetized with intravenous agents.", 
            "whatNextMsg": "Place the endotracheal tube.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.3
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBEIV", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "TUBEIV", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSPROP", 
            "recordMsg": "You adminietered an excessive dose of propofol.", 
            "whatNextMsg": "End of simulation. You should repeat this case scenario.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 20, 
            "baseAbpM": 28, 
            "baseAbpS": 46, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.3
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBEIV", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "TUBEIV", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEIV", 
            "recordMsg": "Anesthetized and airway secured.", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.3
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBEINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2IV", 
            "recordMsg": "Adequate anesthesia.", 
            "whatNextMsg": "Inform the surgeon when the patient is ready.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPIV", 
            "recordMsg": "Maintenance anesthesia.", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 30, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DONEIV", 
                    "comment": "You successfully completed the induction sequence (+100 pts).", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
         {
            "name": "DONEIV", 
            "recordMsg": "Maintenance anesthesia.", 
            "whatNextMsg": "You successfully completed this simulated case.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 4, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 30, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9 
        }, 
       {
            "name": "SEDATEDINH", 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "whatNextMsg": "Continue induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 22, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                 {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
               {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.05
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "recordMsg": "Adequately anesthetized with intravenous agents.", 
            "whatNextMsg": "Place the endotracheal tube.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You should place an endotracheal tube to facilitate the procedure. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBEINH", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "TUBEINH", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEINH", 
            "recordMsg": "Anesthetized and airway secured.", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 22, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.3
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBEIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2INH", 
            "recordMsg": "Adequate anesthesia.", 
            "whatNextMsg": "Inform the surgeon when the patient is ready.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "recordMsg": "Maintenance anesthesia.", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 52, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DONEINH", 
                    "comment": "You completed this simulation. (+100 points).", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DONEINH", 
            "recordMsg": "Maintenance anesthesia.", 
            "whatNextMsg": "You completed this simulation.", 
 			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 4, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sat20": 97, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 144, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9 
        }, 
        {
            "name": "AWAKEPARA", 
            "recordMsg": "Awake but paralyzed.", 
            "whatNextMsg": "Call your lawyer.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                 {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
               {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASYST", 
            "recordMsg": "The patient cannot be resuscitated.", 
            "whatNextMsg": "Notify the family. End of case simulation.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 58, 
            "contPlateau": 56, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 85, 
            "sat40": 91, 
            "sat100": 93, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9
        }, 
        {
            "name": "COUGH5", 
            "recordMsg": "Upset and coughing.", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
  			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 66, 
            "baseAbpS": 84, 
            "baseBicarb": 24, 
            "baseHr": 148, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing but the breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "recordMsg": "Screaming and writhing in pain.", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
  			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 66, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 148, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH4", 
            "recordMsg": "Upset and coughing.", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing but the breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "recordMsg": "Screaming and writhing in pain.", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "recordMsg": "Asleep and paralyzed.", 
            "whatNextMsg": "Now perform laryngoscopy and place the endotracheal intubation.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
             "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 60, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 28, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
           "trans": [
                {
                    "nextState": "XSPROP", 
                    "comment": "You administered an excessively large dose of propofol. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "recordMsg": "Hypoxic and bradycardic.", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
  			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
             "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
  			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 28, 
            "baseAbpM": 32, 
            "baseAbpS": 42, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "recordMsg": "Hypoxic and asystolic.", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 2, 
            "rateUo": 1.5, 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9, 
             "trans": [
                {
                    "nextState": "DESATDEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATDEAD", 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "whatNextMsg": "Notify the family.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.0, 
            "stSegV5": 0.0, 
            "temperature": 36.9
        }
    ]
}