CaseData[56] = {
    "title": "Case 115 - 40 year old for excision of pheochromocytoma", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1, 
    "debriefMsg": "pheo based on case 15", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": false, 
    "imageSet": 4, 
    "initialSat": 96, 
    "leanBodyMass": 80, 
    "learningObj": "", 
    "possiblePoints": 1200, 
    "preopMsg": "\n40 year old for excision of pheochromocytoma\n\nHistory of Present Illness\nThe patient has a 6 month history of frequent severe headaches, palpitations, and hypertension. Pheochromocytoma diagnosed by elevated urinary and plasma catecholamines and metabolites; localized to right adrenal gland by CT, MRI, and MIBG (metaiodobenzylguanadine) scans. Treated with phenoxybenzamine for the past two weeks.\n\nPast Medical History\nIllnesses: no other illnesses\nSurgeries: none\nMeds: phenoxybenzamine for the past two weeks\nAllergies: Penicillin\nHabits: occasional alcohol intake\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam: \nHeight: 5'9\"      Weight: 80 Kg \nHR: 82     BP: 160/90 - 200/110    RR: 18\nAirway: normal\nLungs: clear\nHeart: normal\n\nLabs\nHct: 48     Na: 145      K: 4.5    Bun: 18      Cr: 1.1\nECG: sinus rhythm\nCXR: mild cardiomegaly, otherwise normal\n\nNPO Status\nLast ate 8 hours ago. \n\nPatient and Surgeon Requests\nThe surgeon states the procedure will take about four hours.\n\n", 
    "volAnDsp": 80,
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer a sedative agent. Titrate additional alpha-blocker such as phentolamine and replace fluids.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 116, 
            "baseAbpM": 146, 
            "baseAbpS": 198, 
            "baseBicarb": 23.8, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 28, 
            "papM": 40, 
            "papS": 68, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered esmolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated esmolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated metoprolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated propranolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATED", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "Better to alpha-block before administering fluids. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATED", 
            "whatNextMsg": "Add additional alpha-blockade - Phentolamine 2-5 mg doses.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 108, 
            "baseAbpM": 138, 
            "baseAbpS": 186, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 24, 
            "papM": 36, 
            "papS": 56, 
            "papW": 3, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered esmolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You titrated esmolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered metoprolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETA", 
                    "comment": "You administered propranolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEP5", 
                    "comment": "You induced anesthesia before administering alpha blockers, fluids and beta blockers. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.0
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "Better to alpha-block before administering fluids. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 122, 
            "baseAbpM": 154, 
            "baseAbpS": 226, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "HURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 122, 
            "baseAbpM": 152, 
            "baseAbpS": 256, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 28, 
            "papM": 46, 
            "papS": 74, 
            "papW": 4, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 134, 
            "baseAbpM": 164, 
            "baseAbpS": 244, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 24, 
            "papM": 42, 
            "papS": 70, 
            "papW": 4, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ALPHA", 
            "whatNextMsg": "Now administer at least 1000 mL bolus of intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 104, 
            "baseAbpS": 144, 
            "baseBicarb": 20, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 3.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are flat.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 22, 
            "papM": 30, 
            "papS": 46, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid. Jugular veins are flat.", 
            "pupilsMsg": "The pupils are equal, round and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha blocker or vasodilator administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are flat.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered esmolol. Better to replace fluids before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated esmolol. Better to replace fluids before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered metoprolol. Better to replace fluids before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered propranolol. Better to replace fluids before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You induced anesthesia before before replacing fluids adequately. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "BETA", 
            "whatNextMsg": "Now administer an alpha-blocking agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 92, 
            "baseAbpS": 124, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Beta-blocker was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before administering alpha blockers and fluids. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You administered labetalol after another beta-blocker. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHABETA", 
                    "comment": "You titrated labetalol after another beta-blocker. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "FLUID", 
            "whatNextMsg": "Now administer an alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 122, 
            "baseAbpS": 178, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 34, 
            "papM": 44, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid bolus administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before administering alpha blockers and beta blockers. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUID", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered esmolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You titrated esmolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered metoprolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "BETAFLUID", 
                    "comment": "You administered propranolol. Better to alpha-block before beta-blocking. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ALPHABETA", 
            "whatNextMsg": "Now administer a fluid bolus of at least 1000 mL.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 62, 
            "baseAbpS": 82, 
            "baseBicarb": 20, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 36, 
            "papM": 46, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha and beta blocking agents administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia before replacing fluids. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ALPHAFLUID", 
            "whatNextMsg": "Now administer a beta-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 86, 
            "baseAbpM": 104, 
            "baseAbpS": 146, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 4.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 24, 
            "papM": 38, 
            "papS": 52, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha-blocker and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia before administering beta blockers. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered labetalol after another alpha-blocker. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated labetalol after another alpha-blocker. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered esmolol appropriately.  (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated esmolol appropriately.  (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 10
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered metoprolol appropriately.  (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Metoprolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered propranolol. Better to metoprolol or esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propranolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "BETAFLUID", 
            "whatNextMsg": "Now administer an alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 94, 
            "baseAbpS": 136, 
            "baseBicarb": 20, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 44, 
            "papS": 72, 
            "papW": 18, 
            "pulseMsg": "The pulse is rapid. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Beta-blocker and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia before administering alpha blockers, fluids and beta blockers. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You administered labetalol after another beta-blocker. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ALPHAFLUIDBETA", 
                    "comment": "You titrated labetalol after another beta-blocker. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ALPHAFLUIDBETA", 
            "whatNextMsg": "Now induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 98, 
            "baseAbpS": 144, 
            "baseBicarb": 20, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Alpha blocker, fluids, and beta-blocker administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia after administering alpha blockers, fluids and beta blockers. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 82, 
            "baseAbpM": 96, 
            "baseAbpS": 136, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 108, 
            "baseAbpS": 142, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 108, 
            "baseAbpM": 142, 
            "baseAbpS": 204, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 148, 
            "baseAbpS": 212, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension associated with pheo with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "Observe and continue treatment.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 96, 
            "baseAbpM": 116, 
            "baseAbpS": 158, 
            "baseBicarb": 20, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9,
            "trans": [
                {
                
                    "nextState": "FINAL", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                } 
			]
        }, 
        {
            "name": "FINAL", 
            "whatNextMsg": "You successfully avoided malignant hypertension.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 96, 
            "baseAbpM": 116, 
            "baseAbpS": 158, 
            "baseBicarb": 20, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "ASLEEP5", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 56, 
            "baseAbpS": 76, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 28, 
            "papS": 46, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized before alpha and beta blockade and fluid replacement.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE5", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE5", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE5", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE5", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 116, 
            "baseAbpS": 186, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 56, 
            "papW": 3, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA5", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA5", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 68, 
            "baseAbpS": 106, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 26, 
            "papS": 38, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP5", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP5", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP5", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 122, 
            "baseAbpM": 154, 
            "baseAbpS": 226, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN5", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 108, 
            "baseAbpM": 142, 
            "baseAbpS": 204, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP5", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN5", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 148, 
            "baseAbpS": 242, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension associated with pheo with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "UNSTABLE", 
            "whatNextMsg": "Observe and continue treatment.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 96, 
            "baseAbpM": 116, 
            "baseAbpS": 158, 
            "baseBicarb": 20, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9,
            "trans": [
                {
                
                    "nextState": "FINAL0", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                } 
			]
        }, 
        {
            "name": "FINAL0", 
            "whatNextMsg": "You did not adequately administer alpha blockade and fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 96, 
            "baseAbpM": 116, 
            "baseAbpS": 158, 
            "baseBicarb": 20, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "ASLEEP4", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 56, 
            "baseAbpS": 76, 
            "baseBicarb": 24, 
            "baseHr": 112, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 28, 
            "papS": 46, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after beta-blockers and fluids, but no alpha-blockade.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE4", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE4", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE4", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE4", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 116, 
            "baseAbpS": 186, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 56, 
            "papW": 3, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA4", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA4", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 68, 
            "baseAbpS": 106, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 26, 
            "papS": 38, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP4", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP4", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP4", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 122, 
            "baseAbpM": 154, 
            "baseAbpS": 226, 
            "baseBicarb": 24, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN4", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 108, 
            "baseAbpM": 142, 
            "baseAbpS": 204, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP4", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN4", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 148, 
            "baseAbpS": 242, 
            "baseBicarb": 24, 
            "baseHr": 62, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension associated with pheo with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP3", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 112, 
            "baseAbpS": 154, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after alpha-blockade, but not beta-blockade.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE3", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE3", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE3", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE3", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 92, 
            "baseAbpM": 106, 
            "baseAbpS": 156, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA3", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 110, 
            "baseAbpS": 146, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP3", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP3", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP3", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 102, 
            "baseAbpM": 118, 
            "baseAbpS": 162, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN3", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 118, 
            "baseAbpM": 152, 
            "baseAbpS": 224, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP3", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN3", 
            "whatNextMsg": "Deepen the anesthetic and administer additional alpha-blocker.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 124, 
            "baseAbpM": 158, 
            "baseAbpS": 232, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You titrated phentolamine to block alpha receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 18
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You titrated labetalol to block alpha and beta receptors. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "UNSTABLE", 
                    "comment": "You administered nitroprusside as a vasodilator. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension associated with pheo with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 430
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ST3", 
            "whatNextMsg": "Try esmolol to slow the heart rate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 134, 
            "baseAbpS": 174, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient appears to be in distress.", 
            "papD": 26, 
            "papM": 34, 
            "papS": 66, 
            "papW": 14, 
            "pulseMsg": "The pulse is weak but present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Deep ST depression.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3.2, 
            "stSegV5": -2.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "Review the learning objectives and try the case again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}