<?php
// Debug mode configuration for save logging

// Get debug mode status
function isDebugModeEnabled() {
    $configFile = ROOT_PATH . '/configs/debug_mode.json';
    
    if (!file_exists($configFile)) {
        return true;
    }
    
    $config = json_decode(file_get_contents($configFile), true);
    return isset($config['save_logging_enabled']) ? $config['save_logging_enabled'] : true;
}

// Set debug mode status
function setDebugMode($enabled) {
    $configFile = ROOT_PATH . '/configs/debug_mode.json';
    $config = ['save_logging_enabled' => $enabled];
    
    return file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT)) !== false;
}

// Log only if debug mode is enabled
function logCaseSaveDebug($userId, $username, $userEmail, $grade, $score, $status, $errorType = null, $errorMsg = null, $insertId = null) {
    if (!isDebugModeEnabled()) {
        return;
    }
    
    logCaseSave($userId, $username, $userEmail, $grade, $score, $status, $errorType, $errorMsg, $insertId);
}
?>
