<?php

/**
 * File Name :	group.class.php
 * Author: Everplex
 * Class : Group
 * 
 * This Class includes all the functions used in group
 * 
 */
class Group {

    private $pdo;

    /**
     * Constructor
     */
    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    /**
     * Get group data from DB
     */
	public function fetchGroups(): array|false {
		$table = WP_PREFIX . "groups";
		$sql = "SELECT * FROM $table ORDER BY group_name";
		$stmt = $this->pdo->prepare($sql);
		$stmt->execute();
		return $stmt->fetchAll(PDO::FETCH_ASSOC) ?: false;
	}

	/**
	 * Get visible group data from DB
	 */
	public function fetchVisibleGroups(): array|false {
		$table = WP_PREFIX . "groups";
		$sql = "SELECT * FROM $table WHERE is_hidden = 0 OR is_hidden IS NULL ORDER BY group_name";
		$stmt = $this->pdo->prepare($sql);
		$stmt->execute();
		return $stmt->fetchAll(PDO::FETCH_ASSOC) ?: false;
	}
    
    /**
     * Get group data from DB by ID
     */
	public function fetchGroupById($id) {
		if (empty($id)) {
			return false;
		}

		$table = WP_PREFIX . "groups";
		$sql = "SELECT * FROM $table WHERE id = :id";
		$stmt = $this->pdo->prepare($sql);
		$stmt->execute(['id' => $id]);
		return $stmt->fetch(PDO::FETCH_ASSOC);
	}

    /**
     * Fetch group password
     */
    public function fetchGroupPassword(int $group_id): string|false {
        $table = WP_PREFIX . "groups";

        $sql = "SELECT group_pass FROM $table WHERE id = :id";
        $stmt = $this->pdo->prepare($sql);
        $stmt->bindParam(':id', $group_id, PDO::PARAM_INT);
        $stmt->execute();
        $password = $stmt->fetchColumn();

        return $password ?: false;
    }
	
    /**
     * Fetch group_clear_pass
     */
	 /* for expanding ****
    public function fetchGroupClearPassword(int $group_id): string|false {
        $table = WP_PREFIX . "groups";

        $sql = "SELECT group_clear_pass FROM $table WHERE id = :id";
        $stmt = $this->pdo->prepare($sql);
        $stmt->bindParam(':id', $group_id, PDO::PARAM_INT);
        $stmt->execute();
        $fetchClearPass = $stmt->fetchColumn();

        return $fetchClearPass ?: false;
    }
	/* end */
}
?>
