<?php
// File: get_case_details.php
require_once 'pro_features.php';
require_once 'case_data_handler.php';

header('Content-Type: application/javascript');

$caseId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$isPro = isProFeatureEnabled('additional_cases');

$case = getCaseData($caseId);

if (!$case) {
    echo "console.error('Case not found');";
    exit;
}

if (($case['isPro'] ?? false) && !$isPro) {
    echo "console.error('Pro feature required');";
    exit;
}

echo "var CurrentCase = " . json_encode($case, JSON_PRETTY_PRINT) . ";";