document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    if (searchInput) {
        searchInput.addEventListener('input', debounce(filterTable, 300));
    }
});

function filterTable() {
    const input = document.getElementById('searchInput');
    const filter = input.value.toUpperCase();
    const table = document.querySelector('.home-table:not(.recent-cases-table)');
    if (!table) return; // Exit if table not found

    const rows = table.querySelectorAll('tr:not(:first-child)'); // Skip header row
    let visibleCount = 0;

    rows.forEach(row => {
        const emailCell = row.querySelector('td'); // First cell should be email
        if (emailCell) {
            const emailText = emailCell.textContent || emailCell.innerText;
            if (emailText.toUpperCase().indexOf(filter) === 0) {
                row.style.display = '';
                visibleCount++;
            } else {
                row.style.display = 'none';
            }
        }
    });

    // Show "No results found" if no matches
    let noResultsRow = table.querySelector('.no-results');
    if (visibleCount === 0) {
        if (!noResultsRow) {
            noResultsRow = table.insertRow();
            noResultsRow.className = 'no-results';
            const cell = noResultsRow.insertCell(0);
            cell.colSpan = table.rows[0].cells.length;
            cell.textContent = 'No results found';
        }
        noResultsRow.style.display = '';
    } else if (noResultsRow) {
        noResultsRow.style.display = 'none';
    }

    // Update the URL without reloading the page
    const url = new URL(window.location);
    if (filter) {
        url.searchParams.set('search', input.value);
    } else {
        url.searchParams.delete('search');
    }
    window.history.replaceState({}, '', url);
}

function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}