CaseData[3] = {
    "title": "Case 3 - 86 year old female with fractured hip", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "This patient is severely dehydrated. You should administer 500-1000 mL of intravenous fluids prior to induction since hypovolemic patients can become extremely hypotensive on induction.", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 6, 
    "initialSat": 96, 
    "leanBodyMass": 48, 
    "learningObj": "\n86 year old female with fractured hip (46 kg)\n\nThis patient has a number of potentially important problems.   Advanced age is often associated with reduced myocardial performance, and decreased ventilatory function causing an increased susceptibility to the depressant effects of anesthetic agents. Furthermore, a decline in renal and hepatic function lead to prolonged elimination of drugs and increase the likelihood of adverse drug interactions.\n\nThis patient's history, physical exam, and laboratory studies all indicate severe hypovolemia. Preoperative fluid replacement and monitoring of cardiac filling pressures and urine output is suggested. Inadequate preoperative fluid replacement may lead to hypotension on induction.\n\n In this simulation you need to replace intravascular volume, induce anesthesia and provide adequate general anesthesia in preparation for the surgical incision.\n\nLearning Objectives\n1. How is hypovolemia recognized prior to induction and why is this important?\n2. List the differential diagnosis of hypotension under general anesthesia and describe your management approach.\n\nAnesthetic Considerations\n1. Advanced age\n2. Hypovolemia\n\nSuggested Management\n1. Routine monitoring, plus intraarterial and central venous pressure measurements and urine output.\n2. Volume replacement. Optimally, intravascular volume deficits would be corrected slowly, but for this simulation please proceed with the case after rapid rehydration.\n3. Preoxygenate\n4. Judicious titration of narcotic, hypnotic and relaxant followed by tracheal intubation.\n5. Maintain anesthesia with oxygen, narcotics, and inhaled agent as tolerated.\n6. Extubate after return of airway reflexes.\n\nRecognition of Hypovolemia\n1. Estimation of fluid in's and out's.\n2. Oliguria\n3. Orthostatic hypotension\n4. SPV - Systolic Pressure Variation \n5. Low filling pressures - CVP, PAWP\n6. Tachycardia\n7. Hypotension\n\nDifferential Diagnosis for Hypotension\n1. Preload\na. Hypovolemia\nb. Venous dilation secondary to medications\nc. Obstructed venous return - compression\nd. Increased intrathoracic pressure\n\n2. Pump - rate, rhythm, contractility\na. Myocardial ischemia\nb. Anesthetic agents\n\n3. Afterload\na. Sympathetic block\nb. Medications\n\n4. Mixed\na. Anaphylactic reaction\nb. Transfusion reaction\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: March 6, 2013\n\n", 
    "possiblePoints": 800, 
    "preopMsg": "\n86 year old female with fractured hip\n\nHistory of Present Illness\nThe patient has been complaining of hip pain since she fell out of bed 2 days ago.  She has refused to eat or drink since then.\n\nPast Medical History\nIllnesses: Hard of hearing, mild depression\nSurgeries: Cataracts (retrobulbar block) no complications\nMeds: Amitriptyline\nHabits: Denies smoking, alcohol and other drugs\nNo known drug allergies\n\nFamily History\nNo family history of anesthetic problems.\n\nPhysical Exam\nThin, elderly female, in moderate distress, seems confused.\nWt : 46 kg    HR : 118      BP : 96/60      RR : 18\nAirway: normal\nLungs : clear  \nHeart : normal\n\nLabs\nHematocrit: 48%\nNa : 142      K : 4.0      Cl : 110     HCO3 : 22\nBun : 36     Cr : 1.8\nRoom air: pH : 7.36    PCO2 : 38    PO2 : 81\nECG : sinus tachycardia\nCXR : no acute disease\n\nNPO Status\nThe patient last ate 48 hours ago. \n\nPatient and Surgeon Requests\nThe patient's son, a lawyer, refuses to have needles stuck in his mother's back.  The surgeon states the procedure will take about two hours.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "DRY", 
            "whatNextMsg": "Rehydrate prior to induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 96, 
            "baseBicarb": 23.8, 
            "baseHr": 118, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 3, 
            "pulseMsg": "The pulse is weak and rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry but has slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 118, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUIDS1", 
                    "comment": "You partially rehydrated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 299
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDRY", 
                    "comment": "You administered a sedative agent. (+50 of 100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "FLUIDS1", 
            "whatNextMsg": "Continue to administer fluids until vital signs stabilize.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 78, 
            "baseAbpS": 106, 
            "baseBicarb": 23.8, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 44, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 15, 
            "papW": 5, 
            "pulseMsg": "The pulse is stronger but still fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Partially rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 108, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUIDS2", 
                    "comment": "You adequately rehydrated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 799
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "FLUIDS2", 
            "whatNextMsg": "Preoxygenate, induce general anesthesia and intubate. Consider etomidate over propofol to decrease hypotension.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 86, 
            "baseAbpS": 116, 
            "baseBicarb": 23.8, 
            "baseHr": 96, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 42, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 9, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 96, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEDRY", 
            "whatNextMsg": "Rehydrate this patient prior to induction of anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 23.8, 
            "baseHr": 128, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is fast but weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated but not rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 128, 
            "spSignal": 2, 
            "spontRr": 8, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia before replacing volume. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You partially rehydrated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 299
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEFLUIDS1", 
            "whatNextMsg": "Administer additional intravenous fluids.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 78, 
            "baseAbpS": 102, 
            "baseBicarb": 23.8, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 15, 
            "papW": 5, 
            "pulseMsg": "The pulse is fast and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Partially rehydrated and sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 120, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You administered adequate volume replacement. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 799
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You induced anesthesia prior to adequately replacing volume. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an under anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You administered muscle relaxant before completely inducing unconsciousness. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an under anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEFLUIDS2", 
            "whatNextMsg": "Preoxygenate, induce anesthesia and intubate.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 70, 
            "baseAbpM": 84, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 42, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 9, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 98, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1", 
                    "comment": "You induced anesthesia after adequately treating hypovolemia.  (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 88, 
            "baseAbpS": 116, 
            "baseBicarb": 23.8, 
            "baseHr": 122, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 3, 
            "pulseMsg": "The pulse is fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing. ST depression is present.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 122, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": -2.2, 
            "stSegV5": -2.8, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DRY", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Administer narcotic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 88, 
            "baseAbpS": 116, 
            "baseBicarb": 23.8, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 3, 
            "pulseMsg": "The pulse is fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain. ST depression is present.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 120, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": -2.2, 
            "stSegV5": -2.8, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DRY", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia before adequately replacing volume. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "PARA5", 
            "whatNextMsg": "Call your lawyer.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 88, 
            "baseAbpS": 116, 
            "baseBicarb": 23.8, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 3, 
            "pulseMsg": "The pulse is fast", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 120, 
            "spSignal": 2, 
            "spontTv": 0, 
            "spontRr": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.4, 
            "stSegV5": 0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DRY", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia without adequately replacing volume. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You placed the endotracheal tube before induction of anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPDRY", 
            "whatNextMsg": "Administer fluids and pressors to resuscitate.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized but only partially rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 128, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1", 
                    "comment": "You delayed securing the airway for too long. (-50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -50
                }
            ]
        }, 
        {
            "name": "ASLEEPVERYDRY", 
            "whatNextMsg": "Resuscitate with volume replacement and pressors.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 48, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 138, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is weak.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized without fluid replacement. The patient is now hypotensive and has ST depression.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 138, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3.2, 
            "stSegV5": -3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You partially rehydrated the patient, but only after induction of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 299
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "The rhythm degenerated to ventricular fibrillation. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "VFIB", 
            "whatNextMsg": "Call for help and call your lawyer.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Cardiac arrest!", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88,
            "sat40": 92, 
            "sat100": 94, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0, 
            "stSegV5": 0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "The rhythm degenerated to asystole. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "GA1", 
            "whatNextMsg": "Secure the airway with an LMA or endotracheal tube.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 18, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthesia induced, ready for intubation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1DEEP", 
                    "comment": "You administered deep anesthetic for this patient. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA1DEEP", 
            "whatNextMsg": "Secure the airway with an LMA or endotracheal tube.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 62, 
            "baseAbpS": 78, 
            "baseBicarb": 24, 
            "baseHr": 109, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 18, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthesia induced, ready for intubation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You waited too long to secure the airway. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA1SECURE", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 18, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 96, 
            "spRate": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered adequate anesthetic for this patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 93, 
            "spRate": 106, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You deepened the anesthetic.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2", 
            "whatNextMsg": "Maintenance phase. Instruct the surgeon to make the incision. Monitor the patient carefully.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 93, 
            "spRate": 66, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You instructed the surgeon to make the incision appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA3", 
                    "comment": "You instructed the surgeon to operate. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA3", 
            "whatNextMsg": "Deep maintenance anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 93, 
            "spRate": 78, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA4", 
                    "comment": "You administered an excessively deep anesthetic. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 3
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA4", 
            "whatNextMsg": "Excessively deep anesthesia during maintenance. Decrease anesthetic depth.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Very deeply anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 93, 
            "spRate": 82, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You lightened the anesthetic depth appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.8
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 62, 
            "sat40": 64, 
            "sat100": 66, 
            "spRate": 32, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 62, 
            "sat40": 64, 
            "sat100": 66, 
            "spRate": 22, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 62, 
            "sat40": 64, 
            "sat100": 66, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontTv": 0, 
            "spontRr": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 62, 
            "sat40": 64, 
            "sat100": 66, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9
        }
    ]
}