CaseData[79] = {
    "title": "Case 138 - 23 year old preeclamptic for urgent cesarean delivery", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1, 
    "debriefMsg": "preeclampsia based on case 37", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": false, 
    "imageSet": 3, 
    "initialSat": 96, 
    "leanBodyMass": 72, 
    "learningObj": "", 
    "possiblePoints": 1500, 
    "preopMsg": "\n23 year old preeclamptic for induction of labor followed by Cesarean delivery\n\nHistory of Present Illness\nG1P0 at 30 weeks estimated gestational age. The patient has severe hypertension, proteinuria, elevated liver enzymes and low platelets, but has not had any seizures. She is receiving an oxytocin infusion to induce labor because of worsening preeclampsia and concerns of fetal well being. The patient has been making poor progress and the fetus has developed a worrisome fetal heart rate pattern with poor beat-to-beat variability and repetitive late decelerations with uterine contractions.\n\nPast Medical History\nIllnesses - no other illnesses\nSurgeries - appendectomy 5 years ago without problems\nMeds - none\nAllergies - none\nHabits - smokes 1-2 packs per day\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nWeight: 78 kg\nHR 98, BP 170/120, RR 18\nAirway - Class III, facial edema\nLungs - crepitations at left base \nHeart - normal\nNeuro - brisk reflexes, no focal neurologic signs\n\nLabs\nHematocrit 39, Creatinine 0.8, SGOT 20\nFibrinogen  518, PT 11.1, PTT 28, Platelets 54,000\nUrine protein 4+\n\nNPO Status\nLast ate 8 hours ago. \n\nPatient and Surgeon Requests\nThe obstetrician requests general anesthesia for immediate cesarean delivery.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Use left uterine displacement position and administer an antihypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 106, 
            "baseAbpM": 138, 
            "baseAbpS": 198, 
            "baseBicarb": 23.8, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 9, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 28, 
            "papM": 40, 
            "papS": 68, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "LABET", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "LABET", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "LABET", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYDRAL", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HYDRAL", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "NIFED", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 41
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "NIFED", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "NICARD", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SNP", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "PHENT", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -200
                }, 
               {
                    "nextState": "PHENT", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PHENT", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATED", 
                    "comment": "You administered a sedative agent. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATED", 
            "whatNextMsg": "Use left uterine displacement position and administer an antihypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 134, 
            "baseAbpS": 188, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 9, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 24, 
            "papM": 36, 
            "papS": 56, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "LABET", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "LABET", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "LABET", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYDRAL", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HYDRAL", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "NIFED", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "NIFED", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "NICARD", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SNP", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "PHENT", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "PHENT", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "PHENT", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension and use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "LABET", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 128, 
            "baseAbpS": 182, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 3.8, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are flat.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 22, 
            "papM": 30, 
            "papS": 46, 
            "papW": 12, 
            "pulseMsg": "The pulse is rapid. Jugular veins are flat.", 
            "pupilsMsg": "The pupils are equal, round and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Labetalol administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are flat.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "SECOND", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agent and use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HYDRAL", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 136, 
            "baseAbpS": 184, 
            "baseBicarb": 20, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hydralazine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "SECOND", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agent and use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "NIFED", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 134, 
            "baseAbpS": 184, 
            "baseBicarb": 20, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Nifedipine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "SECOND", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agentand use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "NICARD", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 134, 
            "baseAbpS": 184, 
            "baseBicarb": 20, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Nicardipine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "SECOND", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
					], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agent and use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -600
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SNP", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 134, 
            "baseAbpS": 182, 
            "baseBicarb": 20, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Nitroprusside was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "SECOND", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agentand use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ESM", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 132, 
            "baseAbpS": 184, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 9, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Esmolol administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "SECOND", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started a phentolamine infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "GT", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agent and use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PHENT", 
            "whatNextMsg": "Now administer a second anti-hypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 132, 
            "baseAbpS": 182, 
            "baseBicarb": 20, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 72, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Phentolamine was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of labetalol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 19
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 31
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of nicardipine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nicardipine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an infusion of sodium nitroprusside. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroprusside", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SECOND", 
                    "comment": "You started an esmolol infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You should have treated the hypertension with a second agent before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Treat hypertension with a second agent and use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -1500
                }, 
                {
                    "nextState": "XSFLUID", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the LMA in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSFLUID", 
            "whatNextMsg": "Induce anesthesia", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 112, 
            "baseAbpM": 152, 
            "baseAbpS": 224, 
            "baseBicarb": 20, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 34, 
            "papM": 44, 
            "papS": 62, 
            "papW": 22, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid bolus administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced anesthesia and used left uterine displacement position. (+400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Use left uterine displacement. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SECOND", 
            "whatNextMsg": "Induce anesthesia", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 108, 
            "baseAbpS": 148, 
            "baseBicarb": 20, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are full.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is responsive.", 
            "papD": 34, 
            "papM": 44, 
            "papS": 62, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid. Jugular veins are full.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Two anti-hypertensives administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are full.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPTREATED", 
                    "comment": "You induced anesthesia and used left uterine displacement poistion. (+400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
						{
                            "op": "EQ", 
                            "type": "left", 
                            "value": true
                        }
                    ], 
                    "points": 400
                }, 
                {
                    "nextState": "ASLEEPTREATED", 
                    "comment": "Use left uterine displacement. (Lost points)", 
                    "conditions": [
                         {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unanesthetized  patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPTREATED", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 82, 
            "baseAbpM": 102, 
            "baseAbpS": 144, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "TUBETREATED", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBETREATED", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBETREATED", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBETREATED", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 102, 
            "baseAbpS": 148, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE", 
                    "comment": "Minimize fluid administration in preeclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "GATREATED", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GATREATED", 
            "whatNextMsg": "Adjust anesthetic depth and inform the surgeon when it is appropriate to make the incision.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 98, 
            "baseAbpS": 142, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 36, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA", 
                    "comment": "Minimize fluid administration in preeclampsia/eclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "OPTREATED", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPTREATED", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPTREATED", 
            "whatNextMsg": "Monitor closely and adjust the anesthetic as appropriate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 82, 
            "baseAbpM": 102, 
            "baseAbpS": 144, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "Minimize fluid administration in preeclampsia/eclampsia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "HTN", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 92, 
            "baseAbpM": 130, 
            "baseAbpS": 184, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized without appropriate pretreatment.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBE", 
                    "comment": "You should place an endotracheal tube due to the extensive surgery. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBE", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBE", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBE", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 98, 
            "baseAbpM": 136, 
            "baseAbpS": 220, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 26, 
            "papS": 38, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (-100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA", 
            "whatNextMsg": "Adjust anesthetic depth and inform the surgeon when it is appropriate to make the incision.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 102, 
            "baseAbpS": 170, 
            "baseBicarb": 24, 
            "baseHr": 115, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 36, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia for surgery.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "You appropriately allowed the surgeon to make an incision at this time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OP", 
                    "comment": "You appropriately allowed the surgeon to operate. (+50 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OP", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 108, 
            "baseAbpM": 134, 
            "baseAbpS": 210, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. Surgery in progress.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HTN", 
                    "comment": "The simulation forced the patient to develop hypertension.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 118, 
            "baseAbpM": 142, 
            "baseAbpS": 204, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 42, 
            "papS": 58, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OP", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HTN", 
            "whatNextMsg": "Administer a bolus of an antihypertensive agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 118, 
            "baseAbpS": 184, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 11, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypertension during general anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of labetalol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 81
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered labetalol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Labetalol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of hydralazine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered hydralzine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Hydralazine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of nifedipine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 41
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered nifedipine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nifedipine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered esmolol to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "STABLE", 
                    "comment": "You administered an excessive dose of phentolamine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": -200
                }, 
               {
                    "nextState": "STABLE", 
                    "comment": "You administered phentolamine to lower the blood pressure. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Phentolamine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "Treat the hypertension with vasodilator sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "Hypertensive episode treated. Continue to monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 98, 
            "baseAbpS": 146, 
            "baseBicarb": 20, 
            "baseHr": 90, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 14, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9,
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "You administered furosemide to this patient. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Furosemide", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
               {
                    "nextState": "FINAL", 
                    "comment": "You should have administered furosemide to this preeclamptic patient. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": -200
                }
            ]
        }, 
        {
            "name": "FINAL", 
            "whatNextMsg": "You completed this case scenario.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 98, 
            "baseAbpS": 144, 
            "baseBicarb": 20, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 5.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 10, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 32, 
            "papS": 48, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Scenario complete.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "COUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 112, 
            "baseAbpM": 148, 
            "baseAbpS": 220, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 32, 
            "papM": 46, 
            "papS": 72, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 97, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "HURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 114, 
            "baseAbpM": 132, 
            "baseAbpS": 226, 
            "baseBicarb": 24, 
            "baseHr": 146, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 28, 
            "papM": 46, 
            "papS": 74, 
            "papW": 18, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 10, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 124, 
            "baseAbpM": 154, 
            "baseAbpS": 214, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling her lawyer.", 
            "papD": 24, 
            "papM": 42, 
            "papS": 70, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ST3", 
            "whatNextMsg": "Try esmolol to slow the heart rate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 120, 
            "baseAbpS": 144, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient appears to be in distress.", 
            "papD": 26, 
            "papM": 34, 
            "papS": 66, 
            "papW": 14, 
            "pulseMsg": "The pulse is weak but present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Deep ST depression.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 99, 
            "sat100": 100, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3.2, 
            "stSegV5": -2.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "Review the learning objectives and try the case again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}