CaseData[39] = {
    "title": "Case 39 - 32 year old G8P5 with post-partum hemorrhage", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "\nYou must resuscitate the patient quickly with fluid replacement prior to induction of anesthesia. Then follow the procedures for rapid sequence induction of general anesthesia: preoxygenate, apply cricoid pressure, administer a bolus of hypnotic agent such as propofol or etomidate, administer succinylcholine and intubate; release cricoid pressure after confirming correct placementof the endotracheal tube. Continue fluid replacement and administration of pressors to avoid extreme hypotension during deep inhalational anesthesia.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 6, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 3, 
    "initialSat": 96, 
    "leanBodyMass": 80, 
    "learningObj": "\n32 year old G8P5 with post-partum hemorrhage (87 kg)\n\nThis patient has had many pregnancies and just delivered baby, placenta, and uterus. She is bleeding profusely. The obstetrician requests deep inhalation anesthesia to facilitate reinsertion of the uterus.\n\nLearning Objectives\n1. List the predisposing conditions that lead to postpartum hemorrhage (PPH).\n2. List the differential diagnosis of PPH.\n3. List the presenting signs of PPH.\n4. Describe acute management of PPH.\n\nPredisposing Conditions Leading to PPH\n1. Grand multiparity\n2. Previous cesarean section; uterine rupture\n3. Multiple gestation\n4. Instrumental vaginal delivery\n5. Coagulopathy\n6. Uterine inversion\n7. Postpartum uterine atony\n\nPresenting Signs of Postpartum Hemorrhage\n1. Uncontrolled vaginal hemorrhage (not always externally apparent)\n2. Maternal hemodynamic instability\n3. Decreased arterial oxygen saturation\n\nDifferential Diagnosis of Postpartum Hemorrhage\n1. Placental abruption (coagulopathy or uterine atony due to intramyometrial hemorrhage)\n2. Placenta Accreta/Increta/Percreta\n3. Uterine rupture\n4. Uterine inversion\n5. Uterine atony (due to retained products of conception, myomata, or unresponsiveness to oxytocin)\n6. Coagulopathy (secondary to DIC, severe preeclampsia, preexisting hematologic disease)\n7. Cervical or vaginal laceration\n\nTreatment of Uterine Inversion\n1. Obstetric reduction of inversion sometimes requires anesthesia for reinversion.\n2. Immediate discontinuation of uterine stimulants.\n3. Large bore intravenous access to facilitate volume resuscitation.\n4. General anesthesia to allow uterine relaxation, enable uterine replacement, and provide analgesia while uterine tone is restored.\n5. Restart uterine stimulants after uterine reinversion.\n6. Acute resuscitation as appropriate including fluids, oxygen, ventilation, replacement of blood products, and maintenance of body temperature.\n\nClinical Points:\n1.  Uterine inversion is rare and often unrecognized especially after placental delivery.\n2.  Any uterine stimulants should be discontinued.\n3.  General anesthesia is often indicated for uterine relaxation to allow uterine reinversion.\n4.  Patient may be hemodynamically compromised secondary to massive hemorrhage.\n5.  Immediate steps to assure volume resuscitation need to be initiated early.\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: July 14, 2013\n\n", 
    "possiblePoints": 1200, 
    "preopMsg": "\n32 year old G8P5 with post-partum hemorrhage\n\nHistory of Present Illness\nThe patient is G8 P5 Ab 2. The patient just delivered baby, placenta, and uterus. She is bleeding profusely. The obstetrician requests deep inhalation anesthesia to facilitate reinsertion of the uterus.\n\nPast Medical History\nIllnesses: None\nSurgeries: previous cesarean section for fetal distress\nMedications: None\nHabits: Denies cigarettes, alcohol or other drugs.\nNo known drug allergies.\n\nFamily History\nNo family history of anesthetic problems.\n\nPhysical Exam\nWeight: 87 kg   HR: 110     BP: 105/65    RR: 20\nAirway: good neck extension, 3 fingerbreadth mouth opening, able to visualize uvula\nChest auscultation: clear\n\nLabs\nHematocrit: pending\n\nNPO Status\nLast ate 8 hours ago.\n\nPatient and Surgeon Requests\nAfter one push the obstetrician effects spontaneous vaginal delivery of a vigorous term baby followed by placenta and uterus. The patient is bleeding profusely. The obstetrician requests deep inhalation anesthesia to facilitate reinsertion of the uterus.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "PPH1", 
            "whatNextMsg": "The patient is bleeding profusely. Administer at least one liter of intravenous fluid quickly.", 
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
			"airwayStr": "nl",
            "baseAbpD": 75, 
            "baseAbpM": 90, 
            "baseAbpS": 115, 
            "baseBicarb": 22, 
            "baseHr": 98, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Extremely anxious and bleeding profusely.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "R1", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SED1", 
                    "comment": "You sedated the patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "PPH2", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "PPH1", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PPH1", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA1", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "PPH2", 
            "whatNextMsg": "The patient is bleeding profusely. Administer at least one liter of intravenous fluid immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 66, 
            "baseAbpS": 94, 
            "baseBicarb": 20, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 120, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "R2", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SED2", 
                    "comment": "You sedated the patient. You should have volume resuscitated. (-50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "PPH3", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "PPH2", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PPH2", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "PPH3", 
            "whatNextMsg": "The patient is bleeding profusely. Administer at least one liter of intravenous fluid immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 46, 
            "baseAbpS": 68, 
            "baseBicarb": 18, 
            "baseHr": 144, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 1, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Double-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 144, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "R3", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SED3", 
                    "comment": "You sedated the patient. You should have volume resuscitated. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PPH4", 
                    "comment": "You should have administered at least one liter of intravenous fluids much sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "PPH3", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PPH3", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "PPH4", 
            "whatNextMsg": "The patient is bleeding to death. Administer at least one liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 26, 
            "baseAbpS": 38, 
            "baseBicarb": 16, 
            "baseHr": 160, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 32, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Triple-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 1, 
            "spontRr": 30, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "R4", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SED4", 
                    "comment": "You sedated the patient. You should have volume resuscitated. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have administered at least one liter of intravenous fluids much, much sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted a laryngeal mask airway in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SED1", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Administer at least one liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 70, 
            "baseAbpM": 84, 
            "baseAbpS": 110, 
            "baseBicarb": 22, 
            "baseHr": 94, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated but still bleeding profusely.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED1", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You induced anesthesia before fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SED2", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SED1", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SED1", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA1", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SED2", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Administer at least one liter of intravenous fluid immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 66, 
            "baseAbpS": 90, 
            "baseBicarb": 20, 
            "baseHr": 116, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated with delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 120, 
            "spSignal": 2, 
            "spontRr": 10, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED2", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You induced anesthesia before fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SED3", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SED2", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SED2", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SED3", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Administer at least one liter of intravenous fluid immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 32, 
            "baseAbpM": 42, 
            "baseAbpS": 64, 
            "baseBicarb": 18, 
            "baseHr": 140, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated with double-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 140, 
            "spSignal": 2, 
            "spontRr": 14, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED3", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SED4", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SED3", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SED3", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SED4", 
            "whatNextMsg": "The patient is bleeding to death. Administer at least one liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 16, 
            "baseAbpM": 22, 
            "baseAbpS": 34, 
            "baseBicarb": 16, 
            "baseHr": 156, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 32, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated with triple-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 1, 
            "spontRr": 16, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED4", 
                    "comment": "You administered at least one liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted a laryngeal mask airway in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "R1", 
            "whatNextMsg": "You partially volume resuscitated, but the patient is still bleeding profusely. Administer at least one more liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 124, 
            "baseBicarb": 22, 
            "baseHr": 92, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 12, 
            "papM": 18, 
            "papS": 30, 
            "papW": 10, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Extremely anxious and bleeding profusely. Partially volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 92, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RR1", 
                    "comment": "You administered at least two liters of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RSED1", 
                    "comment": "You sedated the patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "R2", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "R1", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "R1", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA1", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "R2", 
            "whatNextMsg": "You partially volume resuscitated, but the patient is still bleeding profusely. Administer at least one more liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 62, 
            "baseAbpM": 74, 
            "baseAbpS": 102, 
            "baseBicarb": 20, 
            "baseHr": 114, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 30, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 28, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Delayed treatment for profuse post-partum hemorrhage. Partially volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 114, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RR2", 
                    "comment": "You administered at least two liters of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RSED2", 
                    "comment": "You sedated the patient. You should have volume resuscitated. (-50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "R3", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "R2", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "R2", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "R3", 
            "whatNextMsg": "You partially volume resuscitated, but the patient is still bleeding profusely. Administer at least one more liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 46, 
            "baseAbpS": 72, 
            "baseBicarb": 18, 
            "baseHr": 138, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 26, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Double-delayed treatment for profuse post-partum hemorrhage. Partially volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 138, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RR3", 
                    "comment": "You administered at least two liters of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RSED3", 
                    "comment": "You sedated the patient. You should have volume resuscitated. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "R4", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids much sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "R3", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "R3", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "R4", 
            "whatNextMsg": "You partially volume resuscitated, but the patient is still bleeding profusely. Administer at least one more liter of intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 26, 
            "baseAbpS": 38, 
            "baseBicarb": 16, 
            "baseHr": 154, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 22, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Triple-delayed treatment for profuse post-partum hemorrhage. Partially volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 154, 
            "spSignal": 1, 
            "spontRr": 30, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RR4", 
                    "comment": "You administered at least two liters of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RSED4", 
                    "comment": "You sedated the patient. You should have volume resuscitated. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids much, much sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted a laryngeal mask airway in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RSED1", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Administer additional intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 86, 
            "baseAbpS": 114, 
            "baseBicarb": 22, 
            "baseHr": 88, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 12, 
            "papM": 18, 
            "papS": 30, 
            "papW": 10, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid administered but still bleeding profusely.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 88, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RRSED1", 
                    "comment": "You administered at least one additional liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RSED2", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RSED1", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RSED1", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA1", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RSED2", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Administer additional intravenous fluid immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 20, 
            "baseHr": 110, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 26, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 28, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid administered with delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 110, 
            "spSignal": 2, 
            "spontRr": 10, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RRSED2", 
                    "comment": "You administered at least one additional liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before adequately fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RSED3", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RSED2", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RSED2", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RSED3", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Administer additional intravenous fluid immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 46, 
            "baseAbpS": 68, 
            "baseBicarb": 18, 
            "baseHr": 134, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 26, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid administered with double-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 134, 
            "spSignal": 2, 
            "spontRr": 14, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RRSED3", 
                    "comment": "You administered at least one additional liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before adequately fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RSED4", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RSED3", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RSED3", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RSED4", 
            "whatNextMsg": "The patient is bleeding to death. Administer additional intravenous fluid quickly.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 24, 
            "baseAbpS": 38, 
            "baseBicarb": 16, 
            "baseHr": 150, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 22, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is letharigc.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid administered with triple-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 150, 
            "spSignal": 1, 
            "spontRr": 16, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RRSED4", 
                    "comment": "You administered at least one additional liter of intravenous fluids appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia before adequately fluid resuscitating the patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have administered at least one additional liter of intravenous fluids sooner. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted a laryngeal mask airway in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RR1", 
            "whatNextMsg": "You volume resuscitated, but the patient is still bleeding profusely. Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 94, 
            "baseAbpS": 128, 
            "baseBicarb": 22, 
            "baseHr": 86, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 30, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 12, 
            "papM": 18, 
            "papS": 32, 
            "papW": 10, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Extremely anxious and bleeding profusely. Volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 86, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP1", 
                    "comment": "You induced anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RR2", 
                    "comment": "You should have induced anesthesia sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RR1", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RR1", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA1", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RR2", 
            "whatNextMsg": "You volume resuscitated, but the patient is still bleeding profusely. Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 62, 
            "baseAbpM": 74, 
            "baseAbpS": 106, 
            "baseBicarb": 20, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 26, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is extremely agitated.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 30, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Delayed treatment for profuse post-partum hemorrhage. Volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 108, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP2", 
                    "comment": "You induced anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RR3", 
                    "comment": "You should have induced anesthesia sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RR2", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RR2", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RR3", 
            "whatNextMsg": "You volume resuscitated, but the patient is still bleeding profusely. Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 50, 
            "baseAbpS": 76, 
            "baseBicarb": 18, 
            "baseHr": 132, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 22, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is agitated.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Double-delayed treatment for profuse post-partum hemorrhage. Volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 132, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You induced anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RR4", 
                    "comment": "You should have induced anesthesia sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RR3", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RR3", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RR4", 
            "whatNextMsg": "You volume resuscitated, but the patient is still bleeding profusely. Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 20, 
            "baseAbpM": 28, 
            "baseAbpS": 42, 
            "baseBicarb": 16, 
            "baseHr": 148, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 18, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 10, 
            "papW": 4, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Triple-delayed treatment for profuse post-partum hemorrhage. Volume resuscitated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 148, 
            "spSignal": 1, 
            "spontRr": 30, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have induced anesthesia sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted a laryngeal mask airway in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RRSED1", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely. Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 79, 
            "baseAbpM": 90, 
            "baseAbpS": 124, 
            "baseBicarb": 22, 
            "baseHr": 84, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 30, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 30, 
            "papW": 10, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid resuscitated but still bleeding profusely.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 84, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP1", 
                    "comment": "You induced anesthesia after fluid resuscitating the patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RRSED2", 
                    "comment": "You should have performed rapid sequence induction sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RRSED1", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RRSED1", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA1", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RRSED2", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely.  Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 74, 
            "baseAbpS": 102, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 26, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 8, 
            "papM": 14, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid resuscitated with delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 106, 
            "spSignal": 2, 
            "spontRr": 10, 
            "spontTv": 210, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP2", 
                    "comment": "You induced anesthesia after fluid resuscitating the patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RRSED3", 
                    "comment": "You should have performed rapid sequence induction sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RRSED2", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RRSED2", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RRSED3", 
            "whatNextMsg": "The patient is sedated and still bleeding profusely.  Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 34, 
            "baseAbpM": 48, 
            "baseAbpS": 72, 
            "baseBicarb": 18, 
            "baseHr": 130, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 22, 
            "heartSoundsMsg": "Rapid rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 10, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid resuscitated with double-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with very slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 134, 
            "spSignal": 2, 
            "spontRr": 14, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You induced anesthesia after fluid resuscitating the patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "RRSED4", 
                    "comment": "You should have performed rapid sequence induction sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "RRSED3", 
                    "comment": "You tried to insert a laryngeal mask airway in a lightly anesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "RRSED3", 
                    "comment": "You tried to insert the endotracheal tube in a lightly anesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "RRSED4", 
            "whatNextMsg": "The patient is bleeding to death.  Perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 24, 
            "baseAbpS": 38, 
            "baseBicarb": 16, 
            "baseHr": 146, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 18, 
            "heartSoundsMsg": "The heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is lethargic.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 8, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and fluid resuscitated with triple-delayed treatment for profuse post-partum hemorrhage.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 146, 
            "spSignal": 1, 
            "spontRr": 16, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You induced anesthesia after fluid resuscitating the patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have performed rapid sequence induction sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted a laryngeal mask airway in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You inserted the endotracheal tube in this lethargic patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.9
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEP1", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 66, 
            "baseAbpM": 80, 
            "baseAbpS": 104, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 30, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 14, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 88, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEC1", 
                    "comment": "You should place an endotracheal tube due to the extensive resuscitation. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEC1", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC1", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP2", 
                    "comment": "You should have secured the airway sooner. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP2", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 58, 
            "baseAbpS": 84, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 26, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 10, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after delayed fluid resuscitation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 108, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEC3", 
                    "comment": "You should place an endotracheal tube due to the extensive resuscitation. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEC3", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC3", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP2", 
                    "comment": "You administered additional fluid appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You should have secured the airway sooner. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP3", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 40, 
            "baseAbpS": 58, 
            "baseBicarb": 24, 
            "baseHr": 134, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 22, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and thready.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after double-delayed fluid resuscitation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 134, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEC3", 
                    "comment": "You should place an endotracheal tube due to the extensive resuscitation. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEC3", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC3", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP2", 
                    "comment": "You administered additional fluid appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ASLEEP4", 
                    "comment": "You should have secured the airway sooner. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP4", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 12, 
            "baseAbpM": 16, 
            "baseAbpS": 28, 
            "baseBicarb": 24, 
            "baseHr": 150, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 18, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 0, 
            "papM": 2, 
            "papS": 4, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized after triple-delayed fluid resuscitation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 150, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEC4", 
                    "comment": "You should place an endotracheal tube due to the extensive resuscitation. (-100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP3", 
                    "comment": "You administered additional fluid appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have secured the airway sooner. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEC1", 
            "whatNextMsg": "Deepen the level of anesthesia to relax the uterus.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 86, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 94, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 30, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 14, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEP1", 
                    "comment": "You deepened the level of inhalational anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEC2", 
                    "comment": "You waited too long to deepen the inhalation agent. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEC2", 
            "whatNextMsg": "Administer additional intravenous fluids. Deepen the level of anesthesia to relax the uterus.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 26, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 10, 
            "papW": 4, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 114, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEP2", 
                    "comment": "You deepened the level of inhalational anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEC1", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "SEC2", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEC3", 
            "whatNextMsg": "Administer additional intravenous fluids. Deepen the level of anesthesia to relax the uterus.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 48, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 140, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 22, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 140, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEP3", 
                    "comment": "You deepened the level of inhalational anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEC2", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2699
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "SEC4", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEC4", 
            "whatNextMsg": "Administer additional intravenous fluids. Deepen the level of anesthesia to relax the uterus.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 20, 
            "baseAbpM": 26, 
            "baseAbpS": 38, 
            "baseBicarb": 24, 
            "baseHr": 156, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 18, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 0, 
            "papM": 2, 
            "papS": 4, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 156, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEP4", 
                    "comment": "You deepened the level of inhalational anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEC3", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2399
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEP1", 
            "whatNextMsg": "Resuscitated and anesthetized. Deepen the inhalation agent to 2 MAC.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 82, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.4, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 30, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Resuscitated and one MAC .", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER1", 
                    "comment": "You deepened the level of inhalational anesthesia. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.9
                        }
                    ], 
                    "points": 300
                }
            ]
        }, 
        {
            "name": "DEEP2", 
            "whatNextMsg": "Maintain at least 2 MAC inhalation anesthetic. Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 88, 
            "baseBicarb": 26, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 10, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "One MAC  but needs additional fluid.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 118, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER2", 
                    "comment": "You deepened the level of inhalational anesthesia. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.9
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "DEEP1", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DEEP3", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEP3", 
            "whatNextMsg": "Maintain at least 2 MAC inhalation anesthetic. Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 32, 
            "baseAbpM": 44, 
            "baseAbpS": 60, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 22, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "One MAC but needs additional fluid.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 144, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER3", 
                    "comment": "You deepened the level of inhalational anesthesia. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.9
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "DEEP2", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2699
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DEEP4", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEP4", 
            "whatNextMsg": "Maintain at least 2 MAC inhalation anesthetic. Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 14, 
            "baseAbpM": 18, 
            "baseAbpS": 30, 
            "baseBicarb": 18, 
            "baseHr": 158, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 0, 
            "papM": 2, 
            "papS": 4, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "One MAC but needs additional fluid.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 158, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER4", 
                    "comment": "You deepened the level of inhalational anesthesia. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.9
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "DEEP3", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2399
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEPER1", 
            "whatNextMsg": "Resuscitated and anesthetized. End of simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 72, 
            "baseAbpS": 98, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.4, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 8, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 30, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Resuscitated and anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 98, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "DEEPER2", 
            "whatNextMsg": "Maintain at least 2 MAC inhalation anesthetic. Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 52, 
            "baseAbpS": 78, 
            "baseBicarb": 26, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 10, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized but needs additional fluid.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 118, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER1", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DEEPER3", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEPER3", 
            "whatNextMsg": "Maintain at least 2 MAC inhalation anesthetic. Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 22, 
            "baseAbpM": 34, 
            "baseAbpS": 50, 
            "baseBicarb": 24, 
            "baseHr": 144, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 22, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized but needs additional fluid.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 144, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER2", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2699
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DEEPER4", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEPER4", 
            "whatNextMsg": "Maintain at least 2 MAC inhalation anesthetic. Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 14, 
            "baseAbpM": 18, 
            "baseAbpS": 28, 
            "baseBicarb": 18, 
            "baseHr": 158, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.6, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 0, 
            "papM": 2, 
            "papS": 4, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized but needs additional fluid.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 158, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPER3", 
                    "comment": "You administered additional intravenous fluids. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2399
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You waited too long to deepen the inhalation agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA1", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 90, 
            "baseAbpS": 118, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 28, 
            "papW": 10, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 102, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED1", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "SED1", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "AWAKEPARA2", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }
            ]
        }, 
        {
            "name": "AWAKEPARA2", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 72, 
            "baseAbpS": 98, 
            "baseBicarb": 24, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 36, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 8, 
            "papM": 14, 
            "papS": 26, 
            "papW": 8, 
            "pulseMsg": "The pulse is rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 124, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED2", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "SED2", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "AWAKEPARA3", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }
            ]
        }, 
        {
            "name": "AWAKEPARA3", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 48, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 148, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 34, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 148, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED3", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "SED3", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "AWAKEPARA4", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }
            ]
        }, 
        {
            "name": "AWAKEPARA4", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 26, 
            "baseAbpS": 42, 
            "baseBicarb": 24, 
            "baseHr": 162, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 0.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 32, 
            "heartSoundsMsg": "Rapid rate, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 2, 
            "papM": 4, 
            "papS": 6, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with no capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 98, 
            "sat40": 99, 
            "sat100": 100, 
            "spRate": 162, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "RSED4", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "SED4", 
                    "comment": "You sedated the patient. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have administered at least one liter of intravenous fluids sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 32, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 22, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spRate": 0, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}