import os
import re

def debug_single_file(filename):
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    
    print(f"\n--- Processing file: {filename} ---")
    with open(os.path.join(js_dir, filename), 'r') as f:
        content = f.read()

    # Print the first 1000 characters of the file to understand its structure
    print(content[:2000])

    # Updated regex pattern to match `CaseData` object and correctly capture groups
    pattern = r'CaseData\[(\d+)\]\s*=\s*({[\s\S]*?})\s*(?:;|\s*\n|$)'
    match = re.search(pattern, content)
    
    if match:
        case_id = match.group(1)  # Group 1: Case ID
        case_data = match.group(2)  # Group 2: Case Data
        print(f"Matched case data for ID {case_id}:")
        print(case_data[:500])  # Print a part of the matched data
    else:
        print(f"No matching CaseData object found in: {filename}")

if __name__ == "__main__":
    # Replace 'Anesth6Case1.js' with the file you want to test
    debug_single_file('Anesth6Case1.js')
