<?php
error_log("Session termination API called");
require_once '../includes/include_all.inc.php';

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

error_log("Session status before clearing: " . (isset($_SESSION['front_user_id']) ? 'logged in' : 'not logged in'));

// Clear session variables
$_SESSION = [];

// If cookies are being used, delete them
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
}

// Destroy the session
session_destroy();

error_log("Session terminated");

// Send JSON response
header('Content-Type: application/json');
echo json_encode(['success' => true]);
exit;