<?php
// recentcases.php
// Ensure this file is not accessed directly
if (!defined('INCLUDE_CHECK')) {
    die('You cannot access this file directly.');
}

// Check if we have access to the database connection
if (!isset($pdo) || !($pdo instanceof PDO)) {
    echo "<p>Database connection not available.</p>";
    return;
}

// Check if we have access to session variables
if (!isset($_SESSION['user_type']) || !isset($_SESSION['user_group'])) {
    echo "<p>Session variables not available.</p>";
    return;
}

// Function to fetch recent cases
function fetchRecentCases($pdo, $userType, $userGroup, $limit = 5) {
    $query = "SELECT wp_groupusers_data.id as case_id, wp_groupusers_data.*, wp_users.user_email
              FROM wp_groupusers_data
              INNER JOIN wp_users ON wp_groupusers_data.user_id = wp_users.id";
    
    if ($userType == 'admin') {
        $query .= " WHERE wp_users.user_group = :userGroup";
    }
    // For super admin, we don't add any WHERE clause to get all cases
    
    $query .= " ORDER BY wp_groupusers_data.datetime DESC LIMIT :limit";
    
    $stmt = $pdo->prepare($query);
    if ($userType == 'admin') {
        $stmt->bindParam(':userGroup', $userGroup, PDO::PARAM_STR);
    }
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Fetch recent cases
$recentCases = fetchRecentCases($pdo, $_SESSION['user_type'], $_SESSION['user_group']);

// Display the table
if (!empty($recentCases)):
?>
    <h2 class="overview-title">Recent Cases</h2>
    <table class="home-table recent-cases-table">
        <tr>
            <th>Date</th>
            <th>User</th>
            <th>Case</th>
			<th style="text-align: center">Case ID</th>
            <th style="text-align: center">Grade</th>
            <th style="text-align: center">Score</th>
            <th style="text-align: center">View Case</th>
        </tr>
        <?php foreach ($recentCases as $case): ?>
        <tr>
            <td><?= date('Y-m-d H:i', strtotime($case['datetime'])) ?></td>
            <td><?= htmlspecialchars($case['user_email']) ?></td>
            <td><?= htmlspecialchars(substr($case['user_data'], 0, 50)) ?></td>
			<td style="text-align: center"><?= htmlspecialchars($case['case_id']) ?></td>
            <td style="text-align: center"><?= htmlspecialchars($case['case_grade'] ?? ''); ?></td>
            <td style="text-align: center"><?= htmlspecialchars($case['case_score'] ?? ''); ?></td>
            <td style="text-align: center"><a href="casesdetail.php?id=<?= htmlspecialchars($case['id']) ?>&userid=<?= htmlspecialchars($case['user_id']) ?>">View Case</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
<?php else: ?>
    <p>No recent cases available.</p>
<?php endif; ?>