/* Scripts for only pages */

	// Change profile name
	document.getElementById('changeProfileName').addEventListener('click', function() {
		document.getElementById('changeNameForm').style.display = 'block';
		this.style.display = 'none'; // Hide the change button while editing
	});

	document.getElementById('cancelNameButton').addEventListener('click', function() {
		document.getElementById('changeNameForm').style.display = 'none';
		document.getElementById('changeProfileName').style.display = 'inline-block';
	});
	

	// Call on page load
	document.addEventListener('DOMContentLoaded', function() {
		updateMenuButtonVisibility();
	});

	// Section tracking and button visibility system
	let currentActiveSection = null;

	function updateMenuButtonVisibility() {
		const viewMyCasesBtn = document.querySelector('.view-my-cases');
		const viewMySettingsBtn = document.querySelector('.view-my-settings');
		const changeMySettingsBtn = document.querySelector('.change-my-settings');
		
		// Check sessionStorage for active sections
		const showCases = sessionStorage.getItem('showCases');
		const showDetails = sessionStorage.getItem('showDetails');
		const showChangeSettings = sessionStorage.getItem('showChangeSettings');
		
		// Determine current section
		if (showCases) currentActiveSection = 'cases';
		else if (showDetails) currentActiveSection = 'details';
		else if (showChangeSettings) currentActiveSection = 'change';
		else currentActiveSection = null;
		
		// Hide/show buttons based on current section
		if (viewMyCasesBtn) {
			viewMyCasesBtn.style.display = currentActiveSection === 'cases' ? 'none' : 'flex';
			
			// Hide/show hr element when cases button is hidden/shown
			const hrElement = viewMyCasesBtn.nextElementSibling || viewMyCasesBtn.previousElementSibling;
			if (hrElement && hrElement.tagName === 'HR') {
				hrElement.style.display = currentActiveSection === 'cases' ? 'none' : 'block';
			}
		}
		
		if (viewMySettingsBtn) {
			viewMySettingsBtn.style.display = currentActiveSection === 'details' ? 'none' : 'flex';
		}
		
		if (changeMySettingsBtn) {
			changeMySettingsBtn.style.display = currentActiveSection === 'change' ? 'none' : 'flex';
		}
	}

	function handleSettingsNavigation(event, section) {
		sessionStorage.setItem('navigatingToSettings', 'true');
		
		// If we're already on settings page, handle section switching
		if (window.location.pathname.includes('/settings')) {
			const targetSelector = {
				'cases': '.view-cases',
				'details': '.view-settings', 
				'change': '.change-settings'
			}[section];
			
			if (targetSelector && document.querySelector(targetSelector)) {
				event.preventDefault();
				event.stopPropagation();
				
				// Clear all section flags
				sessionStorage.removeItem('showCases');
				sessionStorage.removeItem('showDetails');
				sessionStorage.removeItem('showChangeSettings');
				
				// Set the appropriate flag
				if (section === 'cases') sessionStorage.setItem('showCases', 'true');
				if (section === 'details') sessionStorage.setItem('showDetails', 'true');
				if (section === 'change') sessionStorage.setItem('showChangeSettings', 'true');
				
				// Click the target element
				document.querySelector(targetSelector).click();
				
				// Update button visibility after a short delay
				setTimeout(updateMenuButtonVisibility, 150);
				return true;
			}
		}
		
		return false;
	}

	// Monitor for changes in sessionStorage (for when sections are loaded)
	function monitorSessionStorage() {
		const originalSetItem = sessionStorage.setItem;
		sessionStorage.setItem = function(key, value) {
			originalSetItem.apply(this, arguments);
			if (key === 'showCases' || key === 'showDetails' || key === 'showChangeSettings') {
				setTimeout(updateMenuButtonVisibility, 100);
			}
		};
		
		const originalRemoveItem = sessionStorage.removeItem;
		sessionStorage.removeItem = function(key) {
			originalRemoveItem.apply(this, arguments);
			if (key === 'showCases' || key === 'showDetails' || key === 'showChangeSettings') {
				setTimeout(updateMenuButtonVisibility, 100);
			}
		};
	}

	// Watch for DOM changes that might indicate section switches
	function observePageChanges() {
		const observer = new MutationObserver(function(mutations) {
			let shouldUpdate = false;
			
			mutations.forEach(function(mutation) {
				// Check for class changes on elements that might indicate section changes
				if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
					const target = mutation.target;
					if (target.classList && (
						target.classList.contains('active') ||
						target.classList.contains('selected') ||
						target.classList.contains('current') ||
						target.classList.contains('show')
					)) {
						shouldUpdate = true;
					}
				}
				
				// Check for added nodes that might be sections
				if (mutation.addedNodes) {
					mutation.addedNodes.forEach(function(node) {
						if (node.nodeType === 1 && node.classList && (
							node.classList.contains('section') ||
							node.classList.contains('tab-content') ||
							node.classList.contains('settings-content')
						)) {
							shouldUpdate = true;
						}
					});
				}
			});
			
			if (shouldUpdate) {
				setTimeout(updateMenuButtonVisibility, 200);
			}
		});
		
		// Observe the entire document for changes
		observer.observe(document.body, {
			childList: true,
			subtree: true,
			attributes: true,
			attributeFilter: ['class', 'style']
		});
	}

	// Initialize everything when DOM is ready
	document.addEventListener('DOMContentLoaded', function() {
		// Set up monitoring
		monitorSessionStorage();
		observePageChanges();
		
		// Initial visibility check
		setTimeout(updateMenuButtonVisibility, 100);
		
		// Check again after a longer delay in case sections load asynchronously
		setTimeout(updateMenuButtonVisibility, 500);
		setTimeout(updateMenuButtonVisibility, 1000);
	});

	// Also check when the page becomes visible (in case of tab switching)
	document.addEventListener('visibilitychange', function() {
		if (!document.hidden) {
			setTimeout(updateMenuButtonVisibility, 100);
		}
	});

	// Check when window gains focus
	window.addEventListener('focus', function() {
		setTimeout(updateMenuButtonVisibility, 100);
	});

	// Periodic check as fallback (every 2 seconds)
	setInterval(updateMenuButtonVisibility, 2000);





/* scripts_pages.js */
// ******************************************* Anesthcode ***************************************************

document.observe("dom:loaded", function() {
    $("divErrorScreen").hide();
    $("divFullScreen").show();
});

document.addEventListener('touchmove', function(e) {
    e.preventDefault();
}, { passive: false });

function onBackPressed() {
    onFinish();
    if (typeof Android !== 'undefined' && Android && Android.onFinish) {
        Android.onFinish();
    }
}

function onFinish() {
    clearTimeout(MyTimeout);
}

// ******************************************* End Anesthcode ***************************************************

	// debugging cookies
	console.log('Settings Page Loaded');
	// console.log('Saved Sidebar State:', getCookie('sidebar'));
	// console.log('Saved Theme State:', getCookie('theme'));
	// console.log('Saved Sound State:', getCookie('sound'));
	// console.log('Saved Layout State:', savedLayout);