(function() {
    const warning = document.createElement('div');
    warning.id = 'screen-size-warning';
    warning.style.cssText = `
        width: 100vw;
        height: 100vh;
        position: fixed;
        background: #000;
        z-index: 9999;
        display: flex;
        align-items: center;
        justify-content: center;
        top: 0;
        left: 0;
    `;
    const message = document.createElement('div');
    message.style.cssText = `
        background: white;
        padding: 20px;
        border-radius: 8px;
        max-width: ${window.innerHeight < 500 ? 'min(400px, 70%)' : '400px'};
        text-align: center;
        color: black;
    `;

    const fullscreenButton = `
        <button onclick="document.documentElement.requestFullscreen().catch(err => console.log('Fullscreen error:', err))" 
                style="background: #007bff; color: white; border: none; padding: 10px 20px; 
                       border-radius: 5px; cursor: pointer;">
            Go Fullscreen
        </button>`;

    message.innerHTML = 
        "<img src='" + appUrl + "/images/logo/logo-new-dark.png' style='filter: invert(100%); width: 55%; max-width: 200px;'>" +
        "<h2 style='font-size: 20px; margin-bottom: 10px;'>Larger Screen Required</h2>" +
        "<p style='font-size: 16px;'>For the best experience, please view this app in full screen or on a desktop or laptop computer.</p>" +
        fullscreenButton;

    warning.appendChild(message);
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', addWarning);
    } else {
        addWarning();
    }

    function addWarning() {
        document.body.insertBefore(warning, document.body.firstChild);
        checkScreenSize();
    }

	function checkScreenSize() {
		// Show or hide the warning based on window height and width
		warning.style.display = (window.innerHeight < 500 || window.innerWidth < 1024) ? 'flex' : 'none';

		// Adjust max width of message based on height
		message.style.maxWidth = window.innerHeight < 500 ? 'min(400px, 70%)' : '400px';

		// Show or hide the fullscreen button based on screen width
		const fullscreenButtonElement = message.querySelector('button');
		if (fullscreenButtonElement) {
			fullscreenButtonElement.style.display = (screen.width > 1024) ? 'block' : 'none';
		}
	}


    window.addEventListener('resize', checkScreenSize);
})();
 