CaseData[51] = {
    "title": "Case 110 - 24 year old for diagnostic laparoscopy", 
    "badDrugs": [], 
    "coMin": 1.2, 
    "debriefMsg": "based on malignant hyperthermia case 8", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 2400, 
    "helpFlag": false, 
    "imageSet": 3, 
    "initialSat": 97, 
    "leanBodyMass": 70, 
    "learningObj": "", 
    "possiblePoints": 1600, 
    "preopMsg": "\n24 year old female for diagnostic laparoscopy\n\nThe patient has had chronic pelvic pain.\n\nPast Medical History\nIllnesses - none\nSurgeries - none\nMeds - none\nAllergies - no known drug allergies\nHabits - denies cigarettes, alcohol or other drugs\n\nFamily History\nNo known anesthetic problems\n\nPhysical Exam\nWeight: 66 Kg\nHR 98,  BP 124/80,  RR 18 \nAirway - normal\nLungs - clear\nHeart - normal\n\nLabs\nHematocrit 38\n\nNPO Status\nLast ate 8 hours ago.\n\nPatient and Surgeon Requests\nThe patient and surgeon request general anesthesia.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen by mask and a sedative agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 23.8, 
            "baseHr": 92, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You administered an intravenous sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered an inhalational anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV1", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV2", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 4, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You continued to administer inhalation agent.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWIV", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2IV", 
            "whatNextMsg": "Inform the surgeon when the patient is ready.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDINH", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 270, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered intravenous anesthetic agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient.", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWINH", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 250, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2INH", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2INH", 
            "whatNextMsg": "Inform the surgeon when the patient is ready.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 230, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX1", 
                    "comment": "You administered both inhalation agent and succinylcholine.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }, 
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "MHINHORSUX1", 
                    "comment": "You administered inhalation agent but not succinylcholine.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 320
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPIV", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX1", 
                    "comment": "You administered both inhalation agent and succinylcholine.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }, 
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.05
                        }, 
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "MHINHORSUX1", 
                    "comment": "You administered inhalation agent but not succinylcholine.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 260
                        }, 
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.05
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "MHINHORSUX1", 
                    "comment": "You administered succinylcholine but not inhalation agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 250
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.06
                        }, 
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "MHNONTRIGGER", 
                    "comment": "You did not administer inhalation agent or succinylcholine. (+1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 480
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.06
                        }
                    ], 
                    "points": 1000
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX1", 
            "whatNextMsg": "Recheck the blood pressure before treating tachycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 124, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 116, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 1424, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX2", 
                    "comment": "The simulation forced the patient to develop worsening MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX2", 
            "whatNextMsg": "Increase respiratory rate and tidal volume.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 134, 
            "baseBicarb": 16, 
            "baseHr": 116, 
            "basePot": 4.9, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 112, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic and hypercapnic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 140, 
            "sat20": 84, 
            "sat40": 88, 
            "sat100": 92, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 270, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX3", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX3", 
            "whatNextMsg": "Increase ventilation more.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 108, 
            "baseAbpS": 148, 
            "baseBicarb": 12, 
            "baseHr": 124, 
            "basePot": 5.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 102, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypercapnia continues.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 76, 
            "sat40": 82, 
            "sat100": 88, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.2, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX4", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX4", 
            "whatNextMsg": "Analyze arterial blood gas.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 104, 
            "baseAbpS": 154, 
            "baseBicarb": 12, 
            "baseHr": 132, 
            "basePot": 5.4, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 94, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "High end-tidal CO2.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 76, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.8, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX5", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX5", 
            "whatNextMsg": "Check the temperature.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 92, 
            "baseAbpM": 112, 
            "baseAbpS": 162, 
            "baseBicarb": 10, 
            "baseHr": 136, 
            "basePot": 5.8, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 88, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Marked respiratory and metabolic acidosis.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 70, 
            "sat40": 76, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 38.7, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX6", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX6", 
            "whatNextMsg": "Administer dantrolene, cool the patient, discontinue the inhalation agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 88, 
            "baseAbpM": 108, 
            "baseAbpS": 156, 
            "baseBicarb": 10, 
            "baseHr": 138, 
            "basePot": 6.4, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 82, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The temperature is markedly elevated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 70, 
            "sat40": 76, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 270, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 39.9, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX7", 
                    "comment": "The simulation forced the patient to develop fulminant malignant hyperthermia.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX7", 
            "whatNextMsg": "Call for help. Administer dantrolene, cool the patient, discontinue the inhalation agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 98, 
            "baseAbpS": 158, 
            "baseBicarb": 10, 
            "baseHr": 138, 
            "basePot": 6.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 78, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Fulminant malignant hyperthermia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 70, 
            "sat40": 76, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 40.3, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX8", 
                    "comment": "You administered excessive dantrolene. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Dantrolene", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "MHINHANDSUX8", 
                    "comment": "You administered dantrolene appropriately. (+500 points)", 
                    "conditions": [
                        {
                            "drug": "Dantrolene", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 75
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "MHINHANDSUX7", 
                    "comment": "You administered an inadequate dose of dantrolene. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Dantrolene", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 76
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH", 
                    "comment": "You should have administered dantrolene faster. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX8", 
            "whatNextMsg": "Cool the patient, discontinue the inhalation agent, monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 90, 
            "baseAbpS": 132, 
            "baseBicarb": 14, 
            "baseHr": 112, 
            "basePot": 6.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 74, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Dantrolene administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 74, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 170, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 39.9, 
            "trans": [
                {
                    "nextState": "MHINHANDSUX9", 
                    "comment": "You discontinued the inhalation agent and cooled the patient appropriately. (+500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }, 
                        {
                            "type": "icedIv", 
                            "value": true
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "MHINHANDSUX9", 
                    "comment": "You cooled the patient with ice packs. (+500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }, 
                        {
                            "type": "icePack", 
                            "value": true
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "MHINHANDSUX9", 
                    "comment": "You cooled the patient with iced lavage. (+500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }, 
                        {
                            "type": "icedLavage", 
                            "value": true
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "VTACH", 
                    "comment": "You should have discontinued the inhalation agent and cooled the patient sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHANDSUX9", 
            "whatNextMsg": "Monitor closely for several hours. You successfully completed this case simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 124, 
            "baseBicarb": 18, 
            "baseHr": 106, 
            "basePot": 5.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 82, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Patient stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 80, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 190, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 39.9
        }, 
        {
            "name": "MHINHORSUX1", 
            "whatNextMsg": "Recheck the blood pressure before treating tachycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 124, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 116, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 1424, 
            "sat20": 86, 
            "sat40": 93, 
            "sat100": 95, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "MHINHORSUX2", 
                    "comment": "The simulation forced the patient to develop worsening MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 50
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX2", 
            "whatNextMsg": "Increase respiratory rate and tidal volume.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 88, 
            "baseAbpS": 128, 
            "baseBicarb": 20, 
            "baseHr": 110, 
            "basePot": 4.9, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 112, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic and hypercapnic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 140, 
            "sat20": 84, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 270, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "MHINHORSUX3", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 50
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX3", 
            "whatNextMsg": "Increase ventilation more.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 92, 
            "baseAbpS": 130, 
            "baseBicarb": 18, 
            "baseHr": 112, 
            "basePot": 5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 102, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypercapnia continues.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 76, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37, 
            "trans": [
                {
                    "nextState": "MHINHORSUX4", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 50
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX4", 
            "whatNextMsg": "Analyze arterial blood gas.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 76, 
            "baseAbpM": 94, 
            "baseAbpS": 136, 
            "baseBicarb": 18, 
            "baseHr": 116, 
            "basePot": 5.1, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 94, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "High end-tidal CO2.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 78, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.2, 
            "trans": [
                {
                    "nextState": "MHINHORSUX5", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 50
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX5", 
            "whatNextMsg": "Check the temperature.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 138, 
            "baseBicarb": 16, 
            "baseHr": 120, 
            "basePot": 5.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 88, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Marked respiratory and metabolic acidosis.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 70, 
            "sat40": 78, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.4, 
            "trans": [
                {
                    "nextState": "MHINHORSUX6", 
                    "comment": "The simulation forced the patient to develop even worse MH reaction.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 50
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX6", 
            "whatNextMsg": "Administer dantrolene, cool the patient, check that the inhalation agent is off.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 82, 
            "baseAbpM": 108, 
            "baseAbpS": 142, 
            "baseBicarb": 16, 
            "baseHr": 122, 
            "basePot": 5.3, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 82, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The temperature is markedly elevated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 70, 
            "sat40": 78, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.8, 
            "trans": [
                {
                    "nextState": "MHINHORSUX7", 
                    "comment": "The simulation forced the patient to develop fulminant malignant hyperthermia.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 50
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX7", 
            "whatNextMsg": "Call for help. Administer dantrolene, cool the patient, discontinue the inhalation agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 82, 
            "baseAbpM": 98, 
            "baseAbpS": 140, 
            "baseBicarb": 16, 
            "baseHr": 126, 
            "basePot": 5.4, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 78, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe malignant hyperthermia reaction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 70, 
            "sat40": 78, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 170, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 38.2, 
            "trans": [
                {
                    "nextState": "MHINHORSUX8", 
                    "comment": "You administered excessive dantrolene. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Dantrolene", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "MHINHORSUX8", 
                    "comment": "You administered dantrolene appropriately. (+500 points)", 
                    "conditions": [
                        {
                            "drug": "Dantrolene", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 75
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "MHINHORSUX7", 
                    "comment": "You administered an inadequate dose of dantrolene. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Dantrolene", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 76
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "VTACH", 
                    "comment": "You should have administered dantrolene faster. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX8", 
            "whatNextMsg": "Cool the patient, check that the inhalation agent is off, monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 90, 
            "baseAbpS": 132, 
            "baseBicarb": 18, 
            "baseHr": 118, 
            "basePot": 5.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 74, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Dantrolene administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is hot and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 72, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 2, 
            "spontRr": 8, 
            "spontTv": 170, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.6, 
            "trans": [
                {
                    "nextState": "MHINHORSUX9", 
                    "comment": "You checked the inhalation agent and cooled the patient appropriately. (+500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }, 
                        {
                            "type": "icedIv", 
                            "value": true
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "MHINHORSUX9", 
                    "comment": "You checked the inhalation agent and cooled the patient appropriately. (+500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }, 
                        {
                            "type": "icePack", 
                            "value": true
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "MHINHORSUX9", 
                    "comment": "You checked the inhalation agent and cooled the patient appropriately. (+500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }, 
                        {
                            "type": "icedLavage", 
                            "value": true
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "VTACH", 
                    "comment": "You should have cooled the patient and checked the inhalation agent sooner. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "MHINHORSUX9", 
            "whatNextMsg": "Monitor closely for several hours. You successfully completed this case simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 124, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 82, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Patient stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 146, 
            "sat20": 86, 
            "sat40": 93, 
            "sat100": 95, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 190, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 37.4
        }, 
        {
            "name": "MHNONTRIGGER", 
            "whatNextMsg": "Simulation completed. You avoided MH by not using succinylcholine or potent inhalation agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia. MH avoided.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "VTACH", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Pulseless ventricular tachycardia.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 76, 
            "sat40": 82, 
            "sat100": 86, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "You need to defibrillate sooner. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 90, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "whatNextMsg": "Now perform laryngoscopy and place the endotracheal intubation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Asleep and paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 18
                        }
                    ], 
                    "points": -5000
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 95, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 210, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATDEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATDEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ] 
}