"use strict";

function ConvertDrugKeyToIndex(tmpKeyStr) {
    for (var iDrug = 1; iDrug < DrugInfo.Drugs.length; iDrug++) {
        if (DrugInfo.Drugs[iDrug].nameStr == tmpKeyStr) {
            break
        }
    }
    if (iDrug < DrugInfo.Drugs.length) {
        return (iDrug)
    } else {
        alert(tmpKeyStr + " is not a Drugname.");
        throw tmpKeyStr + " is not a Drugname.";
    }
}

function ConvertStateNameToIndex(tmpNameStr) {
    for (var iState = 0; iState < CurrentCase.states.length; iState++) {
        if (CurrentCase.states[iState].name == tmpNameStr) {
            break
        }
    }
    if (iState < CurrentCase.states.length) {
        return (iState)
    } else {
        alert("nextState: " + tmpNameStr + " is not a stateName.");
        throw "nextState: " + tmpNameStr + " is not a stateName.";
    }
}

function InitializeCaseParams() {
    HemoSweepPosition = 0;
    RespSweepPosition = 0;
    CoSweep = 0;      
    HemoX1 = HemoX0;
    HemoX2 = HemoX0;
    EcgIIY1 = EcgIIBaseline;
    EcgIIY2 = EcgIIBaseline;
    EcgV5Y1 = EcgV5Baseline;
    EcgV5Y2 = EcgV5Baseline;
    HemoCprCount = 0;
    HemoZapCount = 0;
    P1Y1 = P1Baseline;
    P1Y2 = P1Baseline;
    SpO2Y1 = SpO2Baseline;
    SpO2Y2 = SpO2Baseline;
    RespX1 = HemoX0;
    RespX2 = HemoX0;
    CO2Y1 = CO2Baseline;
    CO2Y2 = CO2Baseline;
    APY1 = APBaseline;
    APY2 = APBaseline;
    CaseLogStr1 = "";
    CaseLogStr2 = "";
    GradeStr = "Incomplete";
    Score = 0;
    UpdateOneSecCount = 0;
    UpdateFiveSecCount = 0;
    for (var i = 1; i < DrugInfo.Drugs.length; i++) {
        DrugInfo.Drugs[i].adminBolusAmount = 0;
        DrugInfo.Drugs[i].adminBolusFlag = false;
        DrugInfo.Drugs[i].adminBolusLevel = 0;
        DrugInfo.Drugs[i].adminInfusionFlag = false;
        DrugInfo.Drugs[i].adminInfusionRate = 0
    }
    for (var i = 0; i < IvAdmin.Iv.length; i++) {
        IvAdmin.Iv[i].fluidStr = "None";
        IvAdmin.Iv[i].infusionRate = 0;
        IvAdmin.Iv[i].bolusAmount = 0
    }
    PddAddedBicarb = 0;
    PddDeltaHr = 0;
    PddDeltaBp = 0;
    PddHr = -99;
    PddSpRate = -99;
	TransHr = -99;      // initial value set in SetCurrentState
    PddAbpS = 132;
    PddAbpD = 72;
    PddAbpM = 92;
    PddCo = 4.0;
    PddDoa = 0;
    PddMic = 0;
    PddNmb = 0;
    PddTfluid = 0;
    PddTlr = 0;
    PddTns = 0;
    PddTalb = 0;
    PddTprbc = 0;
    PddTuo = 0;
    PddTebl = 0;
    PrpAlvAgt = 0;
    PrpAlvDes = 0;
    PrpAlvHal = 0;
    PrpAlvIso = 0;
    PrpAlvN2O = 0;
    PrpAlvO2 = 16;
    PrpAlvRr = 0;
    PrpAlvSev = 0;
    PrpAlvTv = 0;
    PrpArtBicarb = 24;
    PrpArtPco2 = 40;
    PrpArtPh = 7.4;
    PrpArtPo2 = 90;
    PrpEtCO2 = 0;
    PrpFeAgt = 0;
    PrpFeDes = 0;
    PrpFeHal = 0;
    PrpFeIso = 0;
    PrpFeN2O = 0;
    PrpFeO2 = 16;
    PrpFeSev = 0;
    PrpFiAgt = 0;
    PrpFiDes = 0;
    PrpFiHal = 0;
    PrpFiIso = 0;
    PrpFiN2O = 0;
    PrpFiO2 = 21;
    PrpFiSev = 0;
    PrpMac = 0;
    PrpMonPeep = 0;
    PrpMonPip = 0;
    PrpMonRr = 0;
    PrpMonTv = 0;
    PrpMv = 0;
    PrpPotassium = 0;
    PrpRespWaveStr = "nl";
    PrpSpO2 = 99;
    PrpTotalFlow = 5;
    PrpTubeStatusStr = "noTube";
    UserAdjustedHeadFlag = false;
    UserAirFlow = 0;
    UserAirwayStr = "none";
    UserAspiratedCvpFlag = false;
    UserBreathModeStr = "spontaneous";
    UserCalledForHelpFlag = false;
    UserCaseRunning = false;
    UserCheckedCircuitFlag = false;
    UserConnectedFlag = false;
    UserDepthTubeCurrent = 0;
    UserDoingCricoidFlag = false;
    UserDoingCprFlag = false;
    UserDoingIcedIvFlag = false;
    UserDoingIcePackFlag = false;
    UserDoingIcedLavageFlag = false;
    UserDoingWarmBlanketFlag = false;
    UserDoingWarmIvFlag = false;
    UserFloodedFieldFlag = false;
    UserInsertedChestTubeFlag = false;
    UserInsertedFoleyFlag = false;
    UserInsertedArtLineFlag = false;
    UserInsertedCvpFlag = false;
    UserInsertedNasalFlag = false;
    UserInsertedOralFlag = false;
    UserInsertedPaCathFlag = false;
    UserMakeIncisionFlag = false;
    UserMonitorDisplayStr = "nbp";
    UserN2OFlow = 0;
    UserNbpModeStr = "waiting";
    UserO2Flow = 5;
    UserOverdosedFlag = false;
    UserPeep = 0;
    UserPositionStr = "supine";
    UserShowingWhatNowFlag = false;
    UserSuctionedFlag = false;
    UserSurgeonModeStr = "waitingForPrep";
    UserSyncedFlag = false;
    UserVaporizerAmount = 0;
    if (CurrentCase.leanBodyMass < 11) {
        UserBagRr = 20;
        UserBagTv = 10;
        UserVentRr = 20;
        UserVentTv = 10
    } else if (CurrentCase.leanBodyMass < 21) {
        UserBagRr = 16;
        UserBagTv = 100;
        UserVentRr = 16;
        UserVentTv = 100
    } else if (CurrentCase.leanBodyMass < 101) {
        UserBagRr = 12;
        UserBagTv = 200;
        UserVentRr = 10;
        UserVentTv = 20 * Math.floor((6 * CurrentCase.leanBodyMass) / 20)
    } else {
        UserBagRr = 10;
        UserBagTv = 400;
        UserVentRr = 8;
        UserVentTv = 600
    }
}

function PredictDrugDeltas() {
    var tmpDelta;
    var targetDeltaHr = 0.0;
    var targetDeltaBp = 0.0;
    var targetMic = 0.0;
    var targetNmb = 0.0;
    for (var i = 1; i < DrugInfo.Drugs.length; i++) {
        if (DrugInfo.Drugs[i].adminBolusLevel > 0.0) {
            tmpDelta = DrugInfo.Drugs[i].adminBolusLevel * DrugInfo.Drugs[i].effectMagnitude / (DrugInfo.Drugs[i].bolusE100 * CurrentCase.leanBodyMass);
            switch (DrugInfo.Drugs[i].effect) {
                case "hr":
                    targetDeltaHr += tmpDelta;
                    break;
                case "bp":
                    targetDeltaBp += tmpDelta;
                    break;
                case "mic":
                    targetMic += tmpDelta;
                    break;
                case "nmb":
                    targetNmb += tmpDelta;
                    break;
                case "none":
                    break;
                default:
                    throw "invalid drug effect: " + DrugInfo.Drugs[i].effect;
            }
            if (((DrugInfo.Drugs[i].adminBolusLevel / CurrentCase.leanBodyMass) > DrugInfo.Drugs[i].overdose) && CurrentState.overdoseFlag) {
                UserDrugIndex = i;
                UserOverdosedFlag = true;
                RecordOverdose()
            }
            if (CaseTimeInSec - DrugInfo.Drugs[i].adminBolusTime > DrugInfo.Drugs[i].effectSec) {
                DrugInfo.Drugs[i].adminBolusLevel *= 0.99
            }
        }
        if (DrugInfo.Drugs[i].adminInfusionRate > 0.0) {
            tmpDelta = DrugInfo.Drugs[i].adminInfusionRate * DrugInfo.Drugs[i].effectMagnitude / DrugInfo.Drugs[i].infusionE100;
            switch (DrugInfo.Drugs[i].effect) {
                case "hr":
                    targetDeltaHr += tmpDelta;
                    break;
                case "bp":
                    targetDeltaBp += tmpDelta;
                    break;
                case "mic":
                    targetMic += tmpDelta;
                    break;
                case "nmb":
                    targetNmb += tmpDelta;
                    break;
                case "none":
                    break;
                default:
                    throw "invalid drug effect" + DrugInfo.Drugs[i].effect;
            }
        }
    }
    targetDeltaHr = Math.max(-30, targetDeltaHr);     
    targetDeltaHr = Math.min(targetDeltaHr, 30);      
    PddDeltaHr += 0.1 * (targetDeltaHr - PddDeltaHr); 
    targetDeltaBp = Math.max(-20, targetDeltaBp);     
    targetDeltaBp = Math.min(targetDeltaBp, 20);      
    PddDeltaBp += 0.1 * (targetDeltaBp - PddDeltaBp); 
    targetMic = Math.max(0, targetMic);
    targetMic = Math.min(targetMic, 5);
    PddMic += 0.1 * (targetMic - PddMic); 
    PddDoa = PrpMac + PddMic;
    targetNmb = Math.max(0, targetNmb);
    targetNmb = Math.min(targetNmb, 5);
    PddNmb += 0.1 * (targetNmb - PddNmb); 

    PddHr = Math.max(0, CurrentState.baseHr + PddDeltaHr + TransHr);
	
    if (PddHr < 11) {
        PddHr = 0;
        PddSpRate = 0;
    } else {
		PddSpRate = PddHr;
	}
    if (CurrentState.spSignal == 0) {
        PddSpRate = 0;
	}
	
    PddAbpS = Math.max(18, CurrentState.baseAbpS + PddDeltaBp + TransAbpS);
    PddAbpD = Math.max(18, CurrentState.baseAbpD + PddDeltaBp + TransAbpM);
    PddAbpM = Math.max(18, CurrentState.baseAbpM + PddDeltaBp + TransAbpD);
	
	TransHr = TransHr * 0.8;
	TransAbpS = TransAbpS * 0.8;
	TransAbpD = TransAbpD * 0.8;
	TransAbpM = TransAbpM * 0.8;
	
    PddCvp = CurrentState.cvp;
    PddPapS = CurrentState.papS;
    PddPapD = CurrentState.papD;
    PddPapM = CurrentState.papM;
    PddPapW = CurrentState.papW;
    if (UserPositionStr == "trend") {
        PddAbpS += 6;
        PddAbpD += 3;
        PddAbpM += 4;
        PddCvp += 2;
        PddPapS += 3;
        PddPapD += 2;
        PddPapM += 2;
        PddPapW += 2
    }
    if ((UserPositionStr == "reverseTrend") || (UserPositionStr == "sitting")) {
        PddAbpS -= 6;
        PddAbpD -= 3;
        PddAbpM -= 4;
        PddCvp -= 2;
        PddPapS -= 3;
        PddPapD -= 2;
        PddPapM -= 2;
        PddPapW -= 2
    }
    if (UserDoingCprFlag == false) {
        PddCo = CurrentState.cardiacOutput
    } else {
        PddCo = CurrentCase.coMin * 0.7
    }
    SetNextHemoWave();
    for (var i = 0; i <= 1; i++) {
        if (IvAdmin.Iv[i].fluidStr == IvFluidStr[1]) {
            PddTlr += IvAdmin.Iv[i].infusionRate / 3600
        } else if (IvAdmin.Iv[i].fluidStr == IvFluidStr[2]) {
            PddTns += IvAdmin.Iv[i].infusionRate / 3600
        } else if (IvAdmin.Iv[i].fluidStr == IvFluidStr[3]) {
            PddTalb += IvAdmin.Iv[i].infusionRate / 3600
        } else if (IvAdmin.Iv[i].fluidStr == IvFluidStr[4]) {
            PddTprbc += IvAdmin.Iv[i].infusionRate / 3600
        }
        IvAdmin.Iv[i].bolusAmount = 0
    }
    PddTfluid = PddTlr + PddTns + PddTalb + PddTprbc;
    PddTuo += CurrentState.rateUo / 60.0;
/* was ---------------------------------------------------
    if (UserSurgeonModeStr == "operating") {
        PddTebl += CurrentState.rateEbl / 60.0;
    }
--------------------------------------------------------- */
        PddTebl += CurrentState.rateEbl / 60.0;
}

function PredictRespParams() {
    if (UserConnectedFlag == false) {
        UserBreathModeStr = "spontaneous"
    }
    if ((UserAirwayStr == "none") || (UserAirwayStr == "mask") || (UserAirwayStr == "lma")) {
        PrpTubeStatusStr = "noTube"
    } else if (UserDepthTubeCurrent < CurrentCase.depthCords) {
        PrpTubeStatusStr = "tubeAboveCords"
    } else if (((PrpTubeStatusStr == "tubeInEsophagus") || (PrpTubeStatusStr == "tubeAboveCords")) && (UserDepthTubeCurrent >= CurrentCase.depthCords)) {
        PrpTubeStatusStr = "tubeInEsophagus"
    } else if (((PrpTubeStatusStr == "tubeInTrachea") || (PrpTubeStatusStr == "tubeInRightMainstem")) && (UserDepthTubeCurrent > CurrentCase.depthCarina)) {
        PrpTubeStatusStr = "tubeInRightMainstem"
    } else {
        PrpTubeStatusStr = "tubeInTrachea"
    }
    var fSpontRr = 1;
    var fSpontTv = 1;
    if (PddNmb > 0.8) {
        fSpontRr = 0;
        fSpontTv = 0
    } else if (PddNmb > 0.5) {
        fSpontRr = 1.3;
        fSpontTv = 0.6
    }
    var fSetTv = 1;
    if (CurrentState.airwayStr == "obstructed") {
        fSetTv = 0.3
    } else if (CurrentState.airwayStr == "restricted") {
        fSetTv = 0.7
    }
    switch (UserBreathModeStr) {
        case "spontaneous":
            if (UserConnectedFlag && PrpTubeStatusStr == "noTube") {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                if (CurrentState.airwayStr == "obstructed") {
                    PrpAlvTv = Math.min(PrpAlvTv, 1.9 * CurrentCase.leanBodyMass)
                }
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = UserPeep + 2;
                PrpMonPeep = UserPeep
            } else if (UserConnectedFlag && PrpTubeStatusStr == "tubeAboveCords") {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if (UserConnectedFlag && PrpTubeStatusStr == "tubeInEsophagus") {
                PrpAlvRr = 0;
                PrpAlvTv = 0;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = UserPeep;
                PrpMonPeep = UserPeep
            } else if (UserConnectedFlag && PrpTubeStatusStr == "tubeInRightMainstem") {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = UserPeep + 2;
                PrpMonPeep = UserPeep
            } else if (UserConnectedFlag && PrpTubeStatusStr == "tubeInTrachea") {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = UserPeep + 2;
                PrpMonPeep = UserPeep
            } else if ((UserConnectedFlag == false) && (PrpTubeStatusStr == "noTube")) {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                if (CurrentState.airwayStr == "obstructed") {
                    PrpAlvTv = Math.min(PrpAlvTv, 1.9 * CurrentCase.leanBodyMass)
                }
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if ((UserConnectedFlag == false) && (PrpTubeStatusStr == "tubeAboveCords")) {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if ((UserConnectedFlag == false) && (PrpTubeStatusStr == "tubeInEsophagus")) {
                PrpAlvRr = 0;
                PrpAlvTv = 0;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if ((UserConnectedFlag == false) && (PrpTubeStatusStr == "tubeInRightMainstem")) {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if ((UserConnectedFlag == false) && (PrpTubeStatusStr == "tubeInTrachea")) {
                PrpAlvRr = CurrentState.spontRr * fSpontRr;
                PrpAlvTv = CurrentState.spontTv * fSpontTv;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            }
            break;
        case "bagControl":
            if (PrpTubeStatusStr == "noTube") {
                PrpAlvRr = UserBagRr;
                PrpAlvTv = UserBagTv * fSetTv;
                if (CurrentState.airwayStr == "obstructed") {
                    PrpAlvTv = Math.min(PrpAlvTv, 1.9 * CurrentCase.leanBodyMass)
                }
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = CurrentState.contPip * UserBagTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            } else if (PrpTubeStatusStr == "tubeAboveCords") {
                PrpAlvRr = 0;
                PrpAlvTv = 0;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if (PrpTubeStatusStr == "tubeInEsophagus") {
                PrpAlvRr = 0;
                PrpAlvTv = 0;
                PrpMonRr = UserBagRr;
                PrpMonTv = UserBagTv;
                PrpMonPip = 1.5 * CurrentState.contPip * UserBagTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            } else if (PrpTubeStatusStr == "tubeInRightMainstem") {
                PrpAlvRr = UserBagRr;
                PrpAlvTv = UserBagTv * fSetTv;
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = 1.5 * CurrentState.contPip * UserBagTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            } else if (PrpTubeStatusStr == "tubeInTrachea") {
                PrpAlvRr = UserBagRr;
                PrpAlvTv = UserBagTv * fSetTv;
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = CurrentState.contPip * UserBagTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            }
            break;
        case "ventilator":
            if (PrpTubeStatusStr == "noTube") {
                PrpAlvRr = UserVentRr;
                PrpAlvTv = UserVentTv * fSetTv;
                if (CurrentState.airwayStr == "obstructed") {
                    PrpAlvTv = Math.min(PrpAlvTv, 1.9 * CurrentCase.leanBodyMass)
                }
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = CurrentState.contPip * UserVentTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            } else if (PrpTubeStatusStr == "tubeAboveCords") {
                PrpAlvRr = 0;
                PrpAlvTv = 0;
                PrpMonRr = 0;
                PrpMonTv = 0;
                PrpMonPip = 0;
                PrpMonPeep = 0
            } else if (PrpTubeStatusStr == "tubeInEsophagus") {
                PrpAlvRr = 0;
                PrpAlvTv = 0;
                PrpMonRr = UserVentRr;
                PrpMonTv = UserVentTv;
                PrpMonPip = 1.5 * CurrentState.contPip * UserVentTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            } else if (PrpTubeStatusStr == "tubeInRightMainstem") {
                PrpAlvRr = UserVentRr;
                PrpAlvTv = UserVentTv * fSetTv;
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = 1.5 * CurrentState.contPip * UserVentTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            } else if (PrpTubeStatusStr == "tubeInTrachea") {
                PrpAlvRr = UserVentRr;
                PrpAlvTv = UserVentTv * fSetTv;
                PrpMonRr = PrpAlvRr;
                PrpMonTv = PrpAlvTv;
                PrpMonPip = CurrentState.contPip * UserVentTv / (10.0 * CurrentCase.leanBodyMass) + UserPeep;
                PrpMonPeep = UserPeep
            }
            break;
        default:
            throw "invalid UserBreathModeStr";
    }
    PrpMv = 0.95 * PrpMv + 0.05 * PrpAlvRr * PrpAlvTv;
    var fTargetO2 = 8;
    var fTargetN2O = 0;
    PrpTotalFlow = UserO2Flow + UserAirFlow + UserN2OFlow;
    if ((PrpTotalFlow > 0.2) && (UserO2Flow > 0.2)) {
        fTargetO2 = (100 * (UserO2Flow - 0.2) + 21 * UserAirFlow) / (PrpTotalFlow - 0.2) - 4.0;
        fTargetN2O = 100 * UserN2OFlow / (PrpTotalFlow - 0.2)
    } else {
        fTargetO2 = 8.0;
        fTargetN2O = 100 * UserN2OFlow / PrpTotalFlow
    }
    PrpFiO2 = Math.max(PrpFiO2 + 0.03 * (fTargetO2 - PrpFiO2), 8.0);
    PrpFiN2O = PrpFiN2O + 0.03 * (fTargetN2O - PrpFiN2O);
    var tmpFlowWt;
    if (PrpTotalFlow > 2.0) {
        tmpFlowWt = 1.0
    } else {
        tmpFlowWt = 0.5 * PrpTotalFlow
    }
    if (UserVaporizerStr == "Desflurane") {
        UserVapStr = "DSF"
    } else if (UserVaporizerStr == "Halothane") {
        UserVapStr = "HAL"
    } else if (UserVaporizerStr == "Isoflurane") {
        UserVapStr = "ISF"
    } else if (UserVaporizerStr == "Sevoflurane") {
        UserVapStr = "SVF"
    }
    $("txtVap").innerHTML = UserVapStr;
    if (UserConnectedFlag && (PddCo > CurrentCase.coMin) && (PrpAlvTv > CurrentCase.volAnDsp) && (PrpAlvRr > 1)) {
        PrpAlvO2 = Math.max(PrpAlvO2 + 0.05 * (PrpFiO2 - 5.0 - PrpAlvO2), 4.0);
        PrpAlvN2O = PrpAlvN2O + 0.03 * (PrpFiN2O - PrpAlvN2O);
        PrpFeO2 = PrpAlvO2;
        PrpFeN2O = PrpAlvN2O;
        if (UserVaporizerStr == "Desflurane") {
            PrpFiDes = PrpFiDes + 0.03 * (UserVaporizerAmount * tmpFlowWt - PrpFiDes);
            PrpAlvDes = PrpAlvDes + 0.02 * (PrpFiDes - PrpAlvDes);  
            PrpFiAgt = PrpFiDes;
            PrpFeAgt = PrpAlvDes
        } else {
            PrpFiDes = 0.97 * PrpFiDes
        }
        if (UserVaporizerStr == "Halothane") {
            PrpFiHal = PrpFiHal + 0.03 * (UserVaporizerAmount * tmpFlowWt - PrpFiHal);
            PrpAlvHal = PrpAlvHal + 0.004 * (PrpFiHal - PrpAlvHal);
            PrpFiAgt = PrpFiHal;
            PrpFeAgt = PrpAlvHal
        } else {
            PrpFiHal = 0.97 * PrpFiHal
        }
        if (UserVaporizerStr == "Isoflurane") {
            PrpFiIso = PrpFiIso + 0.03 * (UserVaporizerAmount * tmpFlowWt - PrpFiIso);
            PrpAlvIso = PrpAlvIso + 0.007 * (PrpFiIso - PrpAlvIso);
            PrpFiAgt = PrpFiIso;
            PrpFeAgt = PrpAlvIso
        } else {
            PrpFiIso = 0.97 * PrpFiIso
        }
        if (UserVaporizerStr == "Sevoflurane") {
            PrpFiSev = PrpFiSev + 0.03 * (UserVaporizerAmount * tmpFlowWt - PrpFiSev);
            PrpAlvSev = PrpAlvSev + 0.01 * (PrpFiSev - PrpAlvSev);
            PrpFiAgt = PrpFiSev;
            PrpFeAgt = PrpAlvSev
        } else {
            PrpFiSev = 0.97 * PrpFiSev
        }
    } else if (PddCo < CurrentCase.coMin) {
        PrpAlvO2 = Math.max(PrpAlvO2 + 0.005 * (8.0 - PrpAlvO2), 4.0);
        PrpAlvN2O = PrpAlvN2O;
        PrpFeO2 = PrpAlvO2;
        PrpFeN2O = PrpAlvN2O;
        PrpFiAgt = UserVaporizerAmount * 0.8;
        PrpFeAgt = UserVaporizerAmount * 0.8
    } else if ((PrpAlvTv < CurrentCase.volAnDsp) || (PrpAlvRr < 2)) {
        PrpAlvO2 = Math.max(PrpAlvO2 + 0.005 * (8.0 - PrpAlvO2), 4.0);
        PrpAlvN2O = PrpAlvN2O;
        PrpFeO2 = PrpFiO2;
        PrpFeN2O = PrpFiN2O;
        PrpFiAgt = UserVaporizerAmount * 0.8;
        PrpFeAgt = UserVaporizerAmount * 0.8
    } else {
        PrpAlvO2 = Math.max(PrpAlvO2 + 0.01 * (16.0 - PrpAlvO2), 4.0);
        PrpAlvN2O = PrpAlvN2O;
        PrpFeO2 = PrpFiO2;
        PrpFeN2O = PrpFiN2O;
        PrpFiAgt = UserVaporizerAmount * 0.3;
        PrpFeAgt = UserVaporizerAmount * 0.2
    }
    PrpMac = PrpAlvN2O / 105.0 + PrpAlvDes / 6.0 + PrpAlvHal / 0.7 + PrpAlvIso / 1.1 + PrpAlvSev / 2.0;
    var tmpFiO2 = PrpFiO2;
    if (UserConnectedFlag == false) {
        tmpFiO2 = 21
    }
    var targetSat;
    if (PrpMv < 8.0 * CurrentCase.leanBodyMass) {
        if (PrpAlvO2 < 12) {
            targetSat = 40
        } else if (PrpAlvO2 < 16) {
            targetSat = 60
        } else {
            targetSat = Math.max(40, CurrentState.sat40 - 10)
        }
        PrpSpO2 = PrpSpO2 + 0.03 * (targetSat - PrpSpO2)
    } else if (PrpMv < 20.0 * CurrentCase.leanBodyMass) {
        targetSat = Math.max(40, CurrentState.sat40 - 10);
        PrpSpO2 = PrpSpO2 + 0.015 * (targetSat - PrpSpO2)
    } else if (tmpFiO2 < 20) {
        targetSat = 40 + (CurrentState.sat20 - 40) * tmpFiO2 / 20;
        PrpSpO2 = PrpSpO2 + 0.06 * (targetSat - PrpSpO2)
    } else if (tmpFiO2 < 40) {
        targetSat = CurrentState.sat20 + (CurrentState.sat40 - CurrentState.sat20) * (tmpFiO2 - 20) / 20;
        PrpSpO2 = PrpSpO2 + 0.02 * (targetSat - PrpSpO2)
    } else {
        targetSat = CurrentState.sat40 + (CurrentState.sat100 - CurrentState.sat40) * (tmpFiO2 - 40) / 60;
        PrpSpO2 = PrpSpO2 + 0.02 * (targetSat - PrpSpO2)
    }
    if ((CurrentState.hiCo2ProdFlag) && (PrpMv < 120.0 * CurrentCase.leanBodyMass)) {
        PrpArtPco2 = 0.94 * PrpArtPco2 + 0.06 * 83.2
    } else if ((CurrentState.hiCo2ProdFlag) && (PrpMv < 200.0 * CurrentCase.leanBodyMass)) {
        PrpArtPco2 = 0.95 * PrpArtPco2 + 0.05 * 73.2
    } else if ((CurrentState.hiCo2ProdFlag) && (PrpMv < 240.0 * CurrentCase.leanBodyMass)) {
        PrpArtPco2 = 0.96 * PrpArtPco2 + 0.04 * 63.2
    } else if (PrpMv < 20.0 * CurrentCase.leanBodyMass) {
        PrpArtPco2 = 0.995 * PrpArtPco2 + 0.005 * 80.0
    } else if (PrpMv < 80.0 * CurrentCase.leanBodyMass) {
        PrpArtPco2 = 0.995 * PrpArtPco2 + 0.005 * (93.2 - 0.66 * PrpMv / CurrentCase.leanBodyMass)
    } else if (PrpMv < 240.0 * CurrentCase.leanBodyMass) {
        PrpArtPco2 = 0.99 * PrpArtPco2 + 0.01 * (50.0 - 0.125 * PrpMv / CurrentCase.leanBodyMass)
    } else {
        PrpArtPco2 = 0.99 * PrpArtPco2 + 0.01 * 20.0
    }
    if (PrpArtPco2 > 80.1) {
        PrpArtPco2 = 80.1
    }
    if ((CurrentState.airwayStr == "obstructed") || (PrpAlvTv < 2 * CurrentCase.leanBodyMass)) {
        PrpRespWaveStr = "hump"
    } else if (CurrentState.airwayStr == "restricted") {
        PrpRespWaveStr = "slant"
    } else {
        PrpRespWaveStr = "nl"
    }
    SetNextRespWave();
    if ((UserConnectedFlag == false) || (PrpAlvRr == 0) || (PrpAlvTv == 0)) {
        PrpEtCO2 = 0
    } else if (PrpRespWaveStr == "hump") {
        PrpEtCO2 = (PrpArtPco2 - 8.0) * PrpMonTv / (2.0 * CurrentCase.volAnDsp)
    } else if (PddCo / CurrentCase.coMin < 0.5) {
        PrpEtCO2 = 0.98 * PrpEtCO2
    } else if (PddCo / CurrentCase.coMin < 0.75) {
        PrpEtCO2 = (PrpArtPco2 - 8.0) * 0.5
    } else if (PddCo / CurrentCase.coMin < 1.0) {
        PrpEtCO2 = (PrpArtPco2 - 8.0) * 0.75
    } else if (PrpRespWaveStr == "slant") {
        PrpEtCO2 = (PrpArtPco2 - 12.0) * PrpMonTv / (8.0 * CurrentCase.leanBodyMass)
    } else {
        PrpEtCO2 = PrpArtPco2 - 8.0
    }
    PddAddedBicarb = 0.999 * PddAddedBicarb;
    if (PrpArtPco2 > 40) {
        PrpArtBicarb = CurrentState.baseBicarb + PddAddedBicarb + 0.05 * (PrpArtPco2 - 40.0)
    } else {
        PrpArtBicarb = CurrentState.baseBicarb + PddAddedBicarb - 0.1 * (40.0 - PrpArtPco2)
    }
    PrpArtPh = 6.1 + Math.log(PrpArtBicarb / (0.03 * PrpArtPco2)) / 2.303;
    if (PrpSpO2 < 70) {
        PrpArtPo2 = 0.57 * PrpSpO2
    } else if (PrpSpO2 < 90) {
        PrpArtPo2 = 40.0 + 1.5 * (PrpSpO2 - 70.0)
    } else if (PrpSpO2 < 97) {
        PrpArtPo2 = 70.0 + 5.0 * (PrpSpO2 - 90.0)
    } else {
        PrpArtPo2 = 5.2 * PrpAlvO2
    }
    PrpPotassium = CurrentState.basePot + 0.03 * (PrpArtPco2 - 40.0)
}

function ProcessFsm() {
    for (var iTrans = 0; iTrans < CurrentState.trans.length; iTrans++) {
        var tran = CurrentState.trans[iTrans];
        var tmpAllCondsMetFlag = true;
        for (var iCond = 0; iCond < tran.conditions.length; iCond++) {
            var condition = tran.conditions[iCond];
            var condPassed;
            switch (condition.type) {
                case "time":
                    var timeInState = (CaseTimeInSec - StateStartTime);
                    condPassed = compare(timeInState, condition.value, condition.op);
                    break;
                case "tryLaryTube":
                    condPassed = (UserTriedLaryTubeFlag == condition.value);
                    break;
                case "tryFo":
                    condPassed = (UserTriedFoFlag == condition.value);
                    break;
                case "tryLma":
                    condPassed = (UserTriedLmaFlag == condition.value);
                    break;
                case "checkTube":
                    condPassed = (UserCheckedTubeFlag == condition.value);
                    break;
                case "adjustHead":
                    condPassed = (UserAdjustedHeadFlag == condition.value);
                    break;
                case "nasalAirway":
                    condPassed = (UserInsertedNasalFlag == condition.value);
                    break;
                case "oralAirway":
                    condPassed = (UserInsertedOralFlag == condition.value);
                    break;
                case "doingCricoid":
                    condPassed = (UserDoingCricoidFlag == condition.value);
                    break;
                case "suction":
                    condPassed = (UserSuctionedFlag == condition.value);
                    break;
                case "airwayLma":
                    condPassed = (UserAirwayStr == "lma") == condition.value;
                    break;
                case "airwayTube":
                    condPassed = (UserAirwayStr == "tube") == condition.value;
                    break;
                case "airwayCrico":
                    condPassed = (UserAirwayStr == "crico") == condition.value;
                    break;
                case "tubeAbove":
                    condPassed = (PrpTubeStatusStr == "tubeAboveCords") == condition.value;
                    break;
                case "tubeEsoph":
                    condPassed = (PrpTubeStatusStr == "tubeInEsophagus") == condition.value;
                    break;
                case "tubeMainstem":
                    condPassed = (PrpTubeStatusStr == "tubeInRightMainstem") == condition.value;
                    break;
                case "tubeTrachea":
                    condPassed = (PrpTubeStatusStr == "tubeInTrachea") == condition.value;
                    break;
                case "doa":
                    condPassed = compare(PddDoa, condition.value, condition.op);
                    break;
                case "mac":
                    condPassed = compare(PrpMac, condition.value, condition.op);
                    break;
                case "mic":
                    condPassed = compare(PddMic, condition.value, condition.op);
                    break;
                case "nmb":
                    condPassed = compare(PddNmb, condition.value, condition.op);
                    break;
                case "nitrousOxide":
                    condPassed = compare(PrpAlvN2O, condition.value, condition.op);
                    break;
                case "halothane":
                    condPassed = compare(PrpAlvHal, condition.value, condition.op);
                    break;
                case "tFluid":
                    condPassed = compare(PddTfluid, condition.value, condition.op);
                    break;
                case "aspirateCvp":
                    condPassed = (UserAspiratedCvpFlag == condition.value);
                    break;
                case "level":
                    condPassed = (UserPositionStr == "supine") == condition.value;
                    break;
                case "revTrend":
                    condPassed = (UserPositionStr == "reverseTrend") == condition.value;
                    break;
                case "trend":
                    condPassed = (UserPositionStr == "trend") == condition.value;
                    break;
                case "left":
                    condPassed = (UserPositionStr == "leftUterine") == condition.value;
                    break;
                case "makeIncision":
                    condPassed = (UserMakeIncisionFlag == condition.value);
                    break;
                case "doingSurgery":
                    condPassed = (UserSurgeonModeStr == "operating") == condition.value;
                    break;
                case "chestTube":
                    condPassed = (UserInsertedChestTubeFlag == condition.value);
                    break;
                case "defib":
                    condPassed = (UserDefibedEnergy > 0) && (UserSyncedFlag == false) && compare(UserDefibedEnergy, condition.value, condition.op);
                    break;
                case "sync":
                    condPassed = (UserDefibedEnergy > 0) && (UserSyncedFlag == true) && compare(UserDefibedEnergy, condition.value, condition.op);
                    break;
                case "doingCpr":
                    condPassed = (UserDoingCprFlag == condition.value);
                    break;
                case "floodField":
                    condPassed = (UserFloodedFieldFlag == condition.value);
                    break;
                case "icedIv":
                    condPassed = (UserDoingIcedIvFlag == condition.value);
                    break;
                case "icedLavage":
                    condPassed = (UserDoingIcedLavageFlag == condition.value);
                    break;
                case "icePack":
                    condPassed = (UserDoingIcePackFlag == condition.value);
                    break;
                case "warmBlanket":
                    condPassed = (UserDoingWarmBlanketFlag == condition.value);
                    break;
                case "warmIv":
                    condPassed = (UserDoingWarmIvFlag == condition.value);
                    break;
                case "checkCircuit":
                    condPassed = (UserCheckedCircuitFlag == condition.value);
                    break;
                case "o2Sat":
                    condPassed = compare(PrpSpO2, condition.value, condition.op);
                    break;
                case "pCO2":
                    condPassed = compare(PrpArtPo2, condition.value, condition.op);
                    break;
                case "peep":
                    condPassed = compare(UserPeep, condition.value, condition.op);
                    break;
                case "bDrug":
                    var tmpDrugIndex = ConvertDrugKeyToIndex(condition.drug);
                    condPassed = DrugInfo.Drugs[tmpDrugIndex].adminBolusFlag == true && compare(DrugInfo.Drugs[tmpDrugIndex].adminBolusAmount, condition.value, condition.op);
                    break;
                case "iDrug":
                    var tmpDrugIndex = ConvertDrugKeyToIndex(condition.drug);
                    condPassed = DrugInfo.Drugs[tmpDrugIndex].adminInfusionFlag == true && compare(DrugInfo.Drugs[tmpDrugIndex].adminInfusionRate, condition.value, condition.op);
                    break;
                default:
                    throw "invalid condition type: " + condition.type;
            }
            tmpAllCondsMetFlag = tmpAllCondsMetFlag && condPassed
        }
        if (tmpAllCondsMetFlag) {
            CaseLogStr2 = CaseLogStr2.concat(tran.comment + "\n");
            Score += tran.points;
            for (var iCond = 0; iCond < tran.conditions.length; iCond++) {
                var condition = tran.conditions[iCond];
                if (condition.type == "bDrug") {
                    var tmpDI = ConvertDrugKeyToIndex(condition.drug);
                    DrugInfo.Drugs[tmpDI].adminBolusAmount = 0.0;
                    DrugInfo.Drugs[tmpDI].adminBolusFlag = false
                }
            }
            CurrentStateIndex = ConvertStateNameToIndex(tran.nextState);
            SetCurrentState();
            break
        }
    }

    function compare(val1, val2, op) {
        if (op == "GT") {
            return val1 > val2
        } else if (op == "LT") {
            return val1 < val2
        } else if (op == "EQ") {
            return val1 == val2
        }
        throw "invalid operator";
    }
}

function SetCurrentCase(event) {
    // console.log("SetCurrentCase called");
    
    let tmpIndex;
    if (event && event.target) {
        tmpIndex = event.target.value;
    } else if (typeof event === 'string') {
        tmpIndex = event;
    } else {
        console.error("Invalid input to SetCurrentCase");
        return;
    }
    
    // console.log("Selected index:", tmpIndex);
    // console.log("CaseData:", CaseData);
    // console.log("CaseData tmpIndex:", CaseData[tmpIndex]);
    
    if (tmpIndex >= 1 && CaseData[tmpIndex]) {
        const selectedCase = CaseData[tmpIndex];
        if (selectedCase && !selectedCase.isAccessible) {
            if (selectedCase.title.includes('(Upgrade)')) {
				// console.log("CurrentCase is a demo case");
				resetCase();
                showDemoModal();
                return; 
            } else if (selectedCase.title.includes('(Pro Only)')) {
				// console.log("CurrentCase is a pro case");
				resetCase();
                showUpgradeModal(); 
                return; 
            }
        }

		// console.log("CurrentCase is showing as neither demo or pro");
		
        CurrentCaseIndex = tmpIndex;
        CurrentCase = CaseData[CurrentCaseIndex];
        // console.log("CurrentCase set to:", CurrentCase);
        
        for (var property in CaseDefault) {
            if (CurrentCase[property] == undefined) {
                CurrentCase[property] = CaseDefault[property]
            }
        }
        InitializeCaseParams();
        CaseTimeInSec = 0;
        var currentTime = new Date().getTime();
        LastOneSecUpdate = currentTime;
        LastHemoUpdate = currentTime;
        LastRespUpdate = currentTime;
        LastTenSecUpdate = currentTime;
        CurrentStateIndex = 0;
        CurrentHemoWave = sinus1[100];
        CurrentRespWave = nl[20];
        UserConnectedThisCaseFlag = false;
        SetCurrentState();
        NbpM = 0;
        
        $("txtCaseTitle").innerHTML = CurrentCase.title;
        
        // Modified line to check if element exists before hiding
        var selectcase = $("selectcase");
        if (selectcase) {
            selectcase.hide();
        }
        
        $("imgPatient").src = "app/images/" + UserImageStr + "/clr_" + CurrentCase.imageSet + ".jpg";
        UserCaseRunning = true;
        ShowPreopScreen();
        if (MyTimeout) {
            clearTimeout(MyTimeout)
        }
        EnableSideMenu();
        SetupButtonListeners(); 
			$("btnGo").classList.remove('disabled');
			$("btnGo").style.pointerEvents = 'auto';
			$("seldivN2O").classList.remove('disabled');
			$("seldivN2O").style.pointerEvents = 'auto';
			$("seldivAir").classList.remove('disabled');
			$("seldivAir").style.pointerEvents = 'auto';
			$("seldivO2").classList.remove('disabled');
			$("seldivO2").style.pointerEvents = 'auto';
			$("selVaporizer").classList.remove('disabled');
			$("selVaporizer").style.pointerEvents = 'auto';
			$("selVapAmount").classList.remove('disabled');
			$("selVapAmount").style.pointerEvents = 'auto';
        UserNbpModeStr = "deflating";
        NbpM = -16;
        UpdateHemoNumberDisplay();
        UpdateRespNumberDisplay();
        MyTimeout = setTimeout(Update, TimeoutInterval)
    } else {
        console.error("Invalid tmpIndex or CaseData not available:", tmpIndex);
    }
}


function SetCurrentState() {
	var priorBaseHr = -99;
	var priorBaseAbpS = -99;
	var priorBaseAbpD = -99;
	var priorBaseAbpM = -99;
 
    // subsequent states of case
    if (PddHr > -99) {
		priorBaseHr = CurrentState.baseHr;
		priorBaseAbpS = CurrentState.baseAbpS;
		priorBaseAbpD = CurrentState.baseAbpD;
		priorBaseAbpM = CurrentState.baseAbpM;
    }
	

    CurrentState = CurrentCase.states[CurrentStateIndex];
    StateStartTime = CaseTimeInSec;
    for (var property in StateDefault) {
        if (CurrentState[property] == undefined) {
            CurrentState[property] = StateDefault[property]
        }
    }
	
    // first state of case
    if (PddHr == -99) {
        PddHr = CurrentState.baseHr;
        PddAbpS = CurrentState.baseAbpS;
        PddAbpD = CurrentState.baseAbpD;
        PddAbpM = CurrentState.baseAbpM;
		TransHr = 0;
		TransAbpS = 0;
		TransAbpD = 0;
		TransAbpM = 0;
        PrpMonRr = CurrentState.spontRr;
        PrpMv = CurrentState.spontRr * CurrentState.spontTv;
        PrpSpO2 = CurrentCase.initialSat
    }

    // subsequent states of case
    if (priorBaseHr > -99) {
		TransHr = (priorBaseHr - CurrentState.baseHr) * 0.8;
		TransAbpS = (priorBaseAbpS - CurrentState.baseAbpS) * 0.8;
		TransAbpD = (priorBaseAbpD - CurrentState.baseAbpD) * 0.8;
		TransAbpM = (priorBaseAbpM - CurrentState.baseAbpM) * 0.8;
    }
	
    PredictDrugDeltas();
    PredictRespParams();
    if (CurrentStateIndex == 0) {
        HemoCurrentPoint = 0;
        RespCurrentPoint = 1
    }
    UserAdjustedHeadFlag = false;
    UserCheckedTubeFlag = false;
    UserDefibedEnergy = 0;
    UserInsertedNasalFlag = false;
    UserInsertedOralFlag = false;
    UserMakeIncisionFlag = false;
    UserSuctionedFlag = false;
    UserTriedFoFlag = false;
    UserTriedLaryTubeFlag = false;
    UserTriedLmaFlag = false;
    RecordHeader();
    if (UserShowingWhatNowFlag) {
        ShowWhatNow()
    }
}

function Update() {
    var currentTime = new Date().getTime();
    if (currentTime - LastHemoUpdate >= 20) {
        LastHemoUpdate = currentTime;
        UpdateHemoDisplay()
    }
    if (currentTime - LastRespUpdate >= 80) {
        LastRespUpdate = currentTime;
        UpdateRespDisplayAndImage()
    }
    if (currentTime - LastOneSecUpdate >= 200) {
        UpdateOneSecCount += 1;
        LastOneSecUpdate = currentTime;
        if (UpdateOneSecCount == 1) {
            PredictDrugDeltas()
        } else if (UpdateOneSecCount == 2) {
            PredictRespParams()
        } else if (UpdateOneSecCount == 3) {
            UpdateSurgeon()
        } else if (UpdateOneSecCount == 4) {
            if (CurrentState.finalState == 0) {
                ProcessFsm()
            }
        } else if (UpdateOneSecCount == 5) {
            CaseTimeInSec += 1;
            UpdateHemoNumberDisplay();
            UpdateOneSecCount = 0;
            UpdateFiveSecCount += 1;
            if (UpdateFiveSecCount == 5) {
                UpdateFiveSecCount = 0;
                UpdateRespNumberDisplay()
            }
        }
    }
    if (currentTime - LastTenSecUpdate >= 10000) {
        LastTenSecUpdate = currentTime
    }
    if (UserOverdosedFlag == false) {
        MyTimeout = setTimeout(Update, TimeoutInterval)
    }
}

function UpdateSurgeon() {
    if ((UserSurgeonModeStr == "prepping") && (CaseTimeInSec - SurgeonStartTime >= CurrentCase.durationPrep) && UserMgmtEnabledFlag) {
        UserSurgeonModeStr = "readyToMakeIncision";
        ShowSurgeonScreen()
    }
    if ((UserSurgeonModeStr == "makingIncision") && (CaseTimeInSec - SurgeonStartTime >= 10) && UserMgmtEnabledFlag) {
        UserSurgeonModeStr = "operating";
        SurgeonStartTime = CaseTimeInSec;
        ShowSurgeonScreen()
    }
    if ((UserSurgeonModeStr == "operating") && (CaseTimeInSec - SurgeonStartTime >= CurrentCase.durationSurgery) && UserMgmtEnabledFlag) {
        UserSurgeonModeStr = "closing";
        SurgeonStartTime = CaseTimeInSec;
        ShowSurgeonScreen()
    }
    if ((UserSurgeonModeStr == "closing") && (CaseTimeInSec - SurgeonStartTime >= 180) && UserMgmtEnabledFlag) {
        UserSurgeonModeStr = "done";
        ShowSurgeonScreen()
    }
}