import os
import re
import json

def process_single_file(filename):
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    json_dir = '/home/anesoft/public_html/app.anesoft.com/app/case_data/'
    
    if not os.path.exists(json_dir):
        os.makedirs(json_dir)
    
    print(f"\n--- Processing file: {filename} ---")
    with open(os.path.join(js_dir, filename), 'r') as f:
        content = f.read()

    # Updated regex pattern to match `CaseData` object more flexibly
    pattern = r'CaseData\[(\d+)\]\s*=\s*({[\s\S]*?})(?:\s*;|\s*$)'
    match = re.search(pattern, content, re.DOTALL)
    
    if match:
        case_id = match.group(1)
        case_data = match.group(2)
        print(f"\nMatched case data for ID {case_id}:")
        print(case_data[:500])  # Print part of matched data for verification
        
        # Convert JS-like object to valid JSON
        case_data = case_data.replace("'", '"')  # Replace single quotes with double quotes
        case_data = re.sub(r'(?<=[{,])\s*(\w+):', r'"\1":', case_data)  # Ensure all keys are quoted
        case_data = re.sub(r',\s*}', '}', case_data)  # Remove trailing commas
        
        try:
            case_dict = json.loads(case_data)
        except json.JSONDecodeError as e:
            print(f"Error decoding JSON for {filename}: {e}")
            print(f"Problematic JSON data: {case_data[:500]}")
            return
        
        # Add id and isPro fields
        case_dict['id'] = int(case_id)
        case_dict['isPro'] = int(case_id) > 2
        
        # Save as JSON
        json_filename = f'case_{case_id}.json'
        json_path = os.path.join(json_dir, json_filename)
        with open(json_path, 'w') as f:
            json.dump(case_dict, f, indent=2)

        print(f"Converted {filename} to {json_filename}")
    else:
        print(f"No matching CaseData object found in: {filename}")

if __name__ == "__main__":
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    for filename in os.listdir(js_dir):
        if filename.startswith('Anesth6Case') and filename.endswith('.js'):
            process_single_file(filename)