import os
import re

def inspect_files():
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    
    for filename in os.listdir(js_dir):
        if filename.startswith('Anesth6Case') and filename.endswith('.js'):
            print(f"\n--- Processing file: {filename} ---")
            with open(os.path.join(js_dir, filename), 'r') as f:
                content = f.read()

            # Print the first 1000 characters to understand the structure
            print(content[:1000])

            # Basic regex to capture CaseData assignment
            match = re.search(r'CaseData\[\d+\]\s*=\s*({[\s\S]*?});', content)
            if match:
                case_id = match.group(1)
                case_data = match.group(2)
                print(f"Matched case data for ID {case_id}:")
                print(case_data[:500])  # Print a part of the matched data
            else:
                print(f"No matching CaseData object found in: {filename}")

if __name__ == "__main__":
    inspect_files()


