<?php
// File: includes/user_settings_functions.php

function updateUserSettings($userId, $data) {
    global $pdo;
    $table_name = PREFIX . 'users';
    
	$allowedFields = [
		'user_login', 'first_name', 'last_name', 'user_email', 
		'group_id', 'display_name', 'user_nicename', 'user_url'
	];

    $updates = [];
    $params = [];
    foreach ($allowedFields as $field) {
        if (isset($data[$field])) {
            $updates[] = "$field = ?";
            $params[] = $data[$field];
        }
    }

    if (empty($updates)) {
        return false;
    }

    $params[] = $userId;
    $sql = "UPDATE $table_name SET " . implode(', ', $updates) . " WHERE ID = ?";
    $stmt = $pdo->prepare($sql);
    return $stmt->execute($params);
}

function changePassword($userId, $newPassword) {
    global $pdo;
    $table_name = PREFIX . 'users';
    
    // Generate password hash same way as group creation
    $salt = sha1(md5($newPassword));
    $hashedPassword = md5($newPassword.$salt);
    
    // Update both pass and clear_pass (if it exists)
    $stmt = $pdo->prepare("UPDATE $table_name SET user_pass = ?, user_pass_clear = ? WHERE ID = ?");
    return $stmt->execute([$hashedPassword, $newPassword, $userId]);
}
?>