<?php
// File: super_admin.php

/************************************
 * allows for super admin to set what settings the regular admins 
 * are allowed to toggle for their users.
*************************************/
require_once 'includes/include_all.inc.php';

$userId = $_SESSION['front_user_id'];
$user = getUserDetails($userId);

if ($user['user_type'] !== 'super') {
    die("Access denied. You must be a super admin to view this page.");
}

function getAllGroups() {
    global $pdo;
    $table_name = PREFIX . 'groups';
    $stmt = $pdo->query("SELECT * FROM $table_name");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function getAllAdmins() {
    global $pdo;
    $table_name = PREFIX . 'users';
    $stmt = $pdo->query("SELECT * FROM $table_name WHERE user_type = 'admin'");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function updateAdminType($userId, $newType) {
    global $pdo;
    $table_name = PREFIX . 'users';
    $stmt = $pdo->prepare("UPDATE $table_name SET user_type = ? WHERE ID = ?");
    return $stmt->execute([$newType, $userId]);
}

$groups = getAllGroups();
$admins = getAllAdmins();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_admin_type'])) {
        $adminId = $_POST['admin_id'];
        $newType = $_POST['new_type'];
        if (updateAdminType($adminId, $newType)) {
            $successMessage = "Admin type updated successfully.";
        } else {
            $errorMessage = "Failed to update admin type.";
        }
    }
    // Add more POST action handlers here
}
?>

<h2>Super Admin Dashboard</h2>

<h3>Manage Groups</h3>
<ul>
    <?php foreach ($groups as $group): ?>
        <li><?php echo htmlspecialchars($group['group_name']); ?></li>
    <?php endforeach; ?>
</ul>

<h3>Manage Admins</h3>
<table>
    <tr>
        <th>Name</th>
        <th>Email</th>
        <th>Type</th>
        <th>Action</th>
    </tr>
    <?php foreach ($admins as $admin): ?>
        <tr>
            <td><?php echo htmlspecialchars($admin['first_name'] . ' ' . $admin['last_name']); ?></td>
            <td><?php echo htmlspecialchars($admin['user_email']); ?></td>
            <td><?php echo htmlspecialchars($admin['user_type']); ?></td>
            <td>
                <form method="POST" action="">
                    <input type="hidden" name="admin_id" value="<?php echo $admin['ID']; ?>">
                    <select name="new_type">
                        <option value="admin" <?php echo $admin['user_type'] === 'admin' ? 'selected' : ''; ?>>Admin</option>
                        <option value="super" <?php echo $admin['user_type'] === 'super' ? 'selected' : ''; ?>>Super Admin</option>
                    </select>
                    <button type="submit" name="update_admin_type">Update</button>
                </form>
            </td>
        </tr>
    <?php endforeach; ?>
</table>

<?php
if (isset($successMessage)) {
    echo "<p class='success'>$successMessage</p>";
}
if (isset($errorMessage)) {
    echo "<p class='error'>$errorMessage</p>";
}
?>