<?php
// File: /includes/session_manager.php
// Allow admin to set timeout duration (in seconds)
if (session_status() == PHP_SESSION_NONE) {
    $admin_timeout = 2592000; // 30 days. 7 days = 604800
	// this is a lot more user friendly. Stays logged in if user does not log out, for up to 30 days.

    if (isset($_POST['remember_me'])) {
        $admin_timeout = 30 * 24 * 60 * 60; // 30 days
    } else {
        $admin_timeout = 2 * 60 * 60; // 2 hours
    }

    ini_set('session.gc_maxlifetime', $admin_timeout);
    session_set_cookie_params($admin_timeout);
    session_start();
    $_SESSION['EXPIRES'] = time() + $admin_timeout;
}

if (isset($_SESSION['user_id'])) {
    $current_time = time();
    
    // Check if session has expired
    if ($current_time > $_SESSION['EXPIRES']) {
        $_SESSION['REDIRECT_URL'] = $_SERVER['REQUEST_URI'];
        session_unset();
        session_destroy();
        header("Location: /login.php");
        exit();
    }
    
    if (!isset($_SESSION['LAST_EXPIRATION_CHECK']) || ($current_time - $_SESSION['LAST_EXPIRATION_CHECK'] > 86400)) {
        // Check license expiration
        $stmt = $pdo->prepare("SELECT expiration_date FROM licenses WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $license = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($license && strtotime($license['expiration_date']) < $current_time) {
            $_SESSION['REDIRECT_URL'] = $_SERVER['REQUEST_URI'];
            session_unset();
            session_destroy();
            header("Location: /login.php?expired=1");
            exit();
        }
        
        $_SESSION['LAST_EXPIRATION_CHECK'] = $current_time;
    }
    
    $_SESSION['LAST_ACTIVITY'] = $current_time;
    $_SESSION['EXPIRES'] = $current_time + $admin_timeout;
}

/*******************************************************************
POTENTIAL FUTURE ADDITION: SAVE STATE. WE WILL ALSO NEED TO ADD A DATABASE COLUMN. ADDITIONALLY, TO RESUME WE'LL NEED TO SAVE MORE STATE. 
********************************************************************
// Exit case handler
function handleCaseExit() {
    if (isset($_SESSION['current_case'])) {
        // Clear current case
        unset($_SESSION['current_case']);
        
        // Log case exit if needed
        if (isset($_SESSION['front_user_id'])) {
            $stmt = $pdo->prepare("UPDATE user_cases SET active = 0, exited_at = NOW() WHERE user_id = ? AND active = 1");
            $stmt->execute([$_SESSION['front_user_id']]);
        }
    }
}

// Add case termination on logout
if (isset($_GET['logout'])) {
    handleCaseExit();
}
**********************************************************************/