<?php
// header.php
// error_reporting(E_ALL);
// ini_set('display_errors', 1);
// require_once $_SERVER['DOCUMENT_ROOT'] . '/.sys/wp-load.php'; // for auth using wp as headless
// require_once 'config.php';
require_once 'includes/include_all.inc.php';

// Enhanced cache invalidation protocol for immediate state refresh
if (isset($_SESSION['clear_cache']) && $_SESSION['clear_cache'] === true) {
    // Clear the flag so it only runs once
    unset($_SESSION['clear_cache']);
    
	// Method 7B - localStorage/sessionStorage + redirect cycle (production stable)
    echo '<!DOCTYPE html>
    <html>
    <head>
        <title>' . SITE_TITLE . '</title>
        <script>
            // Clear browser storage
            localStorage.clear();
            sessionStorage.clear();
            
            // Reset user status
            window.userStatus = null;
            
            // Immediately redirect back to the same page
            window.location.replace(window.location.href);
        </script>
    </head>
    <body></body>
    </html>';
    exit;
}

// set home
$is_home = ($_SERVER['REQUEST_URI'] === '/' || $_SERVER['SCRIPT_NAME'] === '/index.php');

// required to show profile picture in header
require_once 'includes/profile_functions.php';

// pro api
include ($_SERVER['DOCUMENT_ROOT'] . '/api/pro_features.php');
// new case switcher
require_once ($_SERVER['DOCUMENT_ROOT'] . '/api/case_management.php');
	
/* required to show menu */
require_once 'menu.php';


// Check if user is logged in
if (!isset($_SESSION['front_user_id'])) {
    // User is not logged in, redirect to login page
    header('Location: login');
    exit;
    
	// demo check
    if (isDemoUser($userId)) {
        restrictDemoFeatures();
        
        // Display demo notice
        echo '<div class="demo-notice">You are using a demo account.</div>';
    }
}

// Detect user switching and force a complete reload
if (isset($_SESSION['front_user_id'])) {
    if (!isset($_SESSION['last_user_id']) || $_SESSION['last_user_id'] !== $_SESSION['front_user_id']) {
        // Store current user as last user
        $_SESSION['last_user_id'] = $_SESSION['front_user_id'];
        
        // Set cache control headers
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Pragma: no-cache");
        header("Expires: 0");
        
        // Force a complete reload with a redirect
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }
}

$userDetails = menuUserDetails($_SESSION['front_user_id']);
// $profilePicUrl = getProfilePictureUrl($_SESSION['front_user_id']);
// $user = getUserDetails($_SESSION['front_user_id']);

function getUserDetails($userId) {
    global $pdo;
    $table_name = PREFIX . 'users';
    
    $stmt = $pdo->prepare("SELECT * FROM $table_name WHERE ID = ?");
    $stmt->execute([$userId]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function getUserDetailsWithProStatus($userId) {
    global $pdo;
    $users_table = PREFIX . 'users';
    $groups_table = PREFIX . 'groups';

    // Fetch user details along with group details
	$stmt = $pdo->prepare("SELECT u.*, g.pro_status AS group_pro_status, g.pro_expiration_date AS group_pro_expiration_date 
						   FROM $users_table u 
						   LEFT JOIN $groups_table g ON u.group_id = g.id 
						   WHERE u.ID = ?");
    $stmt->execute([$userId]);
    $userDetails = $stmt->fetch(PDO::FETCH_ASSOC);

    // Log retrieved values for debugging
	/* 
    echo "<script>console.log('User Group ID: " . ($userDetails['user_group'] ?? 'No user group') . "');</script>";
    echo "<script>console.log('Group Pro Status: " . ($userDetails['group_pro_status'] ?? 'No group status') . "');</script>";
    echo "<script>console.log('Group Pro Expiration Date: " . ($userDetails['group_pro_expiration_date'] ?? 'No group expiration date') . "');</script>";
	*/

    // Determine final pro status
    $status = 'No';
    if ($userDetails) {
        if ($userDetails['pro_status'] === 'Pro' || $userDetails['group_pro_status'] === 'Pro') {
            $status = 'Pro';
        }
    }

    // Set expiration based on group expiration date
    $expiration = $userDetails['group_pro_expiration_date'] ?: '';

    return [
        'userDetails' => $userDetails,
        'status' => $status,
        'expiration' => $expiration,
    ];
}

// Usage
$userDetailsPro = getUserDetailsWithProStatus($_SESSION['front_user_id']);

// Prepare data to pass to JavaScript
$status = $userDetailsPro['status'] ?? '';
$expiration = $userDetailsPro['expiration'] ?? '';
?>
<!DOCTYPE html>
<html lang="en" class="dark-theme">
<head>
	<script src="js/perf.js" type="application/javascript" ></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_TITLE; ?></title>
	<script>
		// Immediately execute theme detection
		(function() {
			function getCookie(name) {
				const nameEQ = name + "=";
				const ca = document.cookie.split(';');
				for(let i = 0; i < ca.length; i++) {
					let c = ca[i];
					while (c.charAt(0) === ' ') c = c.substring(1, c.length);
					if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
				}
				return null;
			}
			
			const savedTheme = getCookie('theme');
			if (savedTheme === 'light') {
				document.documentElement.classList.add('light-theme');
			}
		})();
	</script>

    <meta name="description" content="<?php echo SITE_DESCRIPTION; ?>">
    <meta name="keywords" content="<?php echo SITE_KEYWORDS; ?>">
    <meta name="author" content="<?php echo COMPANY_NAME; ?>">

    <meta property="og:title" content="<?php echo SITE_TITLE; ?>">
    <meta property="og:description" content="<?php echo SITE_DESCRIPTION; ?>">
    <meta property="og:image" content="<?php echo MYSITE_URL; ?>/images/og-image.jpg">
    <meta property="og:url" content="<?php echo MYSITE_URL; ?>">
    <meta property="og:type" content="website">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo SITE_TITLE; ?>">
    <meta name="twitter:description" content="<?php echo SITE_DESCRIPTION; ?>">
    <meta name="twitter:image" content="<?php echo MYSITE_URL; ?>/images/twitter-image.jpg">

	<link rel="icon" href="/images/icons/favicon.png" type="image/png">
    <link rel="apple-touch-icon" sizes="180x180" href="/images/icons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/images/icons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/images/icons/favicon-16x16.png">
    <link rel="manifest" href="/configs/site.webmanifest">

    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#ffffff">
	
	<link rel="stylesheet" href="css/loader.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
	<?php if (defined('IS_DEV') && IS_DEV) {
		echo '<link rel="stylesheet" href="css/dev.css">';
	} ?>
    <link rel="stylesheet" href="app/styles/anesthsim.css">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Kadwa:wght@400;700&display=swap" rel="stylesheet">

	<script src="js/screen-warning.js" type="application/javascript" defer></script>
	<script>
	window.userStatus = "<?php echo $status; ?>";
	// Clear any cached case access data
	if (window.CaseData) {
		// Reset any cached permissions
		for (const caseId in window.CaseData) {
			if (window.CaseData.hasOwnProperty(caseId)) {
				window.CaseData[caseId].accessChecked = false;
			}
		}
	}
	</script>
	<script>window.userExpiration = "<?php echo $expiration; ?>";</script>
	<script>mainUrl = "<?php echo MAINSITE_URL; ?>";</script>
	<script>appUrl = "<?php echo DOCUMENT_ROOT; ?>";</script>
	
	<script src="app/scripts/prototype.js" type="application/javascript"></script>		
	<!-- script src="app/scripts/iscroll-lite.js" type="application/javascript" defer></script   was -->    
	<script src="app/scripts/AboutAnesthSim7.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/AnesthCode.js?v=4" type="application/javascript" defer></script>
	<script src="app/scripts/Default.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/DrugInfo.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/IvAdmin.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/ModelsAndFsm.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/Recorder.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/UserControl.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<script src="app/scripts/Waveform.js?v=<?php echo date('YmdHis'); ?>" type="application/javascript" defer></script>
	<?php /* was case files now cases_updated */ ?>
	<script src="app/cases_updated/Anesth6Case1.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case2.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case3.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case4.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case5.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case6.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case7.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case8.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case9.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case10.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case11.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case12.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case13.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case14.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case15.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case16.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case17.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case18.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case19.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case20.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case21.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case22.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case23.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case24.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case25.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case26.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case27.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case28.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case29.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case30.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case31.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case32.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case33.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case34.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case35.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case36.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case37.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case38.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case39.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case40.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case100.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case101.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case102.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case103.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case104.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case105.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case106.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case107.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case108.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case109.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case110.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case111.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case112.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case113.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case114.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case115.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case116.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case117.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case118.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case119.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case120.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case121.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case122.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case123.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case124.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case125.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case126.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case127.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case128.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case129.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case130.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case131.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case132.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case133.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case134.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case135.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case136.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case137.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case138.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	<script src="app/cases_updated/Anesth6Case139.js?v=<?php echo date('YmdHis'); ?>" type="text/javascript" defer></script>
	
	<?php /* was hemoWaveform files */ ?>
	<script src="app/hemoWaveforms/afib6_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/asyst1_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus1_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus2_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus3_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus4_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus5_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus6_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/sinus6_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st1_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st2_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_30.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_40.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_50.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_60.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_70.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_80.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_90.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_100.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_120.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_140.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/st3_160.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/vfib2_20.js" type="text/javascript" defer></script>
	<script src="app/hemoWaveforms/vtach3_140.js" type="text/javascript" defer></script>
	
	<?php /* respWaveform files */ ?>
	<script src="app/respWaveforms/hump_4.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_6.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_8.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_10.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_12.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_15.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_20.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/hump_30.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_4.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_6.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_8.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_10.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_12.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_15.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_20.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/nl_30.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_4.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_6.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_8.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_10.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_12.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_15.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_20.js" type="text/javascript" defer></script>
	<script src="app/respWaveforms/slant_30.js" type="text/javascript" defer></script>
	
	<?php /* sound files */ ?>
	<link src="app/sounds/pulseOx.wav" type="audio/wav"></link>
	<link src="app/sounds/po100.wav" type="audio/wav"></link>
	<link src="app/sounds/po99.wav" type="audio/wav"></link>
	<link src="app/sounds/po98.wav" type="audio/wav"></link>
	<link src="app/sounds/po97.wav" type="audio/wav"></link>
	<link src="app/sounds/po96.wav" type="audio/wav"></link>
	<link src="app/sounds/po95.wav" type="audio/wav"></link>
	<link src="app/sounds/po94.wav" type="audio/wav"></link>
	<link src="app/sounds/po93.wav" type="audio/wav"></link>
	<link src="app/sounds/po92.wav" type="audio/wav"></link>
	<link src="app/sounds/po91.wav" type="audio/wav"></link>
	<link src="app/sounds/po90.wav" type="audio/wav"></link>
	<link src="app/sounds/po89.wav" type="audio/wav"></link>
	<link src="app/sounds/po88.wav" type="audio/wav"></link>
	<link src="app/sounds/po87.wav" type="audio/wav"></link>
	<link src="app/sounds/po86.wav" type="audio/wav"></link>
	<link src="app/sounds/po85.wav" type="audio/wav"></link>
	<link src="app/sounds/po84.wav" type="audio/wav"></link>
	<link src="app/sounds/po83.wav" type="audio/wav"></link>
	<link src="app/sounds/po82.wav" type="audio/wav"></link>
	<link src="app/sounds/po81.wav" type="audio/wav"></link>
	<link src="app/sounds/po80.wav" type="audio/wav"></link>
	<link src="app/sounds/po79.wav" type="audio/wav"></link>
	<link src="app/sounds/po78.wav" type="audio/wav"></link>
	<link src="app/sounds/po77.wav" type="audio/wav"></link>
	<link src="app/sounds/po76.wav" type="audio/wav"></link>
	<link src="app/sounds/po75.wav" type="audio/wav"></link>
	<link src="app/sounds/po74.wav" type="audio/wav"></link>
	<link src="app/sounds/po73.wav" type="audio/wav"></link>
	<link src="app/sounds/po72.wav" type="audio/wav"></link>
	<link src="app/sounds/po71.wav" type="audio/wav"></link>
	<link src="app/sounds/po70.wav" type="audio/wav"></link>
	<link src="app/sounds/po69.wav" type="audio/wav"></link>
	<link src="app/sounds/po68.wav" type="audio/wav"></link>
	<link src="app/sounds/po67.wav" type="audio/wav"></link>
	<link src="app/sounds/po66.wav" type="audio/wav"></link>
	<link src="app/sounds/po65.wav" type="audio/wav"></link>
	<link src="app/sounds/po64.wav" type="audio/wav"></link>
	<link src="app/sounds/po63.wav" type="audio/wav"></link>
	<link src="app/sounds/po62.wav" type="audio/wav"></link>
	<link src="app/sounds/po61.wav" type="audio/wav"></link>
	<link src="app/sounds/po60.wav" type="audio/wav"></link>
	<link src="app/sounds/po59.wav" type="audio/wav"></link>
	<link src="app/sounds/po58.wav" type="audio/wav"></link>
	<link src="app/sounds/po57.wav" type="audio/wav"></link>
	<link src="app/sounds/po56.wav" type="audio/wav"></link>
	<link src="app/sounds/po55.wav" type="audio/wav"></link>
	<link src="app/sounds/po54.wav" type="audio/wav"></link>
	<link src="app/sounds/po53.wav" type="audio/wav"></link>
	<link src="app/sounds/po52.wav" type="audio/wav"></link>
	<link src="app/sounds/po51.wav" type="audio/wav"></link>
	<link src="app/sounds/po50.wav" type="audio/wav"></link>
	<link src="app/sounds/po49.wav" type="audio/wav"></link>
	<link src="app/sounds/po48.wav" type="audio/wav"></link>
	<link src="app/sounds/po47.wav" type="audio/wav"></link>
	<link src="app/sounds/po46.wav" type="audio/wav"></link>
	<link src="app/sounds/po45.wav" type="audio/wav"></link>
	<link src="app/sounds/po44.wav" type="audio/wav"></link>
	<link src="app/sounds/po43.wav" type="audio/wav"></link>
	<link src="app/sounds/po42.wav" type="audio/wav"></link>
	<link src="app/sounds/po41.wav" type="audio/wav"></link>
	<link src="app/sounds/po40.wav" type="audio/wav"></link>

</head>
<body>
<div id="screen-warning-root"></div>
<?php if (defined('IS_DEV') && IS_DEV) { echo '<div id="devsite"><span>Dev Site</span></div>'; } ?>
<div id="divErrorScreen" style="display:block">
    <div id="loader-container">
        <div id="loader-animate"></div>
        <div id="loader-text"><?php echo SITE_TITLE; ?> is loading</div>
    </div>
	<?php /* <div>Loading... Use a modern browser like:</div>
	<div>Brave, Chrome, Firefox, or Safari to</div> 
	<div>run <?php echo SITE_TITLE; ?>.</div> */ ?>
</div>
<script src="js/loader.js" type="text/javascript" ></script>

<?php /* if (hasProfilePicture($current_user['id'])): echo '<img src="' . getProfilePictureUrl($current_user['id']); . '" alt="Profile Picture" class="profile-picture">'; endif; */ ?>
	<div class="top-menu">
		<div class="logo">
			<a href="<?php echo MYSITE_URL; ?>"><img src="<?php echo MYSITE_URL; ?>/images/logo/logo-new-dark.png" title="<?php echo COMPANY_NAME; ?>">
			<?php /* <i class="fas fa-hospital"></i> &nbsp; <span><?php echo COMPANY_NAME; ?></span> */ ?></a>
		</div>
		<div class="center-title"><?php echo SITE_TITLE; ?></div>
			
		<div class="user-menu">
			<div class="my-account" id="my-account">
				<span>My Account</span>
				<div class="profile-picture-container">
					<?php
				$userId = $_SESSION['front_user_id'];

				if (function_exists('getProfilePictureUrl2')) {
					$profile_picture_data = getProfilePictureUrl2($userId);
					
					if ($profile_picture_data && isset($profile_picture_data->unique_id) && isset($profile_picture_data->profile_picture)) {
						$profile_picture_url = '/images/profiles/' . $profile_picture_data->unique_id . '/' . $profile_picture_data->profile_picture;
						echo '<img src="' . htmlspecialchars($profile_picture_url) . '" alt="Profile Picture" class="profile-picture">';
					} else {
						echo '<div class="icon-circle"><i class="fas fa-user-circle"></i></div>';
					}
				} else {
					echo '<div class="icon-circle"><i class="fas fa-user-circle"></i></div>';
				}
					?>
				</div>
			</div>
			
			<div class="my-settings" id="my-settings">
				<i class="fas fa-cog"></i><span>Settings</span>
			</div>
		</div>
	</div>

	<div class="second-top-bar">
		<div class="timer-score">
			<button id="toggle-sidebar" class="toggle-sidebar"><i class="fas fa-bars"></i></button>
			<div class="timer" id="btnTime">00:00:00</div> <!-- was 00:00:07  -->
			<div class="score" id="txtScore">Score: 0</div><!-- was 0/1000  -->
			<button class="action-button cases showCasesList"><div class="icon-circle"><i class="fas fa-folder"></i></div> View Cases</button>
			<button class="action-button preop" id="btnPreop" onclick="handleButtonClick('preop')"><div class="icon-circle"><i class="fas fa-clipboard-user"></i></div> PreOp</button> <!-- was preop fa-procedures -->
			<button class="action-button case-help" id="btnCaseHelp" onclick="handleButtonClick('case-help')"><div class="icon-circle"><i class="fas fa-question-circle"></i></div> Case Help</button>
			<button class="action-button case-log" id="btnCaseLog" onclick="handleButtonClick('case-log')"><div class="icon-circle"><i class="fas fa-file-medical"></i></div> Case Log</button>
		</div>
		<div class="action-buttons">
			<button class="action-button new-case"><div class="icon-circle"><i class="fas fa-plus-circle"></i></div> New Case</button>
		</div>
	</div>

	<div class="menu" id="my-settings-menu">
		<div class="my-account-menu my-account-menu-left">
			<h3 class="settings-menu-title">Settings</h3>
			<ul>
				<li class="settings-toggles theme-toggle" id="theme-toggle">
				  <i class="fas fa-moon"></i>
				  <span class="label">Theme:</span>
				  <div class="toggle-options">
					<button class="toggle-option active" data-value="dark">Dark</button>
					<button class="toggle-option" data-value="light" style="border: none;">Light</button>
				  </div>
				</li>
				
				<li class="settings-toggles photo-toggle" id="photo-toggle">
				  <i class="fas fa-image"></i>
				  <span class="label">Images:</span>
				  <div class="toggle-options">
					<button class="toggle-option active" data-value="photo">Photo</button>
					<button class="toggle-option" data-value="gallery">Stylized</button>
				  </div>
				</li>
				<li class="settings-toggles colors-toggle" id="colors-toggle">
					<i class="fas fa-palette"></i>
					<span class="label">Colors:</span>
					<span class="toggle-option us-color">US <i class="flag-us"></i></span> 
					<span class="toggle-option iso-color">ISO <i class="flag-eu">
					  <span class="star" style="--i:0;"></span>
					  <span class="star" style="--i:2;"></span>
					  <span class="star" style="--i:4;"></span>
					  <span class="star" style="--i:6;"></span>
					  <span class="star" style="--i:8;"></span>
					  <span class="star" style="--i:10;"></span>
					</i></span>
				</li>
				<li class="settings-toggles sound-toggle" id="sound-toggle">
				  <i class="fas fa-volume-up"></i>
				  <span class="label">Sound:</span>
				  <span class="status-text">On</span>
				  <label class="sound-toggle-switch">
					<input type="checkbox" id="sound-checkbox" name="sound-checkbox" checked="">
					<span class="slider round"></span>
				  </label>
				</li>
				<?php if ($userDetails['is_super']) { ?>
					<li class="settings-toggles session-toggle" id="session-toggle">
						<i class="fas fa-play"></i>
						<span class="label">Session Termination:</span>
						<span class="session-text">On</span>
					</li>
				<?php } ?>
			</ul>
		</div>
	</div>
	
	<div class="menu" id="my-account-menu">
		<div class="my-account-menu">
			<ul>
				<div class="just-info-outer">
					<li class="just-info">
					  <div class="text-wrapper">
						<div class="inner-text" data-text="<?php echo htmlspecialchars($userDetails['first_name'] . ' ' . $userDetails['last_name']); ?>"><?php echo htmlspecialchars($userDetails['first_name'] . ' ' . $userDetails['last_name']); ?></div>
					  </div>
					  <span class="info-mark"><i class="fa fa-info"></i><span class="info-tag">Name</span></span>
					</li>
					<li class="just-info">
					  <div class="text-wrapper text-wrapper-email">
						<div class="inner-text" data-text="<?php echo htmlspecialchars($userDetails['email']); ?>"><?php echo htmlspecialchars($userDetails['email']); ?></div>
					  </div>
					  <i class="fas fa-copy copy-icon copy-icon-email" style="display: none;"></i>
					  <span class="info-mark"><i class="fa fa-info"></i><span class="info-tag">Email</span></span>
					</li>
					<li class="just-info">
					  <div class="text-wrapper">
						<div class="inner-text-group"><?php echo htmlspecialchars($userDetails['group']); ?></div>
					  </div>
					  <span class="info-mark"><i class="fa fa-info"></i><span class="info-tag">Group</span></span>
					</li>
					<?php if ($userDetails['is_admin'] == 1) {?>
						<li class="just-info user-type-menu">Administrator
							<span class="info-mark"><i class="fa fa-info"></i>
								<span class="info-tag">User Role</span>
							</span>
						</li>
					<?php } 
						$modalContent = json_decode(file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/app/modal_data/modal-content.json'), true);
						$statusText = $modalContent['proModal']['statusText'] ?? [];
					?>
					<li class="pro-button">
						<a href="#" id="proButton" data-status="<?php echo htmlspecialchars($status); ?>" data-expiration="<?php echo htmlspecialchars($expiration); ?>">
							<?php 
								if (isProFeatureEnabled('additional_cases')) {
									echo $statusText['Pro'] ?? 'Pro Active';
								} else {
									echo $statusText['Upgrade'] ?? 'Upgrade to Pro';
								}
							?>
						</a>
					</li>
				</div>
				
				<?php if ($userDetails['is_super']) { ?>
					<li class="admin-dash-btn">
						<i class="fas fa-tachometer-alt"></i>
						<a href="admin">Super Admin Dashboard</a>
					</li>
				<?php } else if ($userDetails['is_owner']) { ?>
					<li class="admin-dash-btn">
						<i class="fas fa-tachometer-alt"></i>
						<a href="admin">Admin Dashboard</a>
					</li>
				<?php } ?>
				
				<hr>
				
				<a href="/cases">
					<li class="my-settings-btn view-my-cases">
						<i class="fas fa-folder-open"></i>
						<span>View My Cases</span>
					</li>
				</a>
				
				<hr>

				<?php /* <li class="my-profile-menu-title">
					<span>My Settings</span>
				</li> */ ?>
				
				<a href="/profile">
					<li class="my-settings-btn view-my-settings">
						<i class="fas fa-folder"></i>
						<span>My Profile</span>
					</li>
				</a>
				
				<?php /* <li class="my-settings-btn change-my-settings">
					<i class="fas fa-cog"></i>
					<span>Change Profile Name</span>
				</li>
				<li class="change-profile-picture">
					<i class="fas fa-camera"></i>
					<span>Change Profile Picture</span>
				</li>
				
				<hr> */ ?>
				
				<a href="<?php echo MAINSITE_URL; ?>/contact" target="_blank">
					<li class="help-item">
						<i class="fas fa-question-circle"></i>
						<span>Help</span>
					</li>
				</a>
				<a href="<?php echo MAINSITE_URL; ?>/contact" target="_blank">
					<li class="feedback-item">
						<i class="fas fa-comment"></i>
						<span>Feedback</span>
					</li>
				</a>

				<?php if ($isLoggedIn) {
					echo '<a class="logout" href="logout.php">Log Out</a>';
				} else {
					echo '<a class="logout" href="login.php">Log In</a>';
				} ?>
			</ul>
		</div>
	</div>

	<div id="profilePictureModal" class="modal">
		<div class="modal-content">
			<span class="close">&times;</span>
			<h2>Change Profile Picture</h2>
			<form id="profilePictureForm" enctype="multipart/form-data">
				<input type="file" name="profile_picture" id="profile_picture" accept=".jpg,.jpeg,.png,.gif">
				<button type="submit">Upload</button>
			</form>
			<?php
			echo "<?php /* Debug: Checking for existing profile picture */ ?>";
			$userId = $_SESSION['front_user_id'];
			if (function_exists('getProfilePictureUrl2')) {
				$profile_picture_data = getProfilePictureUrl2($userId);
				if ($profile_picture_data && isset($profile_picture_data->unique_id) && isset($profile_picture_data->profile_picture)) {
					$profile_picture_url = '/images/profiles/' . $profile_picture_data->unique_id . '/' . $profile_picture_data->profile_picture;
					echo '<p>Current profile picture:</p>';
					echo '<img src="' . htmlspecialchars($profile_picture_url) . '" alt="Current Profile Picture" style="max-width: 200px;">';
					echo '<button id="removeProfilePicture">Remove Profile Picture</button>';
				} else {
					echo '<p>No current profile picture.</p>';
				}
			} else {
				echo '<p>Unable to retrieve profile picture information.</p>';
			}
			?>
		</div>
	</div>

	<?php /* alternate pro status modal *************
	<div id="proStatusModal" class="modal" style="display: none;">
		<div class="modal-content">
			<span class="close">&times;</span>
			<h2 id="proStatus"></h2>
			<p id="proExpiration"></p>
			<ul id="proFeatures"></ul>
			<a id="proAction" href="#" class="button"></a>
		</div>
	</div>
	******************************************* */ ?>
			
	<div id="proStatusModal" class="modal" style="display: none;">
		<div class="modal-content">
			<span class="close">&times;</span>
			<h2 id="proStatus"></h2>
			<p id="proExpiration"></p>
			<ul id="proFeatures"></ul>
			<button class="upgradeYes">Yes, Upgrade</button>
			<button class="upgradeNo">No, Thanks</button>
		</div>
	</div>

	<div id="upgradeModal" class="modal" style="display: none;">
		<div class="modal-content">
			<h2 id="modalTitle"></h2>
			<p id="modalMessage"></p>
			<button id="upgradeYes">Upgrade Now</button>
			<button id="upgradeNo">Cancel</button>
		</div>
	</div>
	
	<div id="exitWarningModal" class="modal" style="display: none;">
		<div class="modal-content">
			<h2>Exit Current Case</h2>
			<p>Would you like to save your case progress before leaving?</p>
			<button id="saveAndExitBtn" class="saveExit">Save &amp; Exit</button>
			<button id="exitWithoutSaveBtn" class="continueExit">Exit Without Saving</button>
			<button id="cancelExitBtn" class="cancelExit">Cancel</button>
		</div>
	</div>


<div class="mainContentSection" id="divFullScreen" style="display:none">
  <div id="divMenu">
	<div class="sidebar" id="sidebar"> <!-- was airway fa-wind, labs fa-vials, surgeon fa-user-md -->
		<?php
		$sidebarItems = [
			'patient' => ['icon' => 'fas fa-bed-pulse', 'text' => 'Patient'],
			'monitors' => ['icon' => 'fas fa-heartbeat', 'text' => 'Monitors'],
			'airway' => ['icon' => 'fas fa-mask-ventilator', 'text' => 'Airway'],
			'breathing' => ['icon' => 'fas fa-lungs', 'text' => 'Breathing'],
			'drugs' => ['icon' => 'fas fa-syringe', 'text' => 'Drugs'],
			'fluids' => ['icon' => 'fas fa-tint', 'text' => 'Fluids'],
			'labs' => ['icon' => 'fas fa-vial-circle-check', 'text' => 'Labs'],
			'surgeon' => ['icon' => 'fas fa-head-side-mask', 'text' => 'Surgeon'],
			'resuscitate' => ['icon' => 'fas fa-medkit', 'text' => 'Resuscitate'],
		];
		foreach ($sidebarItems as $key => $item):
		?>
		<a class="sidebar-button sidebar-<?php echo $key; ?> <?php if ($key == 'disabled') echo 'disabled'; ?>" id="btn<?php echo ucfirst($key); ?>" href="#" onclick="return handleSidebarClick('<?php echo $key; ?>')">
			<div class="icon-circle"><i class="<?php echo $item['icon']; ?>"></i></div>
			<span><?php echo $item['text']; ?></span>
			<div class="info-show"><b><?php echo $item['text']; ?></b> View and manage <?php echo strtolower($item['text']); ?> information</div>
			
			<?php if ($key == 'disabled'): ?>
				<span class="disabled-tooltip">Please select a case first</span>
			<?php endif; ?>
		</a>
		<?php endforeach; ?>

	</div>

  </div>
	
