<?php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');

// Set content type to JSON
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["error" => "Invalid request method."]);
    exit();
}

// Read the raw POST data from the input stream
$inputData = file_get_contents("php://input");

// Convert JSON data to an associative array
$data = json_decode($inputData, true);

// Log incoming data for debugging
$logMessages = [];
$logMessages[] = 'Raw POST Data: ' . $inputData;

if (empty($data)) {
    $logMessages[] = 'Decoded POST Data: []';
    echo json_encode([
        "error" => "Invalid request. No data provided.",
        "logs" => $logMessages
    ]);
    exit();
}

// Check if session or expected fields are missing
if (!isset($_SESSION['front_user_id'])) {
    $logMessages[] = 'Session not set. User not logged in.';
    echo json_encode([
        "error" => "Invalid request. User session not available.",
        "logs" => $logMessages
    ]);
    exit();
}

// Extract session and case data
$userId = $_SESSION['front_user_id'];
$caseLog = isset($data['caseLog']) ? $data['caseLog'] : '';

// Log case data for debugging
$logMessages[] = 'Case Log: ' . $caseLog;

// Extract grade and score from text within caseLog (assuming you're extracting these)
$caseGrade = isset($data['grade']) ? $data['grade'] : 'Unknown';
preg_match('/(-?\d+\s*\/\s*\d+)/', $caseLog, $scoreMatches); // Use $caseLog instead of $userData
$caseScore = isset($scoreMatches[0]) ? $scoreMatches[0] : '';

// Log grade and score
$logMessages[] = 'Grade: ' . $caseGrade;
$logMessages[] = 'Score: ' . $caseScore;

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Insert data into wp_groupusers_data table
    $stmt = $pdo->prepare("
        INSERT INTO wp_groupusers_data 
        (user_id, user_data, case_grade, case_score, datetime, instructor_notes) 
        VALUES (:user_id, :case_log, :case_grade, :case_score, NOW(), :instructor_notes)
    ");

    $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $stmt->bindParam(':case_log', $caseLog, PDO::PARAM_STR);
    $stmt->bindParam(':case_grade', $caseGrade, PDO::PARAM_STR);
    $stmt->bindParam(':case_score', $caseScore, PDO::PARAM_STR);

    // Instructor notes are optional
    $instructorNotes = isset($data['instructor_notes']) ? $data['instructor_notes'] : null;
    $stmt->bindParam(':instructor_notes', $instructorNotes, PDO::PARAM_STR);

    $stmt->execute();

    // Success response
    echo json_encode([
        "success" => "Data saved successfully.",
        "logs" => $logMessages
    ]);

} catch (PDOException $e) {
    // Log PDO exception
    $logMessages[] = 'PDO Exception: ' . $e->getMessage();
    echo json_encode([
        "error" => "Database error occurred.",
        "logs" => $logMessages
    ]);
}
?>
