<?php
// File: /api/convert_cases_to_json.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$jsFiles = glob($_SERVER['DOCUMENT_ROOT'] . '/app/cases/Anesth6Case*.js');

foreach ($jsFiles as $jsFile) {
    $content = file_get_contents($jsFile);
    
    // Extract case data
    preg_match('/CaseData\[(\d+)\]\s*=\s*({[\s\S]*?});/', $content, $matches);
    
    if (isset($matches[1]) && isset($matches[2])) {
        $caseId = $matches[1];
        $caseData = $matches[2];
        
        // Convert JS object to PHP array
        $caseArray = json_decode(str_replace("'", '"', $caseData), true);
        
        if ($caseArray) {
            // Add id and isPro fields
            $caseArray['id'] = (int)$caseId;
            $caseArray['isPro'] = $caseId > 2; // Assume cases 3+ are Pro
            
            // Save as JSON
            $jsonFile = $_SERVER['DOCUMENT_ROOT'] . '/app/case_data/case_' . $caseId . '.json';
            file_put_contents($jsonFile, json_encode($caseArray, JSON_PRETTY_PRINT));
            
            echo "Converted $jsFile to $jsonFile\n";
        } else {
            echo "Failed to convert $jsFile\n";
        }
    }
}