<?php /** Administration Bootstrap */
// newuser.php
//session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

	//session_start();
	chdir('../');
	include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
	/* **************** HEADER FROM MAIN (REQUIRED FOR MENU) **************/
	include($_SERVER['DOCUMENT_ROOT'] . '/menu.php');
	$userDetails = menuUserDetails($_SESSION['front_user_id']);
	/* ***************** END HEADER FROM MAIN *****************************/

	// current page variable
	$current_page = 'newuser';

	try {
		$pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$obj_users = new Users($pdo);
	} catch(PDOException $e) {
		die("Connection failed: " . $e->getMessage());
	}

	$obj_users = new Users($pdo);
	
	if(!$obj_users->checkUserLoginOrNot()){
	    header('Location: '.BASEURL.'login.php');
	} 
	
	// Logout logic
	if (isset($_GET['logout'])) {
		// Destroy the session
		session_unset();
		session_destroy();
		header("Location: ../login.php"); // Redirect to the login page
		exit();
	}
	
	if($_SESSION['user_type']!='super' && $_SESSION['user_type']!='admin'){ 
		session_destroy();
		header('Location: '.BASEURL.'login.php');
		exit();
	}
	
	if($_SESSION['user_type'] == 'super') {
	    $usertype = 'super';
	} else if($_SESSION['user_type'] == 'admin') {
	    $usertype = 'admin';
	}


// Make sure Group class is available
if (!class_exists('Group')) {
    $groupClassFile = ROOT_PATH . '/classes/group/Group.class.php';
    if (file_exists($groupClassFile)) {
        require_once $groupClassFile;
    } else {
        die("Error: Group.class.php file not found");
    }
}

//Call group class
if (class_exists('Group')) {
    $obj_group = new Group($pdo);
} else {
    die("Error: Group class not found");
}

$groupid = isset($_POST['selected_group']) ? $_POST['selected_group'] : null;

$message = ''; // Initialize message variable at the top of your PHP code

if(isset($_POST['submit'])){
	// var_dump($_POST['selected_group']);
    // $groupda = $obj_group->fetchGroupById($_POST['selected_group']);
    // var_dump($groupda);
    // die();
	
    // Initialize at start
    $message = '';

    // Validate form inputs
    if (empty($_POST['user_email']) || empty($groupid)) {  // Use $groupid here
        $message = "Email and Group are required.";
    } else {
        $groupda = $obj_group->fetchGroupById($groupid);  // Use $groupid here
        
		if ($groupda) {
			$date = date('Y-m-d h:i:s');
			
			// Set default password from group
			$user_pass = $groupda['group_pass'];
			$user_pass_clear = $groupda['group_pass_clear'];
			
			// Override with custom password if provided
			if (!empty($_POST['group_pass'])) {
				$custom_pass = trim($_POST['group_pass']);
				$salt = sha1(md5($custom_pass));
				$user_pass = md5($custom_pass . $salt);
				$user_pass_clear = $custom_pass;
			}
			
			try {
				$stmt = $pdo->prepare("INSERT INTO wp_users
					(first_name, last_name, user_email, user_login, user_nicename, display_name, user_pass, user_pass_clear, user_status, group_id, user_group, user_url, user_registered, pro_status) 
					VALUES (:fname, :lname, :email, :login, :nicename, :display, :pass, :pass_clear, :status, :group_id, :user_group, :url, :registered, 'No')");
				
				$result = $stmt->execute([
					':fname' => $_POST['first_name'],
					':lname' => $_POST['last_name'],
					':email' => $_POST['user_email'],
					':login' => $_POST['user_login'],
					':nicename' => $_POST['user_login'],
					':display' => $_POST['user_login'],
					':pass' => $user_pass,
					':pass_clear' => $user_pass_clear,
					':status' => '1',
					':group_id' => $_POST['selected_group'],
					':user_group' => $groupda['group_name'],
					':url' => htmlspecialchars($_POST['user_url']),
					':registered' => $date
				]);

				if($result) {
					$_SESSION['message'] = "<h3>New user added successfully.</h3><br>" . 
						   "<b>Name:</b> " . htmlspecialchars($_POST['first_name']) . " " . htmlspecialchars($_POST['last_name']) . "<br>" . 
						   "<b>Email:</b> " . htmlspecialchars($_POST['user_email']) . "<br>" . 
						   "<b>Group:</b> " . htmlspecialchars($groupda['group_name']) . "<br>" .
						   "<b>Password:</b> " . htmlspecialchars($user_pass_clear) . "<br>";
					header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
					exit();
				} else {
					$message = "Failed to add new user.";
				}
			} catch(PDOException $e) {
				$message = "Insert failed: " . $e->getMessage();
			}
        } else {
            $message = "Error: Group not found";
        }
    }
}

// Check for message in session
if(isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
                                                           
/** get group name from db create group class object **/
    
$groups = $obj_group->fetchGroups();

include ($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');

?>

<?php /* ****************** BEGIN NEWUSER PAGE ********************/ ?>

<div class="wrap about-wrap">

	<div class="tabs">
	   <div class="tab users-tab">
		   <a class="tabslinks" href="index.php">Users</a>
	   </div>

	   <div class="tab data-tab">
		   <a class="tabslinks" href="data.php">Data</a>
	   </div>
	   
	   <div class="tab groups-tab">
		   <a class="tabslinks" href="groups.php">Groups</a>
	   </div>
	   
		<div class="tab newuser-tab">
		   <span class="currentlink">New User</span>

			<div class="content">
				<?php
				if (!empty($message)) {
					$messageClass = (strpos($message, 'successfully') !== false) ? 'success' : 'error';
					echo '<div class="alert-message ' . $messageClass . '">' . htmlspecialchars_decode($message) . '</div>';
				}
				?>
			   <h2>Create New User</h2><br>
				<form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
					<table class="home-table">
						<tr>
							<td class="newgrouplabel">
								<div class="newuser-firstname"><b>First Name:</b></div>
							</td>
							<td class="newgroupdata">
								<div class="newuser-firstname-input"><input id="first-name" name="first_name" type="text" /></div>
							</td>
						</tr>
						<tr>
							<td class="newgrouplabel">
								<div class="newuser-lastname"><b>Last Name:</b></div>
							</td>
							<td class="newgroupdata">
								<div class="newuser-lastname-input"><input id="last-name" name="last_name" type="text" /></div>
							</td>
						</tr>
						<tr>
							<td class="newgrouplabel">
								<div class="newuser-email"><b>Email:</b><span class="errortext">*</span></div>
							</td>
							<td class="newgroupdata">
								<div class="newuser-email-input"><input id="user-email" name="user_email" type="text" /></div>
								
							</td>
						</tr>
						<tr>
							<td class="newgrouplabel">
								<div class="newuser-group"><b>Group:</b><span class="errortext">*</span> </div>
							</td>
							<td class="newgroupdata">
								<div class="newuser-group-input">
									<!--<input id="user-group" name="user_group" type="text" />-->
									<select id="selected-group" name="selected_group">
										<option value="">Select Group</option>
										<?php if(!empty($groups)){
											foreach($groups as $groups_val){?>
												<option value="<?php echo $groups_val['id'];?>">
													<?php echo $groups_val['group_name'];?>
												</option>
										<?php }}?>
									</select>

                                </div>
							</td>
						</tr>
						<tr style="display: none;">
							<td class="newgrouplabel">
								<div class="newuser-username"><b>Username:</b><span class="errortext"></span></div>
							</td>
							<td class="newgroupdata">
								<div class="newuser-username-input"><input id="user-login" name="user_login" type="text" /></div>
							</td>
						</tr>
						<tr style="display: none;">
							<td class="newgrouplabel">					
								<div><b>Website:</b></div>
							</td>
							<td class="newgroupdata">
								<div><input id="user-url" name="user_url" type="text" /></div>
								
							</td>
						</tr>
						<tr>
							<td class="newgrouplabel">					
								<div><b>Custom Password (Optional):</b></div>
							</td>
							<td class="newgroupdata">
								<div><input id="user-pass" name="group_pass" type="password" /></div>
								<small>Leave blank to use group password</small>
							</td>
						</tr>
					</table>
					<div><input id="submit-button" value="submit" name="submit" type="submit" /></div>          
				</form>
			
		   </div> 
	   </div>
	   
		<div class="tab newgroup-tab">
		   <a class="tabslinks" href="newgroup.php">New Group</a>
	   </div>
	   
	   <div class="tab stats-tab">
		   <a class="tabslinks" href="statistics.php">Statistics</a>
	   </div>

	   <div class="tab ops-tab">
		   <a class="tabslinks" href="operations.php">Operations</a>
	   </div>
	</div>
	
</div>
<?php include ($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>
</body>
</html>