<?php
// admin/inc/update-user.php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_POST['userId'];
    
    // Fetch the current user data
    $stmt = $pdo->prepare("SELECT * FROM wp_users WHERE id = ?");
    $stmt->execute([$userId]);
    $currentUserData = $stmt->fetch(PDO::FETCH_ASSOC);

	// Check if this email belongs to another user already
	if (isset($_POST['userEmail']) && $_POST['userEmail'] !== $currentUserData['user_email']) {
		$stmt = $pdo->prepare("SELECT COUNT(*) FROM wp_users WHERE user_email = ? AND id != ?");
		$stmt->execute([$_POST['userEmail'], $userId]);
		$emailExists = $stmt->fetchColumn();
		
		if ($emailExists > 0) {
			echo json_encode(['success' => false, 'error' => 'This email is already in use by another user']);
			exit;
		}
	}

    if (!$currentUserData) {
        echo json_encode(['success' => false, 'error' => 'User not found']);
        exit;
    }

    // Prepare update data
    $updateData = [
        'user_email' => $_POST['userEmail'] ?? $currentUserData['user_email'],
        'first_name' => $_POST['firstName'] ?? $currentUserData['first_name'],
        'last_name' => $_POST['lastName'] ?? $currentUserData['last_name'],
        'user_group' => $_POST['userGroup'] ?? $currentUserData['user_group'],
        'user_type' => $_POST['userType'] ?? $currentUserData['user_type'],
        'group_id' => $_POST['userGroup'] ?? $currentUserData['group_id']
    ];

    // Get Demo group ID
    $stmt = $pdo->prepare("SELECT id FROM wp_groups WHERE group_name = 'Demo'");
    $stmt->execute();
    $demoGroupId = $stmt->fetchColumn();
    
    // Get Individuals group ID
    $stmt = $pdo->prepare("SELECT id FROM wp_groups WHERE group_name = 'Individuals'");
    $stmt->execute();
    $individualsGroupId = $stmt->fetchColumn();

    // Handle empty values
    foreach ($updateData as $key => $value) {
        if ($value === '') {
            $updateData[$key] = null;
        }
    }

    // Add extra update fields based on transitions
    $extraUpdates = [];
    $extraParams = [];

    // Demo group --> any group
    if ($currentUserData['group_id'] == $demoGroupId && $updateData['group_id'] != $demoGroupId) {
        // Get new group's password
        $stmt = $pdo->prepare("SELECT group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
        $stmt->execute([$updateData['group_id']]);
        $groupData = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $extraUpdates[] = "user_pass = :new_pass";
        $extraUpdates[] = "user_pass_clear = :new_pass_clear";
        $extraUpdates[] = "user_type = 'user'";
        $extraParams[':new_pass'] = $groupData['group_pass'];
        $extraParams[':new_pass_clear'] = $groupData['group_pass_clear'];
    }
    
    // When switching from any group to another group (including Individuals)
    else if ($currentUserData['group_id'] != $updateData['group_id']) {
        // Get new group's password
        $stmt = $pdo->prepare("SELECT group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
        $stmt->execute([$updateData['group_id']]);
        $groupData = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $extraUpdates[] = "user_pass = :new_pass";
        $extraUpdates[] = "user_pass_clear = :new_pass_clear";
        
        // If switching to Demo group
        if ($updateData['group_id'] == $demoGroupId) {
            $extraUpdates[] = "user_type = 'demo'";
            // Store previous group if not from Individuals
            if ($currentUserData['group_id'] != $individualsGroupId) {
                $extraUpdates[] = "previous_group = :prev_group";
                $extraParams[':prev_group'] = $currentUserData['group_id'];
            }
        }
        // If switching between non-Demo groups, update previous_group
        else if ($currentUserData['group_id'] != $individualsGroupId && $updateData['group_id'] != $individualsGroupId) {
            $extraUpdates[] = "previous_group = :prev_group";
            $extraParams[':prev_group'] = $currentUserData['group_id'];
        }
        // If switching FROM Individuals TO another group
        else if ($currentUserData['group_id'] == $individualsGroupId && $updateData['group_id'] != $individualsGroupId) {
            // Don't set previous_group as Individuals
            // This is intentional - we're not tracking Individuals as previous_group
        }
        
        $extraParams[':new_pass'] = $groupData['group_pass'];
        $extraParams[':new_pass_clear'] = $groupData['group_pass_clear'];
    }
    
    // Demo role --> User role
    else if ($currentUserData['user_type'] == 'demo' && $updateData['user_type'] == 'user') {
        // Check if there's a previous_group to return to
        if (!empty($currentUserData['previous_group'])) {
            // Use the previous group's data
            $stmt = $pdo->prepare("SELECT id, group_name, group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
            $stmt->execute([$currentUserData['previous_group']]);
            $prevGroupData = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($prevGroupData) {
                $extraUpdates[] = "user_pass = :prev_group_pass";
                $extraUpdates[] = "user_pass_clear = :prev_group_pass_clear";
                $extraUpdates[] = "group_id = :prev_group_id";
                $extraUpdates[] = "user_group = :prev_group_name";
                $extraUpdates[] = "previous_group = NULL"; // Clear previous_group
                
                $extraParams[':prev_group_pass'] = $prevGroupData['group_pass'];
                $extraParams[':prev_group_pass_clear'] = $prevGroupData['group_pass_clear'];
                $extraParams[':prev_group_id'] = $prevGroupData['id'];
                $extraParams[':prev_group_name'] = $prevGroupData['group_name'];
                
                // Update group_id in the main update data too
                $updateData['group_id'] = $prevGroupData['id'];
                $updateData['user_group'] = $prevGroupData['group_name'];
            } else {
                // Fallback to Individuals if previous group no longer exists
                $stmt = $pdo->prepare("SELECT group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
                $stmt->execute([$individualsGroupId]);
                $indivGroupData = $stmt->fetch(PDO::FETCH_ASSOC);
                
                $extraUpdates[] = "user_pass = :indiv_pass";
                $extraUpdates[] = "user_pass_clear = :indiv_pass_clear";
                $extraUpdates[] = "group_id = :indiv_group_id";
                $extraUpdates[] = "user_group = 'Individuals'";
                $extraUpdates[] = "previous_group = NULL"; // Clear previous_group
                
                $extraParams[':indiv_pass'] = $indivGroupData['group_pass'];
                $extraParams[':indiv_pass_clear'] = $indivGroupData['group_pass_clear'];
                $extraParams[':indiv_group_id'] = $individualsGroupId;
                
                // Update group_id in the main update data too
                $updateData['group_id'] = $individualsGroupId;
                $updateData['user_group'] = 'Individuals';
            }
        } else {
            // No previous group, default to Individuals
            $stmt = $pdo->prepare("SELECT group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
            $stmt->execute([$individualsGroupId]);
            $indivGroupData = $stmt->fetch(PDO::FETCH_ASSOC);
            
            $extraUpdates[] = "user_pass = :indiv_pass";
            $extraUpdates[] = "user_pass_clear = :indiv_pass_clear";
            $extraUpdates[] = "group_id = :indiv_group_id";
            $extraUpdates[] = "user_group = 'Individuals'";
            
            $extraParams[':indiv_pass'] = $indivGroupData['group_pass'];
            $extraParams[':indiv_pass_clear'] = $indivGroupData['group_pass_clear'];
            $extraParams[':indiv_group_id'] = $individualsGroupId;
            
            // Update group_id in the main update data too
            $updateData['group_id'] = $individualsGroupId;
            $updateData['user_group'] = 'Individuals';
        }
    }
    
    // User role --> Demo role
    else if ($currentUserData['user_type'] == 'user' && $updateData['user_type'] == 'demo') {
        // Force switch to Demo group and inherit its password
        $updateData['group_id'] = $demoGroupId;
        $stmt = $pdo->prepare("SELECT group_name, group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
        $stmt->execute([$demoGroupId]);
        $demoGroupData = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($currentUserData['group_id'] != $individualsGroupId) {
            $extraUpdates[] = "previous_group = :prev_group";
            $extraParams[':prev_group'] = $currentUserData['group_id'];
        }
        
        $extraUpdates[] = "user_pass = :demo_pass";
        $extraUpdates[] = "user_pass_clear = :demo_pass_clear";
        $extraUpdates[] = "group_id = :demo_group_id";
        $extraUpdates[] = "user_group = :demo_group_name";
        
        $extraParams[':demo_pass'] = $demoGroupData['group_pass'];
        $extraParams[':demo_pass_clear'] = $demoGroupData['group_pass_clear'];
        $extraParams[':demo_group_id'] = $demoGroupId;
        $extraParams[':demo_group_name'] = $demoGroupData['group_name'];
        
        // Update group_id in the main update data too
        $updateData['user_group'] = $demoGroupData['group_name'];
    }

    // Build the SQL
    $sql = "UPDATE wp_users SET 
            user_email = :user_email,
            first_name = :first_name,
            last_name = :last_name,
            user_group = :user_group,
            user_type = :user_type,
            group_id = :group_id";
            
    if (!empty($extraUpdates)) {
        $sql .= ", " . implode(", ", $extraUpdates);
    }
    
    $sql .= " WHERE id = :id";

    // Combine all parameters
    $executeArray = [
        ':user_email' => $updateData['user_email'],
        ':first_name' => $updateData['first_name'],
        ':last_name' => $updateData['last_name'],
        ':user_group' => $updateData['user_group'],
        ':user_type' => $updateData['user_type'],
        ':group_id' => $updateData['group_id'],
        ':id' => $userId
    ];
    
    if (!empty($extraParams)) {
        $executeArray = array_merge($executeArray, $extraParams);
    }

// Use a direct query approach that avoids the duplicate key error
if (isset($_POST['userEmail']) && $_POST['userEmail'] === $currentUserData['user_email']) {
    // If email isn't changing, use a different query that excludes the email field
    $sql = "UPDATE wp_users SET 
            first_name = :first_name,
            last_name = :last_name,
            user_group = :user_group,
            user_type = :user_type,
            group_id = :group_id";
            
    if (!empty($extraUpdates)) {
        $sql .= ", " . implode(", ", $extraUpdates);
    }
    
    $sql .= " WHERE id = :id";
    
    // Remove email from parameters
    if (isset($executeArray[':user_email'])) {
        unset($executeArray[':user_email']);
    }
}

$stmt = $pdo->prepare($sql);
$result = $stmt->execute($executeArray);

    if ($result) {
        // If this is group admin's email (email matches group email), update user too
        if ($_POST['userEmail'] !== $currentUserData['user_email']) {
            $stmt = $pdo->prepare("SELECT id FROM wp_groups WHERE group_email = ?");
            $stmt->execute([$currentUserData['user_email']]);
            
            if ($stmt->rowCount() > 0) {
                // This is the group admin email, update group's email
                $stmt = $pdo->prepare("UPDATE wp_groups SET group_email = ? WHERE group_email = ?");
                $stmt->execute([$_POST['userEmail'], $currentUserData['user_email']]);
            }
        }

        echo json_encode(['success' => true, 'data' => $updateData]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to update user']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
}