<?php

	/* ***************** SESSION LOGIC ******************/

	function safeRedirect($url) {
		if (!headers_sent()) {
			header("Location: $url");
		} else {
			echo "<script>window.location.href='$url';</script>";
		}
		exit();
	}

	// Function to check if all required session variables are set
	function isValidSession() {
		$required_vars = ['front_user_id', 'user_type'];
		foreach ($required_vars as $var) {
			if (!isset($_SESSION[$var])) {
				return false;
			}
		}
		return true;
	}

	// Check session validity before any output
	if (!isValidSession()) {
		safeRedirect(BASEURL . 'login.php');
	}


	try {
		$pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$obj_users = new Users($pdo);
	} catch(PDOException $e) {
		die("Connection failed: " . $e->getMessage());
	}

	$obj_users = new Users($pdo);
	
	if(!$obj_users->checkUserLoginOrNot()){
	    header('Location: '.BASEURL.'login.php');
	} 
	
	// Logout logic
	if (isset($_GET['logout'])) {
		// Destroy the session
		session_unset();
		session_destroy();
		header("Location: ../login.php"); // Redirect to the login page
		exit();
	}
	
	if($_SESSION['user_type']!='super' && $_SESSION['user_type']!='admin'){ 
		session_destroy();
		header('Location: '.BASEURL.'login.php');
		exit();
	}
	
	if($_SESSION['user_type'] == 'super') {
	    $usertype = 'super';
	} else if($_SESSION['user_type'] == 'admin') {
	    $usertype = 'admin';
	}
	
	
	/******************************************************************/
	/* ***************** FROM USERS AND GROUPS PAGES ******************/
	
	$groupWhere = "";
	
	if($_SESSION['user_type'] == 'super') {
		$groupWhere = "";  // Super admin sees all groups
	} else if($_SESSION['user_type'] == 'admin') {
		$groupWhere = " WHERE user_group = '".$_SESSION['user_group']."' ";  // Regular admin only sees their group
	}
	
	if (isset($_GET["groupsort"]) && !empty($_GET["groupsort"])){
		if ($_GET["groupsort"] === "ORDER BY user_group asc") {
			 $groupSort = "ORDER BY user_group asc, user_email asc";
			 $groupSortNext = "ORDER BY user_group desc";
			 $groupLabel = "Sort Down";
			 $groupSortSimple = "user_group asc, ";
		} else {
			 $groupSort = "ORDER BY user_group desc, user_email asc";
			 $groupSortNext = "ORDER BY user_group asc";
			 $groupLabel = "Sort Up";
			 $groupSortSimple = "user_group desc, ";
		}
	}
	else {
		  $groupSort = "";
		  $groupSortNext = "ORDER BY user_group desc";
		  $groupLabel = "Sort Down";
		  $groupSortSimple = "";
	}

	if (isset($_GET["emailsort"]) && !empty($_GET["emailsort"])){
		if ($_GET["emailsort"] === "ORDER BY user_email asc") {
			 $emailSort = "ORDER BY user_email asc";
			 $emailSortNext = "ORDER BY user_email desc";
			 $emailLabel = "Sort Down";
		}
		else {
			 $emailSort = "ORDER BY user_email desc";
			 $emailSortNext = "ORDER BY user_email asc";
			 $emailLabel = "Sort Up";
		}
	}
	else {
		  $emailSort = "";
		  $emailSortNext = "ORDER BY $groupSortSimple user_email desc";
		  $emailLabel = "Sort Down";
	}


	if  (!isset($_GET["emailsort"]) && !isset($_GET["groupsort"])) {
		  $emailSort = "ORDER BY user_email asc";
		  $emailSortNext = "ORDER BY user_email desc";
		  $emailLabel = "Sort Down";
	}

	/******************************************************************/
	
?>