CaseData[12] = {
    "title": "Case 12 - 53 year old obese male for colectomy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "\nFrom the physical exam, this patient has a potentially difficult intubation. Regional anesthesia would be difficult for this procedure. General anesthesia delivered by mask would avoid airway instrumentation but would be difficult and would not protect against aspiration. Laryngeal mask airway does not prevent aspiration either. The choice is whether to secure the airway prior to induction of anesthesia and risk triggering bronchospasm or intubate under deep general anesthesia and risk losing control of the airway and aspiration. While bronchospasm may be difficult, hypoxia is definitely to be avoided. Therefore, intubate prior to induction of general anesthesia if management of the airway is a major concern.\n\nThe differential diagnosis for intubated but hard to ventilate includes obstruction of the endotracheal tube due to kinking, plugging, or positioning; and problems with the breathing circuit such as obstruction or malfunctioning valve. You must rule out these problems before assuming that the problem is bronchospasm. Once you are sure the problem is bronchospasm, treat by deepening the inhalation agent and administering multiple puffs of albuterol.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "fsmFlag": false, 
    "helpFlag": true, 
    "imageSet": 4, 
    "initialSat": 96, 
    "leanBodyMass": 100, 
    "learningObj": "\n53 year old obese male for colectomy (150 kg)\n\nThis patient presents a difficult set of problems: asthma and a potentially difficult intubation.\n\nLearning Objectives\n1. Describe anesthetic management of asthma.\n2. Describe the management of a patient with asthma and potentially difficult airway.\n\nAnesthetic Considerations\n1. Asthma\n2. Potentially difficult intubation\n\nFrom the physical exam, this patient has a potentially difficult intubation. Regional anesthesia would be difficult for this procedure. General anesthesia delivered by mask would avoid airway instrumentation but would be difficult and would not protect against aspiration. Laryngeal mask airway does not prevent aspiration either. The choice is whether to secure the airway prior to induction of anesthesia and risk triggering bronchospasm or intubate under deep general anesthesia and risk losing control of the airway and aspiration. While bronchospasm may be difficult, hypoxia is definitely to be avoided. Therefore, intubate prior to induction of general anesthesia if management of the airway is a major concern.\n\nSuggested Anesthetic Plan\n1. Routine monitoring plus direct arterial pressure\n2. Oxygen by mask\n3. Treat with inhaled beta-agonist\n4. Carefully sedate with benzodiazepines for patient cooperation.\n5. Very careful, gentle, and thorough topical anesthesia of the airway.\n6. Fiberoptic intubation\n7. Induce anesthesia with propofol \n8. Maintain deep anesthesia with narcotics, inhalation agent, and competitive neuromuscular blocker\n9. Extubate promptly after return of airway reflexes.\n\nDifferential Diagnosis of Bronchospasm - Not all Wheezing is Bronchospasm.\n1. Obstructed ETT - kinking, secretions, cuff\\\n2. Endobronchial intubation\n3. Bronchial asthma\n4. Bronchospasm due to inadequate anesthesia, airway manipulation, or predisposing medications such as anticholinesterase, tubocurarine, morphine, barbiturates\n5. Pulmonary edema\n6. Aspiration\n7. Pneumothorax\n\nTreatment of Bronchospasm\n1. Hand ventilate to rule out mechanical problem with ventilator\n2. Check anesthesia circuit and valves - if possible use ambu bag\n3. Check location of endotracheal tube - auscultate and confirm end-tidal CO2\n4. Pass suction catheter or fiberoptic scope down the endotracheal tube to rule out obstruction\n5. Inhaled beta-agonists\n6. Deepen anesthesia\n\nDifficult Airway\n1. The unconscious or paralyzed patient with a difficult airway will be hard to ventilate and intubate. It is best to anticipate this situtation by careful preoperative examination and secure the airway prior to induction of anesthesia.\n2. Management options for `awake' intubation include oral laryngoscopy, blind nasal, and fiberoptic intubation. Don't forget to use some sedatives and topical anesthesia.\n3. If you can't ventilate and can't intubate the patient, call for help immediately. Try to establish a clear airway with maneuvers such as neck extension, jaw lift, and oral and nasal airways. Try a couple different laryngoscope blades. If these attempts fail or if the patient desaturates, place a laryngeal mask airway or perform a cricothyroidotomy and use jet ventilation. Do not persist with direct laryngoscopy too long. If direct visualization proves very difficult cricothyroidotomy must be performed early.\n4. Once a laryngeal mask airway has been placed you may be able to insert an endotracheal tube through the LMA using fiberoptic  guidance.\n5. Alternatively, a retrograde intubation can be performed by passing a wire through the cricothyroid catheter up into the mouth. Run the wire into the suction port of a fiberoptic bronchoscope and guide the scope through the vocal cords. Remove the wire when the scope is in the trachea. Advance the scope until the carina is visualized and advance the endotracheal tube over the bronchoscope.\n6. The patient must be informed that a difficult airway was encountered and a letter should be placed in the medical record.\n\nReferences\n1. Wittels: Obstructive sleep apnea and obesity. Otolaryngol Clin North Am 1990; 23: 751\n2. Bishop. Bronchospasm: avoiding an anesthetic disaster. ASA Refresher Courses in Anesthesiology.\n3. Eames: Effect of etomidate, propofol, and thiopental on respiratory resistance. Anesthesiology 1996; 84: 1307.\n4. Rooke, Choi, Bishop: The effect of isoflurane, halothane, sevoflurane, and thiopental/nitrous oxide on respiratory system resistance after tracheal intubation. Anesthesiology 1997; 86(6):1294-9.\n5. Eames, Rooke, Wu, Bishop: Comparison of the effects of etomidate, propofol, and thiopental on respiratory resistance after tracheal intubation. Anesthesiology 1996; 84(6):1307-11.\n6. Bishop, Rooke: Sevoflurane for patients with asthma. Anesth Analg 2000; 91(1):245-6. \n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September 2024\n\n", 
    "possiblePoints": 1200, 
    "preopMsg": "\n53 year old obese male for colectomy\n\nThe patient is scheduled for colon resection. The patient also has a history of heroic snoring.\n\nPast Medical History\nIllnesses: severe asthma, requires albuterol inhaler and several epinephrine injections in the emergency room last year.\nSurgeries: none\nMeds: albuterol inhaler\nHabits: denies smoking, drinking, and intravenous drugs\nAllergies: no known drug allergies\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nShort, obese male     Height: 5'0\"  Weight: 150 kg\nHR:108       BP:126/60     RR:20\nAirway : short, fat neck, poor mouth opening\nMallampati class 4\nLungs : clear, no wheezing present \nHeart : normal\nNumerous scars\n\nLabs\nHCT: 40\nLytes, Glucose, Bun, Cr : normal\n\nNPO Status\nLast ate 12 hours ago.\n\nPatient and Surgeon Requests\nThe procedure requires general anesthesia. \nThe surgeon states the procedure will take 2 hours.\n\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen by mask and a sedative agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 23.8, 
            "baseHr": 92, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 520, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEIV", 
                    "comment": "You appropriately sedated this patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEINH", 
                    "comment": "You appropriately administered inhalation agent to sedate this patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You should have sedated the patient before performing fiberoptic intubation. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to place the LMA in this awake patient.  (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to perform laryngoscopy in an awake patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You allowed the surgeon to make the incision before the patient was adequately anesthetized. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have administered neuromuscular blocker to an awake patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKECOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and sedate.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 520, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You should have sedated the patient before performing fiberoptic intubation. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEHURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 520, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You should have sedated the patient before performing fiberoptic intubation. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You intubated using the fiberoptic bronchoscope. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "The patient is intubated.", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "LMAIV", 
                    "comment": "You inserted the LMA to rescue the airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBED", 
            "whatNextMsg": "Induce anesthesia and observe closely for bronchospasm.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Fiberoptic intubation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 500, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "You induced anesthesia primarily with intravenous agents. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "TUBEDINH", 
                    "comment": "You induced anesthesia primarily with inhalation anesthetics. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.3
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEHURT", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is reacting to the endotracheal tube.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Autonomic response to tracheal stimulation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 93, 
            "spSignal": 2, 
            "spontRr": 10, 
            "spontTv": 520, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBED", 
                    "comment": "You induced anesthesia. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEIV", 
            "whatNextMsg": "Secure the airway with fiberoptic intubation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 97, 
            "sat100": 100, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 500, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You should have secured the airway before inducing anesthesia. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You performed fiberoptic intubation. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You performed fiberoptic intubation. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEINH", 
            "whatNextMsg": "Secure the airway with fiberoptic intubation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You should not have induced anesthesia before securing the airway in this patient. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.5
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You should not have induced anesthesia before securing the airway in this patient. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.3
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You performed fiberoptic intubation in this sedated patient. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATECOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 520, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEIV", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEHURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 520, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEIV", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEPARA", 
            "whatNextMsg": "Now perform quick fiberoptic bronchoscopy.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 114, 
            "baseAbpS": 168, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBEDIV", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "LMAIV", 
                    "comment": "You rescued the airway with an LMA. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You deepened the anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "whatNextMsg": "Perform quick fiberoptic intubation, or rescue the airway with LMA. Perform cricothyroidotomy if unable to otherwise rescue.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 68, 
            "contPlateau": 66, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized. Unable to intubate, unable to ventilate.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 74, 
            "sat100": 78, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "LMAIV", 
                    "comment": "You placed the LMA to establish an emergent airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "You performed fiberoptic intubation in a deeply sedated patient with a difficult airway. Better to lightly sedate and maintain spontaneous ventilation. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You attempted oral laryngoscopy unsuccessfully. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You waited too long to establish the airway. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "whatNextMsg": "Perform quick fiberoptic intubation, or rescue the airway with LMA. Perform cricothyroidotomy if unable to otherwise rescue.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 68, 
            "contPlateau": 66, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 68, 
            "sat40": 72, 
            "sat100": 76, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered intravenous anesthetic agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered a NMB agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "LMAINH", 
                    "comment": "You placed the LMA to establish an emergent airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You unsuccessfully attempted oral laryngoscopy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "TUBEDINH", 
                    "comment": "You successfully placed the endotracheal tube with the fiberoptic bronchoscope. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have established an airway faster. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "LMAIV", 
            "whatNextMsg": "Provide adequate anesthesia and instruct the surgeon to make the incision.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "LMA in place.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPLMAIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points). Endotracheal tube is preferred over LMA for colectomy. Do this case again.", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPLMAIV", 
                    "comment": "You instructed the surgeon to operate.  Endotracheal tube is preferred over LMA for colectomy. Do this case again.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEDIV", 
            "whatNextMsg": "Provide adequate anesthesia and instruct the surgeon to make the incision.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 42, 
            "contPlateau": 40, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and intubated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 94, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEDINH", 
            "whatNextMsg": "Provide adequate anesthesia and instruct the surgeon to make the incision.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and intubated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "LMAINH", 
            "whatNextMsg": "Provide adequate anesthesia and instruct the surgeon to make the incision.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "LMA placed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 93, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPLMAINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points).  Endotracheal tube is preferred over LMA for colectomy. Do this case again.", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPLMAINH", 
                    "comment": "You instructed the surgeon to operate.  Endotracheal tube is preferred over LMA for colectomy. Do this case again.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPLMAIV", 
            "whatNextMsg": "Endotracheal tube is preferred over LMA for colectomy.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Surgery proceeding with LMA.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 88, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "OPIV", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "BS1IV", 
                    "comment": "The simulation forced the patient to develop bronchospasm.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "BS1INH", 
                    "comment": "The simulation forced the patient to develop bronchospasm.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPLMAINH", 
            "whatNextMsg": "Endotracheal tube is preferred over LMA for colectomy.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 76, 
            "baseAbpS": 104, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Surgery proceeding with LMA.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 93, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "BS1IV", 
            "whatNextMsg": "Suction the endotracheal tube, check the tube position, and check the circuit.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 124, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Severe wheezing bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 1, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "BS2IV", 
                    "comment": "You suctioned the ETT, checked the ETT depth, and checked the circuit. (+200 points)", 
                    "conditions": [
                        {
                            "type": "suction", 
                            "value": true
                        }, 
                        {
                            "type": "checkTube", 
                            "value": true
                        }, 
                        {
                            "type": "checkCircuit", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "BS2IV", 
                    "comment": "You examined and suctioned the ETT with the fiberoptic scope, and checked the circuit. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }, 
                        {
                            "type": "checkCircuit", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "BS1INH", 
            "whatNextMsg": "Suction the endotracheal tube, check the tube position, check the circuit.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Severe wheezing bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "BS2INH", 
                    "comment": "You suctioned the ETT, checked the ETT depth, and checked the circuit. (+200 points)", 
                    "conditions": [
                        {
                            "type": "suction", 
                            "value": true
                        }, 
                        {
                            "type": "checkTube", 
                            "value": true
                        }, 
                        {
                            "type": "checkCircuit", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "BS2INH", 
                    "comment": "You examined and suctioned the ETT with the fiberoptic scope, and checked the circuit. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }, 
                        {
                            "type": "checkCircuit", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "BS1IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "BS1IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HYPO", 
            "whatNextMsg": "You must treat the bronchospasm faster. Try this case again.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 72, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 58, 
            "contPlateau": 56, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypotensive due to low venous return due to high intrathoracic pressure.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 78, 
            "sat40": 83, 
            "sat100": 85, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASYST", 
                    "comment": "The rhythm degenerated to asystole.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ASYST", 
            "whatNextMsg": "Notify the family. End of case simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 58, 
            "contPlateau": 56, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "BS2IV", 
            "whatNextMsg": "Administer deep inhalation anesthetic and bronchodilator such as albuterol inhaler.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Severe wheezing bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 44, 
            "contPlateau": 42, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm. Tube and circuit problems ruled out.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INHALERIV", 
                    "comment": "You administered multiple puffs of albuterol inhaler. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DEEPIV", 
                    "comment": "You administered deep inhalation anesthetic. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "BS2INH", 
            "whatNextMsg": "Administer deep inhalation anesthetic and bronchodilator such as albuterol inhaler.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Severe wheezing bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 44, 
            "contPlateau": 42, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm. Tube and circuit problems ruled out.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INHALERINH", 
                    "comment": "You administered multiple puffs of albuterol inhaler. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DEEPINH", 
                    "comment": "You administered deep inhalation anesthetic. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "BS2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "BS2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INHALERIV", 
            "whatNextMsg": "Bronchodilator administered. Now deepen the inhalation agent.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Wheezing is improving.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm, but improving after bronchodilator administration.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPINHALERIV", 
                    "comment": "You administered deep inhalation anesthetic. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.3
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEPIV", 
            "whatNextMsg": "You deepened the inhalation agent. Now administer bronchodilator.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 78, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Wheezing is improving.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm, but improving after increasing depth of inhalation agent.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPINHALERIV", 
                    "comment": "You administered multiple puffs of albuterol inhaler. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEPINH", 
            "whatNextMsg": "You deepened the inhalation agent. Now administer bronchodilator.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 78, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Wheezing is improving.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm, but improving after increasing depth of inhalation agent.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPINHALERINH", 
                    "comment": "You administered multiple puffs of albuterol inhaler. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INHALERINH", 
            "whatNextMsg": "Bronchodilator administered. Now deepen the inhalation agent.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Wheezing is improving.", 
            "cardiacOutput": 5.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm, but improving after bronchodilator administration.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 380, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEEPINHALERINH", 
                    "comment": "You administered deep inhalation anesthetic. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 1.3
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HYPO", 
                    "comment": "The simulation forced the patient to develop severe hypotension. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DEEPINHALERIV", 
            "whatNextMsg": "Bronchodilator administered, inhalation agent deepened. End of case simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 78, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are now clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Bronchospasm is resolved.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "DEEPINHALERINH", 
            "whatNextMsg": "Bronchodilator administered. Inhalation agent deepened. End of case simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 78, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are now clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severe bronchospasm resolved.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 94, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 380, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "CRIC", 
            "whatNextMsg": "You should do this case again. It should not have been necessary to perform cricothyroidotomy.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Cricothyroidotomy performed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 500, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 71, 
            "sat100": 72, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATDEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATDEAD", 
            "whatNextMsg": "Notify the family.", 
 			"airwayStr": "obstructed",
           "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ], 
    "volAnDsp": 80
}