CaseData[11] = {
    "title": "Case 11 - 74 year old with aortic stenosis for colon resection", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "\nPremedicate to prevent tachycardia.  Use routine monitoring plus direct arterial pressure. Consider PA catheter for LV filling pressure and SVR. However, there is an increased risk of arrhythmias with PA catheter.  Administer fluid bolus to restore intravascular volume.  Preoxygenate, induce anesthesia with minimum dose of propofol, administer relaxant, and intubate. Maintain anesthesia with a moderate amount of narcotics, with roughly half MAC potent inhalation agent as tolerated. Maintain adequate preload.  Keep heart rate down and SVR up - use phenylephrine as needed. Treat hypotension immediately.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 7, 
    "initialSat": 96, 
    "leanBodyMass": 88, 
    "learningObj": "\n74 year old with aortic stenosis\n\nThis patient has moderately severe aortic stenosis, but denies symptoms except for one syncopal episode. \n\nLearning Objectives\n1. Describe the pathophysiology of aortic stenosis.\n2. List the general anesthetic considerations for aortic stenosis.\n\nPathophysiology of Aortic Stenosis\n1. The tight aortic valve obstructs flow from the left ventricle to the aorta creating a pressure gradient. \n2. Left ventricular compliance is reduced and filling pressure rises as the wall thickens.  \n3. Hypotension can lead to rapid spiral of ischemia, worsened hypotension, and further ischemia.\n\nClinical Presentation of Aortic Stenosis\n1. Angina - initial symptom in 50-70% of cases\n2. Syncope - initial symptom in 15-30% of cases, life expectancy 3-4 years\n3. Congestive heart failure - life expectancy 1-2 years\n\nEvaluation of Aortic Stenosis\n1. Mild - asymptomatic with physiologic compensatory left ventricular hypertrophy\n2. Moderate - symptomatic impairment with left ventricular dilation as well as hypertrophy; valve  area 0.7-0.9 sq cm\n3. Severe - increased LVEDP with decreased stroke  volume and increased left atrial pressures (25-30 mmHg) leading to pulmonary edema; valve area < 0.5 sq cm. Blood flow is not impeded until valve area falls below 0.5-0.7 sq cm.\n4. All asymptomatic patients with valve area <0.7 sq cm or an aortic valve gradient > 50 mmHg should have an elective aortic valve replacement since only 18% of these patients are alive five years after diagnosis.\n\nAnesthetic Considerations for Aortic Stenosis\n1. Maintain sinus rhythm if possible. Atrial kick is important - may contribute 40% of left ventricular filling.\n2. Avoid tachycardia - high heart rate aggravates ischemia and decreases filling.\n3. Maintain adequate preload, but avoid pulmonary edema\n4. Maintain high SVR for adequate perfusion pressure. Left ventricular afterload is fixed by the valve area.\n5. Avoid myocardial depression\n\nSuggested Anesthetic Plan\n1. Premedicate to prevent tachycardia\n2. Routine monitoring plus direct arterial pressure. Consider PA catheter for LV filling pressure and SVR. However, there is an increased risk of arrhythmias with PA catheter.\n3. Administer fluid bolus to restore intravascular volume.\n4. Preoxygenate\n5. Moderate amount of narcotics, with roughly half MAC potent inhalation agent\n6. Maintain adequate preload\n7. Keep heart rate down and SVR up - use phenylephrine\n8. Treat hypotension immediately\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September 2024\n\n", 
    "possiblePoints": 800, 
    "preopMsg": "\n74 year old with aortic stenosis for colon resection\n\nMurmur first detected 5 years ago, but denies chest pain, shortness of breath, or decreased exercise tolerance. Passed out once on golf course on an especially hot day. Neuro evaluation was negative.\n\nPast Medical History\nIllnesses: none\nSurgeries: appendectomy - uneventful general anesthesia, herniorrhaphy - uneventful spinal anesthetic\nMeds: none\nHabits: denies smoking and drinking; denies using intravenous drugs.\nNo known drug allergies\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nWeight: 88 Kg   HR: 76   BP: 145/85  RR: 20\nAirway : normal\nLungs: clear\nHeart: Loud systolic crescendo-decrescendo murmur over LLSB\n\nLabs\nHCT: 39      BUN: 26   Cr: 1.5     Lytes, Glucose : normal\nCXR: Cardiomegaly\nECG: sinus rhythm, left ventricular hypertrophy\nEcho: LVH, good contractility, 40 mmHg aortic valve gradient, 0.8 sq cm aortic valve area\n\nNPO Status\nLast ate 13 hours ago and received bowel prep overnight.\n\nPatient and Surgeon Requests\nThe surgeon scheduled the procedure for three hours.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "VERYDRY", 
            "whatNextMsg": "Rehydrate prior to induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 96, 
            "baseBicarb": 23.8, 
            "baseHr": 118, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 3, 
            "pulseMsg": "The pulse is weak and rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry but has slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUIDS1", 
                    "comment": "You partially rehydrated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 299
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEVERYDRY", 
                    "comment": "You administered a sedative agent. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "FLUIDS1", 
            "whatNextMsg": "Continue to administer fluids until vital signs stabilize.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 78, 
            "baseAbpS": 106, 
            "baseBicarb": 23.8, 
            "baseHr": 108, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 15, 
            "papW": 5, 
            "pulseMsg": "The pulse is stronger but still fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Partially rehydrated.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUIDS2", 
                    "comment": "You adequately rehydrated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 599
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "FLUIDS2", 
            "whatNextMsg": "Preoxygenate, induce general anesthesia and intubate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 86, 
            "baseAbpS": 116, 
            "baseBicarb": 23.8, 
            "baseHr": 96, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 34, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 9, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized  patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEVERYDRY", 
            "whatNextMsg": "Rehydrate this patient prior to induction of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 23.8, 
            "baseHr": 128, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is fast but weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated but not rehydrated.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 8, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia before replacing volume. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEFLUIDS1", 
                    "comment": "You partially rehydrated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 299
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEFLUIDS1", 
            "whatNextMsg": "Administer additional intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 78, 
            "baseAbpS": 102, 
            "baseBicarb": 23.8, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 15, 
            "papW": 5, 
            "pulseMsg": "The pulse is fast and weak.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Partially rehydrated and sedated.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEFLUIDS2", 
                    "comment": "You administered adequate volume replacement. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 599
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPFLUIDS1", 
                    "comment": "You induced anesthesia prior to adequately replacing volume. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an under anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You administered muscle relaxant before completely inducing unconsciousness. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an under anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "SEDATEFLUIDS2", 
            "whatNextMsg": "Preoxygenate, induce anesthesia and intubate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 70, 
            "baseAbpM": 84, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 32, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is sedated but responsive.", 
            "papD": 9, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 8, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1", 
                    "comment": "You induced anesthesia after adequately treating hypovolemia.  (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to operate on an inadequately anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You should not have tried to intubate a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 94, 
            "baseAbpM": 112, 
            "baseAbpS": 132, 
            "baseBicarb": 23.8, 
            "baseHr": 122, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing. ST depression is present.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": -2.2, 
            "stSegV5": -2.8, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VERYDRY", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "The sedative agent is starting to take effect. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "PARA5", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Administer narcotic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 118, 
            "baseAbpS": 182, 
            "baseBicarb": 23.8, 
            "baseHr": 132, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain. ST depression is present.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": -2.2, 
            "stSegV5": -2.8, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VERYDRY", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia before adequately replacing volume. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PARA5", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 104, 
            "baseAbpM": 126, 
            "baseAbpS": 142, 
            "baseBicarb": 23.8, 
            "baseHr": 120, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is fast", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.4, 
            "stSegV5": 0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VERYDRY", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPVERYDRY", 
                    "comment": "You induced anesthesia without adequately replacing volume. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPFLUIDS1", 
            "whatNextMsg": "Administer fluids and pressors to resuscitate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized but only partially rehydrated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You appropriately administered phenylephrine. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 99
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You administered ephedrine appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You administered epinephrine apprpriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 20
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You started a dobutamine infusion appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 5
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1", 
                    "comment": "You administered fluids appropriately. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 599
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You started a dopamine infusion appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 5
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You started a phenylephrine infusion appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You started a norepinephrine infusion appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "ASLEEPVERYDRY", 
            "whatNextMsg": "Resuscitate with volume replacement and pressors.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 48, 
            "baseAbpS": 68, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is weak.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized without fluid replacement. The patient is now hypotensive and has ST depression.", 
            "rhythm": "St2", 
            "skinMsg": "The skin is warm and dry with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 97, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3.2, 
            "stSegV5": -3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "You should have treated the hypotension faster (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEPFLUIDS1", 
                    "comment": "You appropriately administered volume. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 299
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "You administered ephedrine appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "You administered phenylephrine appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 99
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "You administered epinephrine rather than phenylephrine to treat the hypotension. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 101
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You administered an excessive dose of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 100
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "Dopamine infusion started appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "Dobutamine administered appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "Phenylephrine infusion started appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPRESS", 
                    "comment": "Norepinephrine infusion started appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "VFIB", 
            "whatNextMsg": "Call for help and call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Cardiac arrest!", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is cool and mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 93, 
            "sat100": 97, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0, 
            "stSegV5": 0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "The rhythm degenrated to asystole. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "GA1", 
            "whatNextMsg": "Secure the airway.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.",  
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is slowed.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 18, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "The patient was inadequately anesthetized when then incision was made. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "GA1SECURE", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 88, 
            "baseAbpS": 112, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is slowed.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 18, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered adequate anesthetic for this patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.5
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "St2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 96, 
           "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You deepened the anesthetic appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.5
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "You waited too long to deepen the anesthetic. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "GA2", 
            "whatNextMsg": "Inform the surgeon when the patient is ready for surgery.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 90, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You instructed the surgeon to make the incision appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA3", 
                    "comment": "You instructed the surgeon to operate. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA3", 
            "whatNextMsg": "Maintenance anesthesia - monitor closely and adjust as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA4", 
                    "comment": "You administered an excessively deep anesthetic. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 3
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA4", 
            "whatNextMsg": "Excessively deep anesthesia during maintenance. Decrease anesthetic depth.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 10, 
            "papS": 20, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Very deeply anesthetized.", 
            "rhythm": "St2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You lightened the anesthetic depth appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.8
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9
        }, 
        {
            "name": "ASLEEPPRESS", 
            "whatNextMsg": "Administer fluids to resuscitate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 2, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Still hypotensive.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPFLUIDSPRESS", 
                    "comment": "You successfully resuscitated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 599
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "You delayed treatment too long. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 360
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPFLUIDSPRESS", 
            "whatNextMsg": "Now secure the airway.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 80, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 18, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully intubated the patient. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You successfully placed a laryngeal mask airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "A laryngeal mask airway was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "An endotracheal tube was placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ST3", 
                    "comment": "You delayed securing the airway for too long. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "GA1SECURE", 
                    "comment": "You performed a fiberoptic intubation. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "ST3", 
            "whatNextMsg": "The patient will be difficult to resuscitate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 136, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 3, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, with loud systolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 4, 
            "papM": 6, 
            "papS": 12, 
            "papW": 3, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Deep St depression and hypotension.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VFIB", 
                    "comment": "The rhythm degenerated to ventriculat fibrillation.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }
            ]
        }
    ]
}